/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.cli;

import org.apache.uima.ducc.IErrorHandler;
import org.apache.uima.ducc.cli.IUiOption;
import org.apache.uima.ducc.transport.event.cli.JobReplyProperties;
import org.apache.uima.ducc.transport.event.cli.JobRequestProperties;
import org.apache.uima.ducc.transport.event.cli.JobSpecificationProperties;
import org.apache.uima.ducc.transport.event.cli.ReservationRequestProperties;
import org.apache.uima.ducc.transport.event.cli.ReservationSpecificationProperties;
import org.apache.uima.ducc.transport.event.cli.ServiceRequestProperties;
import org.apache.uima.ducc.transport.event.cli.SpecificationProperties;

public interface IUiOptions {
    public static final int help_width = 120;

    public static enum UiOption implements IUiOption
    {
        Administrators{

            @Override
            public String pname() {
                return "administrators";
            }

            @Override
            public String argname() {
                return "list of ids";
            }

            @Override
            public String description() {
                return "Blank-delimited list of userids allowed to manage this service.";
            }

            @Override
            public String example() {
                return "bob mary jimbo";
            }
        }
        ,
        AllInOne{

            @Override
            public String pname() {
                return "all_in_one";
            }

            @Override
            public String argname() {
                return "local|remote";
            }

            @Override
            public String description() {
                return "Run driver and pipeline in single process.";
            }
        }
        ,
        AttachConsole{

            @Override
            public String pname() {
                return "attach_console";
            }

            @Override
            public boolean optargs() {
                return true;
            }

            @Override
            public String deflt() {
                return "true";
            }

            @Override
            public String description() {
                return "If specified, redirect remote stdout and stderr to the local submitting console.";
            }
        }
        ,
        Autostart{

            @Override
            public String pname() {
                return "autostart";
            }

            @Override
            public String argname() {
                return "boolean: true or false";
            }

            @Override
            public String description() {
                return "If True, start the service when DUCC starts.";
            }
        }
        ,
        CancelOnInterrupt{

            @Override
            public String pname() {
                return SpecificationProperties.key_cancel_on_interrupt;
            }

            @Override
            public boolean optargs() {
                return true;
            }

            @Override
            public String deflt() {
                return "true";
            }

            @Override
            public String description() {
                return "Cancel on interrupt (Ctrl-C). Implies " + WaitForCompletion.pname();
            }
        }
        ,
        Classpath{

            @Override
            public String pname() {
                return JobSpecificationProperties.key_classpath;
            }

            @Override
            public String description() {
                return "Classpath for the Job. Default is current classpath.";
            }

            @Override
            public String argname() {
                return "java classpath";
            }
        }
        ,
        Debug{

            @Override
            public String pname() {
                return "debug";
            }

            @Override
            public boolean noargs() {
                return true;
            }

            @Override
            public String description() {
                return "Enable CLI Debugging messages.";
            }
        }
        ,
        DjPid{

            @Override
            public String pname() {
                return JobRequestProperties.key_dpid;
            }

            @Override
            public String argname() {
                return "number";
            }

            @Override
            public String description() {
                return "DUCC Process Id.  If specified only this DUCC process will be canceled.  If not specified, then entire job will be canceled.";
            }

            @Override
            public String example() {
                return "22";
            }
        }
        ,
        DriverDebug{

            @Override
            public String pname() {
                return "driver_debug";
            }

            @Override
            public String argname() {
                return "debugger-port-number";
            }

            @Override
            public String description() {
                return "Listening port number the remote driver process is to connect to.";
            }

            @Override
            public String example() {
                return "8001";
            }
        }
        ,
        Description{

            @Override
            public String pname() {
                return JobSpecificationProperties.key_description;
            }

            @Override
            public String argname() {
                return "string";
            }

            @Override
            public String description() {
                return "Description of the run.";
            }

            @Override
            public String example() {
                return "My excellent job!";
            }

            @Override
            public String deflt() {
                return "[Empty Description]";
            }
        }
        ,
        DriverDescriptorCR{

            @Override
            public String pname() {
                return JobSpecificationProperties.key_driver_descriptor_CR;
            }

            @Override
            public String description() {
                return "Driver (collection reader) descriptor.";
            }

            @Override
            public String argname() {
                return "descriptor xml";
            }

            @Override
            public String example() {
                return "/home/" + System.getProperty("user.name") + "/descriptors/MyCR.xml";
            }

            @Override
            public boolean required() {
                return true;
            }
        }
        ,
        DriverDescriptorCROverrides{

            @Override
            public String pname() {
                return JobSpecificationProperties.key_driver_descriptor_CR_overrides;
            }

            @Override
            public String argname() {
                return "list of overrides";
            }

            @Override
            public String description() {
                return "Driver Collection Reader configuration parameter name/value pair overrides. Parameters must already be defined in the CR descriptor.";
            }

            @Override
            public String example() {
                return "name1=value1 name2=\"value2a value2b value2c\" name3=value3...";
            }
        }
        ,
        DriverExceptionHandler{

            @Override
            public String pname() {
                return JobSpecificationProperties.key_driver_exception_handler;
            }

            @Override
            public String description() {
                return "Driver exception handler class.  Must implement " + IErrorHandler.class.getName();
            }

            @Override
            public String argname() {
                return "classname";
            }

            @Override
            public String example() {
                return "org.myOrg.myProject.MyErrorHandler";
            }
        }
        ,
        DriverExceptionHandlerArguments{

            @Override
            public String pname() {
                return JobSpecificationProperties.key_driver_exception_handler_arguments;
            }

            @Override
            public String argname() {
                return "list of arguments";
            }

            @Override
            public String description() {
                return "Blank-delimited list of arguments to be passed to the built-in or custom exception handler.  The example gives the defaults for the built-in exception handler.";
            }

            @Override
            public String example() {
                return "max_job_errors=15 max_timeout_retrys_per_workitem=0";
            }
        }
        ,
        DriverJvmArgs{

            @Override
            public String pname() {
                return JobSpecificationProperties.key_driver_jvm_args;
            }

            @Override
            public String argname() {
                return "jvm arguments";
            }

            @Override
            public String description() {
                return "Blank-delimited list of JVM Arguments passed to the job driver.";
            }

            @Override
            public String example() {
                return "-Xmx100M -DMYVAR=foo";
            }
        }
        ,
        Environment{

            @Override
            public String pname() {
                return JobSpecificationProperties.key_environment;
            }

            @Override
            public String argname() {
                return "env vars";
            }

            @Override
            public String description() {
                return "Blank-delimited list of environment variables.";
            }

            @Override
            public String example() {
                return "TERM=xterm DISPLAY=me.org.net:1.0 LANG UIMA*";
            }
        }
        ,
        Help{

            @Override
            public String pname() {
                return "help";
            }

            @Override
            public boolean noargs() {
                return true;
            }

            @Override
            public String description() {
                return "Print this help message";
            }
        }
        ,
        Instances{

            @Override
            public String pname() {
                return "instances";
            }

            @Override
            public String argname() {
                return "integer";
            }

            @Override
            public String description() {
                return "Number of service processes.";
            }
        }
        ,
        InstanceFailureLimit{

            @Override
            public String pname() {
                return "instance_failures_limit";
            }

            @Override
            public String description() {
                return "Number of consecutive instance failures that will cause the service to be stopped.";
            }

            @Override
            public String argname() {
                return "integer";
            }
        }
        ,
        InstanceInitFailureLimit{

            @Override
            public String pname() {
                return "instance_init_failures_limit";
            }

            @Override
            public String description() {
                return "Number of consecutive instance initialization failures that will cause SM to cease starting the service.";
            }

            @Override
            public String argname() {
                return "integer";
            }
        }
        ,
        InstanceFailureWindow{

            @Override
            public String pname() {
                return "instance_failures_window";
            }

            @Override
            public String argname() {
                return "integer";
            }

            @Override
            public String description() {
                return "Size of the window (in minutes) used to manage service instance runtime failures.";
            }

            @Override
            public String example() {
                return "30";
            }
        }
        ,
        JobId{

            @Override
            public String pname() {
                return JobRequestProperties.key_id;
            }

            @Override
            public String argname() {
                return "string";
            }

            @Override
            public String description() {
                return "The id of the job";
            }

            @Override
            public boolean required() {
                return true;
            }
        }
        ,
        ManagedReservationId{

            @Override
            public String pname() {
                return JobRequestProperties.key_id;
            }

            @Override
            public String argname() {
                return "string";
            }

            @Override
            public String description() {
                return "The id of the managed reservation";
            }

            @Override
            public boolean required() {
                return true;
            }
        }
        ,
        Jvm{

            @Override
            public String pname() {
                return JobSpecificationProperties.key_jvm;
            }

            @Override
            public String argname() {
                return "path-name-to-java";
            }

            @Override
            public String description() {
                return "The jvm to use.  Must be a full path to the 'java' executable.  Default is the jvm that DUCC is using.";
            }

            @Override
            public String example() {
                return "/opt/vendor/jdk-1.7/bin/java";
            }
        }
        ,
        LogDirectory{

            @Override
            public String pname() {
                return JobSpecificationProperties.key_log_directory;
            }

            @Override
            public String argname() {
                return "path";
            }

            @Override
            public String description() {
                return "The directory where logs are written.";
            }

            @Override
            public String deflt() {
                return "${HOME}/ducc/logs";
            }
        }
        ,
        Message{

            @Override
            public String pname() {
                return JobReplyProperties.key_message;
            }

            @Override
            public String argname() {
                return "string";
            }

            @Override
            public String description() {
                return "Orchestrator response string - internally generated.";
            }
        }
        ,
        Modify{

            @Override
            public String pname() {
                return "modify";
            }

            @Override
            public String argname() {
                return "service-id-or-endpoint";
            }

            @Override
            public String description() {
                return "Modify meta properties for a registered service.";
            }

            @Override
            public boolean required() {
                return true;
            }
        }
        ,
        Quiet{

            @Override
            public String pname() {
                return "quiet";
            }

            @Override
            public String argname() {
                return null;
            }

            @Override
            public boolean optargs() {
                return true;
            }

            @Override
            public String deflt() {
                return "true";
            }

            @Override
            public String description() {
                return "Disable CLI Informational messages.";
            }
        }
        ,
        Register{

            @Override
            public String pname() {
                return "register";
            }

            @Override
            public String argname() {
                return "specification-file";
            }

            @Override
            public boolean optargs() {
                return true;
            }

            @Override
            public String deflt() {
                return "";
            }

            @Override
            public String description() {
                return "Register a service.";
            }
        }
        ,
        ReservationId{

            @Override
            public String pname() {
                return JobRequestProperties.key_id;
            }

            @Override
            public String argname() {
                return "string";
            }

            @Override
            public String description() {
                return "The id of the reservation";
            }

            @Override
            public boolean required() {
                return true;
            }
        }
        ,
        ServicePingArguments{

            @Override
            public String pname() {
                return "service_ping_arguments";
            }

            @Override
            public String argname() {
                return "string";
            }

            @Override
            public String description() {
                return "Any (service-dependent) ping arguments, to be passed to the pinger.";
            }

            @Override
            public String example() {
                return "q_thresh=12,svc_thresh=.01";
            }
        }
        ,
        ServiceId{

            @Override
            public String pname() {
                return "service_id";
            }

            @Override
            public String argname() {
                return "number";
            }

            @Override
            public String description() {
                return "The numeric id of the service being spawned";
            }

            @Override
            public String example() {
                return "123";
            }
        }
        ,
        ServicePingClass{

            @Override
            public String pname() {
                return "service_ping_class";
            }

            @Override
            public String argname() {
                return "classname";
            }

            @Override
            public String description() {
                return "Class to ping ervice, must extend AServicePing.java";
            }

            @Override
            public String example() {
                return "org.bob.Pinger";
            }
        }
        ,
        ServicePingClasspath{

            @Override
            public String pname() {
                return "service_ping_classpath";
            }

            @Override
            public String argname() {
                return "classpath";
            }

            @Override
            public String description() {
                return "Classpath containing service_custom_ping class and dependencies.";
            }

            @Override
            public String example() {
                return "Bob.jar";
            }
        }
        ,
        ServicePingJvmArgs{

            @Override
            public String pname() {
                return "service_ping_jvm_args";
            }

            @Override
            public String argname() {
                return "java-system-property-assignments";
            }

            @Override
            public String description() {
                return "-D jvm system property assignments to pass to jvm";
            }

            @Override
            public String example() {
                return "-DxmX=3G -DxnS=1M";
            }
        }
        ,
        ServicePingTimeout{

            @Override
            public String pname() {
                return "service_ping_timeout";
            }

            @Override
            public String argname() {
                return "time-in-ms";
            }

            @Override
            public String description() {
                return "Time in milliseconds to wait for a ping to the service.";
            }
        }
        ,
        ServicePingDoLog{

            @Override
            public String pname() {
                return "service_ping_dolog";
            }

            @Override
            public String argname() {
                return "boolean";
            }

            @Override
            public String description() {
                return "If specified, log the pinger, else suppress the log.";
            }
        }
        ,
        ServiceTypeCustom{

            @Override
            public String pname() {
                return ServiceRequestProperties.key_service_type_custom;
            }

            @Override
            public String argname() {
                return null;
            }

            @Override
            public boolean optargs() {
                return true;
            }

            @Override
            public String description() {
                return "Service type - internally generated";
            }
        }
        ,
        ServiceTypeOther{

            @Override
            public String pname() {
                return ServiceRequestProperties.key_service_type_other;
            }

            @Override
            public String argname() {
                return null;
            }

            @Override
            public boolean optargs() {
                return true;
            }

            @Override
            public String description() {
                return "Service type - internally generated";
            }
        }
        ,
        ServiceTypeUima{

            @Override
            public String pname() {
                return ServiceRequestProperties.key_service_type_uima;
            }

            @Override
            public String argname() {
                return null;
            }

            @Override
            public boolean optargs() {
                return true;
            }

            @Override
            public String description() {
                return "Service type - internally generated";
            }
        }
        ,
        Start{

            @Override
            public String pname() {
                return "start";
            }

            @Override
            public String description() {
                return "Start a registered service.";
            }

            @Override
            public String argname() {
                return "service-id-or-endpoint";
            }
        }
        ,
        Stop{

            @Override
            public String pname() {
                return "stop";
            }

            @Override
            public String description() {
                return "Stop a registered service.";
            }

            @Override
            public String argname() {
                return "service-id-or-endpoint";
            }
        }
        ,
        Enable{

            @Override
            public String pname() {
                return "enable";
            }

            @Override
            public String description() {
                return "Allow deployment starts for this service";
            }

            @Override
            public String argname() {
                return "service-id-or-endpoint";
            }
        }
        ,
        Disable{

            @Override
            public String pname() {
                return "disable";
            }

            @Override
            public String description() {
                return "Disable deployment starts for this service.";
            }

            @Override
            public String argname() {
                return "service-id-or-endpoint";
            }
        }
        ,
        Observe{

            @Override
            public String pname() {
                return "observe_references";
            }

            @Override
            public String description() {
                return "Enable reference-started control for a manually-started service.";
            }

            @Override
            public String argname() {
                return "service-id-or-endpoint";
            }
        }
        ,
        Ignore{

            @Override
            public String pname() {
                return "ignore_references";
            }

            @Override
            public String description() {
                return "Disable reference-started control of service and revert to manual control.";
            }

            @Override
            public String argname() {
                return "service-id-or-endpoint";
            }
        }
        ,
        SubmitPid{

            @Override
            public String pname() {
                return JobRequestProperties.key_submitter_pid_at_host;
            }

            @Override
            public String argname() {
                return null;
            }

            @Override
            public boolean optargs() {
                return true;
            }
        }
        ,
        ProcessDebug{

            @Override
            public String pname() {
                return "process_debug";
            }

            @Override
            public String argname() {
                return "debugger-port-number";
            }

            @Override
            public String description() {
                return "Listening port number the remote process is to connect to.";
            }

            @Override
            public String example() {
                return "8000";
            }
        }
        ,
        ProcessDescriptorAE{

            @Override
            public String pname() {
                return JobSpecificationProperties.key_process_descriptor_AE;
            }

            @Override
            public String description() {
                return "Process Analysis Enginefor aggregate.";
            }

            @Override
            public String argname() {
                return "descriptor xml";
            }

            @Override
            public String example() {
                return "/home/" + System.getProperty("user.name") + "/descriptors/MyAE.xml";
            }
        }
        ,
        ProcessDescriptorAEOverrides{

            @Override
            public String pname() {
                return JobSpecificationProperties.key_process_descriptor_AE_overrides;
            }

            @Override
            public String argname() {
                return "list of overrides";
            }

            @Override
            public String description() {
                return "Process Analysis Engine configuration parameter name/value pair overrides. Parameters must already be defined in the AE descriptor.";
            }

            @Override
            public String example() {
                return "name1=value1 name2=\"value2a value2b value2c\" name3=value3...";
            }
        }
        ,
        ProcessDescriptorCC{

            @Override
            public String pname() {
                return JobSpecificationProperties.key_process_descriptor_CC;
            }

            @Override
            public String description() {
                return "Process CAS Consumer for aggregate.";
            }

            @Override
            public String argname() {
                return "descriptor xml";
            }

            @Override
            public String example() {
                return "/home/" + System.getProperty("user.name") + "/descriptors/MyCC.xml";
            }
        }
        ,
        ProcessDescriptorCCOverrides{

            @Override
            public String pname() {
                return JobSpecificationProperties.key_process_descriptor_CC_overrides;
            }

            @Override
            public String argname() {
                return "list of overrides";
            }

            @Override
            public String description() {
                return "Process CAS Consumer configuration parameter name/value pair overrides. Parameters must already be defined in the CC descriptor.";
            }

            @Override
            public String example() {
                return "name1=value1 name2=\"value2a value2b value2c\" name3=value3...";
            }
        }
        ,
        ProcessDescriptorCM{

            @Override
            public String pname() {
                return JobSpecificationProperties.key_process_descriptor_CM;
            }

            @Override
            public String description() {
                return "Process CAS Multiplier for aggregate.";
            }

            @Override
            public String argname() {
                return "descriptor xml";
            }

            @Override
            public String example() {
                return "/home/" + System.getProperty("user.name") + "/descriptors/MyCM.xml";
            }
        }
        ,
        ProcessDescriptorCMOverrides{

            @Override
            public String pname() {
                return JobSpecificationProperties.key_process_descriptor_CM_overrides;
            }

            @Override
            public String argname() {
                return "list of overrides";
            }

            @Override
            public String description() {
                return "Process CAS Multiplier configuration parameter name/value pair overrides. Parameters must already be defined in the CM descriptor.";
            }

            @Override
            public String example() {
                return "name1=value1 name2=\"value2a value2b value2c\" name3=value3...";
            }
        }
        ,
        ProcessDD{

            @Override
            public String pname() {
                return JobSpecificationProperties.key_process_DD;
            }

            @Override
            public String description() {
                return "Process deployment descriptor (mutually exclusive with CM+AE+CC).";
            }

            @Override
            public String argname() {
                return "dd.xml";
            }

            @Override
            public String example() {
                return "/home/" + System.getProperty("user.name") + "/descriptors/MyDD.xml";
            }
        }
        ,
        ProcessDeploymentsMax{

            @Override
            public String pname() {
                return JobSpecificationProperties.key_process_deployments_max;
            }

            @Override
            public String description() {
                return "Maximum number of processes dispatched for this job at any time";
            }

            @Override
            public String argname() {
                return "integer";
            }

            @Override
            public String deflt() {
                return "unlimited";
            }
        }
        ,
        ProcessExecutable{

            @Override
            public String pname() {
                return JobSpecificationProperties.key_process_executable;
            }

            @Override
            public String argname() {
                return "program name";
            }

            @Override
            public String description() {
                return "The full path to a program to be executed.";
            }

            @Override
            public String example() {
                return "/bin/ls";
            }
        }
        ,
        ProcessExecutableRequired{

            @Override
            public String pname() {
                return JobSpecificationProperties.key_process_executable;
            }

            @Override
            public String argname() {
                return "program name";
            }

            @Override
            public String description() {
                return "The full path to a program to be executed.";
            }

            @Override
            public String example() {
                return "/bin/ls";
            }

            @Override
            public boolean required() {
                return true;
            }
        }
        ,
        ProcessExecutableArgs{

            @Override
            public String pname() {
                return JobSpecificationProperties.key_process_executable_args;
            }

            @Override
            public String argname() {
                return "argument list";
            }

            @Override
            public String description() {
                return "Blank-delimited list of arguments for " + ProcessExecutable.pname();
            }

            @Override
            public String example() {
                return "-a -t -l";
            }
        }
        ,
        ProcessInitializationTimeMax{

            @Override
            public String pname() {
                return JobSpecificationProperties.key_process_initialization_time_max;
            }

            @Override
            public String description() {
                return "Maximum elapsed time (in minutes) for processing initialization.";
            }

            @Override
            public String argname() {
                return "integer";
            }

            @Override
            public String deflt() {
                return "$$ducc.default.process.init.time.max";
            }
        }
        ,
        ProcessInitializationFailuresCap{

            @Override
            public String pname() {
                return JobSpecificationProperties.key_process_initialization_failures_cap;
            }

            @Override
            public String description() {
                return "Number of unexpected job process initialization failures (i.e. System.exit(), kill-15, ...) before the number of Job Processes is capped at the number currently Running.";
            }

            @Override
            public String argname() {
                return "integer";
            }

            @Override
            public String deflt() {
                return "99";
            }
        }
        ,
        ProcessFailuresLimit{

            @Override
            public String pname() {
                return JobSpecificationProperties.key_process_failures_limit;
            }

            @Override
            public String description() {
                return "Number of unexpected job process failures (i.e. System.exit(), kill-15...) that will cause the job to be terminated.";
            }

            @Override
            public String argname() {
                return "integer";
            }

            @Override
            public String deflt() {
                return "20";
            }
        }
        ,
        ProcessJvmArgs{

            @Override
            public String pname() {
                return JobSpecificationProperties.key_process_jvm_args;
            }

            @Override
            public String argname() {
                return "jvm arguments";
            }

            @Override
            public String description() {
                return "Blank-delimited list of JVM Arguments passed to each process";
            }

            @Override
            public String example() {
                return "-Xmx100M -DMYVAR=foo";
            }
        }
        ,
        ProcessMemorySize{

            @Override
            public String pname() {
                return JobSpecificationProperties.key_process_memory_size;
            }

            @Override
            public String argname() {
                return "size-in-GB";
            }

            @Override
            public String description() {
                return "Maximum memory for each process, in GB.";
            }

            @Override
            public String example() {
                return "30";
            }
        }
        ,
        ProcessPipelineCount{

            @Override
            public String pname() {
                return JobSpecificationProperties.key_process_pipeline_count;
            }

            @Override
            public String description() {
                return "Number of pipelines per process (i.e. simultaneously processed work-items).";
            }

            @Override
            public String argname() {
                return "integer";
            }

            @Override
            public String deflt() {
                return "4";
            }
        }
        ,
        ProcessPerItemTimeMax{

            @Override
            public String pname() {
                return JobSpecificationProperties.key_process_per_item_time_max;
            }

            @Override
            public String description() {
                return "Maximum elapsed time (in minutes) for processing one CAS.";
            }

            @Override
            public String argname() {
                return "integer";
            }

            @Override
            public String deflt() {
                return "$$ducc.default.process.per.item.time.max";
            }
        }
        ,
        Query{

            @Override
            public String pname() {
                return "query";
            }

            @Override
            public String argname() {
                return "service-id-or-endpoint";
            }

            @Override
            public boolean optargs() {
                return true;
            }

            @Override
            public String deflt() {
                return "";
            }

            @Override
            public String description() {
                return "Query a registered service, or all.";
            }
        }
        ,
        Reason{

            @Override
            public String pname() {
                return JobRequestProperties.key_reason;
            }

            @Override
            public String argname() {
                return "quoted text";
            }

            @Override
            public String description() {
                return "Reason for the cancel";
            }

            @Override
            public String example() {
                return "Back to the drawing board";
            }
        }
        ,
        ReservationMemorySize{

            @Override
            public String pname() {
                return ReservationSpecificationProperties.key_memory_size;
            }

            @Override
            public String argname() {
                return "size-in-GB";
            }

            @Override
            public String description() {
                return "Size of instance's memory, in GB.";
            }

            @Override
            public String example() {
                return "64";
            }

            @Override
            public boolean required() {
                return true;
            }
        }
        ,
        ReservationNodeList{

            @Override
            public String pname() {
                return ReservationRequestProperties.key_node_list;
            }

            @Override
            public String argname() {
                return "string";
            }

            @Override
            public String description() {
                return "Set of nodes reserved - internall generated.";
            }

            @Override
            public String example() {
                return "Back to the drawing board";
            }
        }
        ,
        RoleAdministrator{

            @Override
            public String pname() {
                return JobSpecificationProperties.key_role_administrator;
            }

            @Override
            public boolean noargs() {
                return true;
            }

            @Override
            public String description() {
                return "Act in the capacity of DUCC administrator.";
            }
        }
        ,
        SchedulingClass{

            @Override
            public String pname() {
                return JobSpecificationProperties.key_scheduling_class;
            }

            @Override
            public String argname() {
                return "scheduling class name";
            }

            @Override
            public String description() {
                return "The class to run the job in.";
            }

            @Override
            public String example() {
                return "normal (or fixed or reserve)";
            }
        }
        ,
        ServiceLinger{

            @Override
            public String pname() {
                return "service_linger";
            }

            @Override
            public String argname() {
                return "milliseconds";
            }

            @Override
            public String description() {
                return "Time in milliseconds to wait after last referring job or service exits before stopping a non-autostarted service.";
            }

            @Override
            public String deflt() {
                return "300000";
            }
        }
        ,
        ServiceDependency{

            @Override
            public String pname() {
                return JobSpecificationProperties.key_service_dependency;
            }

            @Override
            public String argname() {
                return "dependency list";
            }

            @Override
            public String description() {
                return "List of blank-delimited service names.";
            }

            @Override
            public String example() {
                return "UIMA-AS:RandomSleepAE:tcp://node1:61616 CUSTOM:myservice";
            }
        }
        ,
        ServiceRequestEndpoint{

            @Override
            public String pname() {
                return ServiceRequestProperties.key_service_request_endpoint;
            }

            @Override
            public String argname() {
                return "string";
            }

            @Override
            public String description() {
                return "Unique id for this service. Usually inferred for UIMA-AS services.";
            }

            @Override
            public String example() {
                return "UIMA-AS:queueName:ActiveMqUrl";
            }
        }
        ,
        Signature{

            @Override
            public String pname() {
                return JobSpecificationProperties.key_signature;
            }

            @Override
            public String argname() {
                return null;
            }

            @Override
            public boolean optargs() {
                return true;
            }
        }
        ,
        Specification{

            @Override
            public String pname() {
                return JobSpecificationProperties.key_specification;
            }

            @Override
            public String sname() {
                return "f";
            }

            @Override
            public String argname() {
                return "file";
            }

            @Override
            public String description() {
                return "Properties file comprising the specification, where the keys are names of parameters. Individual parameters take precedence over those specified in properties file, if any.";
            }
        }
        ,
        SubmitErrors{

            @Override
            public String pname() {
                return JobSpecificationProperties.key_submit_errors;
            }

            @Override
            public String argname() {
                return null;
            }

            @Override
            public boolean optargs() {
                return true;
            }
        }
        ,
        SubmitWarnings{

            @Override
            public String pname() {
                return JobSpecificationProperties.key_submit_warnings;
            }

            @Override
            public String argname() {
                return null;
            }

            @Override
            public boolean optargs() {
                return true;
            }
        }
        ,
        SuppressConsoleLog{

            @Override
            public String pname() {
                return "suppress_console_log";
            }

            @Override
            public String argname() {
                return null;
            }

            @Override
            public boolean noargs() {
                return true;
            }

            @Override
            public String description() {
                return "Do not copy stdout to a log file.";
            }
        }
        ,
        Timestamp{

            @Override
            public String pname() {
                return "timestamp";
            }

            @Override
            public String argname() {
                return null;
            }

            @Override
            public boolean noargs() {
                return true;
            }

            @Override
            public String description() {
                return "Enables timestamp on monitor messages.";
            }
        }
        ,
        Unregister{

            @Override
            public String pname() {
                return "unregister";
            }

            @Override
            public String argname() {
                return "service-id-or-endpoint";
            }

            @Override
            public String description() {
                return "Unregister a service.";
            }
        }
        ,
        User{

            @Override
            public String pname() {
                return JobSpecificationProperties.key_user;
            }

            @Override
            public String argname() {
                return "userid";
            }

            @Override
            public String description() {
                return "Filled in (and overridden) by the CLI, the id of the submitting user.";
            }
        }
        ,
        WaitForCompletion{

            @Override
            public String pname() {
                return "wait_for_completion";
            }

            @Override
            public boolean optargs() {
                return true;
            }

            @Override
            public String deflt() {
                return "true";
            }

            @Override
            public String argname() {
                return null;
            }

            @Override
            public String description() {
                return "Do not exit until job is completed.";
            }
        }
        ,
        WorkingDirectory{

            @Override
            public String pname() {
                return JobSpecificationProperties.key_working_directory;
            }

            @Override
            public String argname() {
                return "path";
            }

            @Override
            public String description() {
                return "The working directory set in each process. Default to current directory.";
            }

            @Override
            public String deflt() {
                return ".";
            }
        };


        @Override
        public String argname() {
            return null;
        }

        @Override
        public boolean multiargs() {
            return false;
        }

        @Override
        public boolean required() {
            return false;
        }

        @Override
        public String deflt() {
            return null;
        }

        @Override
        public String sname() {
            return null;
        }

        @Override
        public boolean optargs() {
            return false;
        }

        @Override
        public boolean noargs() {
            return false;
        }

        @Override
        public String example() {
            return null;
        }

        @Override
        public String description() {
            return null;
        }
    }
}

