/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.cli;

import java.lang.management.ManagementFactory;
import java.net.ConnectException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.uima.ducc.cli.CommandLine;
import org.apache.uima.ducc.cli.DefaultCallback;
import org.apache.uima.ducc.cli.DuccJobMonitor;
import org.apache.uima.ducc.cli.IDuccCallback;
import org.apache.uima.ducc.cli.IUiOption;
import org.apache.uima.ducc.cli.IUiOptions;
import org.apache.uima.ducc.common.json.MonitorInfo;
import org.apache.uima.ducc.common.utils.DuccPropertiesResolver;
import org.apache.uima.ducc.common.utils.SynchronizedSimpleDateFormat;
import org.apache.uima.ducc.common.utils.Utils;
import org.apache.uima.ducc.transport.dispatcher.DuccEventHttpDispatcherCl;
import org.apache.uima.ducc.transport.event.IDuccContext;

public abstract class DuccMonitor {
    protected static final int RC_SUCCESS = 0;
    protected static final int RC_FAILURE = 1;
    protected static final int RC_HELP = 1;
    protected static final String NotFound = "NotFound";
    protected static final String StateRunning = "Running";
    protected static final String StateCompleting = "Completing";
    protected static final String StateCompleted = "Completed";
    protected static final String StateWaitingForResources = "WaitingForResources";
    protected static final String StateAssigned = "Assigned";
    protected CommandLine command_line = null;
    private IUiOption[] opts = new IUiOptions.UiOption[0];
    private String id = null;
    private AtomicBoolean flag_cancel_on_interrupt = new AtomicBoolean(false);
    private AtomicBoolean flag_debug = new AtomicBoolean(false);
    private AtomicBoolean flag_error = new AtomicBoolean(true);
    private AtomicBoolean flag_info = new AtomicBoolean(true);
    private AtomicBoolean flag_trace = new AtomicBoolean(false);
    private AtomicBoolean flag_timestamp = new AtomicBoolean(false);
    private AtomicBoolean flag_observer = new AtomicBoolean(true);
    private int milliseconds = 1;
    private int seconds = 1000 * this.milliseconds;
    private int wakeupInterval = 15 * this.seconds;
    private int urlTimeout = 60 * this.seconds;
    private Thread main = null;
    private DuccPropertiesResolver duccPropertiesResolver = null;
    private IDuccContext.DuccContext context = null;
    protected IDuccCallback messageProcessor = null;
    private volatile MonitorInfo previousMonitorInfo = null;
    private String delayedRunning = null;
    private SynchronizedSimpleDateFormat sdf = new SynchronizedSimpleDateFormat("dd/MM/yyyy HH:mm:ss");
    private IUiOption[] optsSubmitJob = new IUiOptions.UiOption[]{IUiOptions.UiOption.Help, IUiOptions.UiOption.Debug, IUiOptions.UiOption.Quiet, IUiOptions.UiOption.Timestamp, IUiOptions.UiOption.JobId, IUiOptions.UiOption.CancelOnInterrupt};
    private IUiOption[] optsMonitorJob = new IUiOptions.UiOption[]{IUiOptions.UiOption.Help, IUiOptions.UiOption.Debug, IUiOptions.UiOption.Quiet, IUiOptions.UiOption.Timestamp, IUiOptions.UiOption.JobId};
    private IUiOption[] optsSubmitReservation = new IUiOptions.UiOption[]{IUiOptions.UiOption.Help, IUiOptions.UiOption.Debug, IUiOptions.UiOption.Quiet, IUiOptions.UiOption.Timestamp, IUiOptions.UiOption.ReservationId, IUiOptions.UiOption.CancelOnInterrupt};
    private IUiOption[] optsMonitorReservation = new IUiOptions.UiOption[]{IUiOptions.UiOption.Help, IUiOptions.UiOption.Debug, IUiOptions.UiOption.Quiet, IUiOptions.UiOption.Timestamp, IUiOptions.UiOption.ReservationId};
    private IUiOption[] optsSubmitManagedReservation = new IUiOptions.UiOption[]{IUiOptions.UiOption.Help, IUiOptions.UiOption.Debug, IUiOptions.UiOption.Quiet, IUiOptions.UiOption.Timestamp, IUiOptions.UiOption.ManagedReservationId, IUiOptions.UiOption.CancelOnInterrupt};
    private IUiOption[] optsMonitorManagedReservation = new IUiOptions.UiOption[]{IUiOptions.UiOption.Help, IUiOptions.UiOption.Debug, IUiOptions.UiOption.Quiet, IUiOptions.UiOption.Timestamp, IUiOptions.UiOption.ManagedReservationId};
    private ArrayList<String> seenRemotePids = new ArrayList();

    protected DuccMonitor(IDuccContext.DuccContext context, boolean submit) {
        this.initialize(context, submit, new DefaultCallback());
    }

    protected DuccMonitor(IDuccContext.DuccContext context, boolean submit, IDuccCallback messageProcessor) {
        this.initialize(context, submit, messageProcessor);
    }

    public void help(IUiOption[] options) {
        System.out.println(this.command_line.formatHelp(this.getClass().getName()));
    }

    public abstract void cancel();

    public abstract String getUrl(String var1);

    public String getHost() {
        String host = this.duccPropertiesResolver.getFileProperty("ducc.ws.node");
        if (host == null) {
            host = this.duccPropertiesResolver.getFileProperty("ducc.head");
        }
        return host;
    }

    public String getPort() {
        String port = this.duccPropertiesResolver.getFileProperty("ducc.ws.port");
        return port;
    }

    public String getId() {
        return this.id;
    }

    private void initialize(IDuccContext.DuccContext context, boolean submit, IDuccCallback messageProcessor) {
        this.context = context;
        if (context != null) {
            switch (context) {
                case Job: {
                    if (submit) {
                        this.opts = this.optsSubmitJob;
                        break;
                    }
                    this.opts = this.optsMonitorJob;
                    break;
                }
                case Reservation: {
                    if (submit) {
                        this.opts = this.optsSubmitReservation;
                        break;
                    }
                    this.opts = this.optsMonitorReservation;
                    break;
                }
                case ManagedReservation: {
                    if (submit) {
                        this.opts = this.optsSubmitManagedReservation;
                        break;
                    }
                    this.opts = this.optsMonitorManagedReservation;
                    break;
                }
            }
        }
        if (messageProcessor != null) {
            this.messageProcessor = messageProcessor;
        }
    }

    protected void trace(String message) {
        if (this.flag_trace.get()) {
            this.messageProcessor.status(this.timestamp(message));
        }
    }

    protected void debug(String message) {
        if (this.flag_debug.get()) {
            this.messageProcessor.status(this.timestamp(message));
        }
    }

    protected void debug(Exception e) {
        if (this.flag_debug.get()) {
            this.messageProcessor.status(e.toString());
        }
    }

    private void info(String message) {
        if (this.flag_info.get()) {
            this.messageProcessor.status(this.timestamp(message));
        }
    }

    private void error(String message) {
        if (this.flag_error.get()) {
            this.messageProcessor.status(this.timestamp(message));
        }
    }

    protected String timestamp(String message) {
        String tMessage = message;
        if (this.flag_timestamp.get()) {
            String date = this.sdf.format(new Date());
            tMessage = date + " " + message;
        }
        return tMessage;
    }

    private String details(MonitorInfo monitorInfo) {
        StringBuffer sb = new StringBuffer();
        switch (this.context) {
            case Job: {
                sb.append(" ");
                sb.append("total:");
                sb.append(monitorInfo.total);
                sb.append(" ");
                sb.append("done:");
                sb.append(monitorInfo.done);
                sb.append(" ");
                sb.append("error:");
                sb.append(monitorInfo.error);
                sb.append(" ");
                sb.append("retry:");
                sb.append(monitorInfo.retry);
                sb.append(" ");
                sb.append("procs:");
                sb.append(monitorInfo.procs);
            }
        }
        return sb.toString();
    }

    private void adjustWakeupInterval() {
        String rate = this.duccPropertiesResolver.getFileProperty("ducc.orchestrator.state.publish.rate");
        try {
            this.wakeupInterval = Integer.parseInt(rate);
        }
        catch (Exception e) {
            this.debug(e);
        }
    }

    private void displayRemotePids(MonitorInfo monitorInfo) {
        if (monitorInfo != null && monitorInfo.remotePids != null) {
            block3: for (String remotePid : monitorInfo.remotePids) {
                if (this.seenRemotePids.contains(remotePid)) continue;
                this.seenRemotePids.add(remotePid);
                switch (this.context) {
                    case Job: {
                        continue block3;
                    }
                }
                StringBuffer message = new StringBuffer();
                message.append("id:" + this.id);
                message.append(" remote:" + remotePid);
                this.info(message.toString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int runInternal(String[] args) throws Exception {
        String ducc_home = Utils.findDuccHome();
        if (ducc_home == null) {
            this.messageProcessor.status("Missing required environment variable: DUCC_HOME");
            return 1;
        }
        this.duccPropertiesResolver = DuccPropertiesResolver.getInstance();
        Class<DuccMonitor> clazz = DuccMonitor.class;
        synchronized (DuccMonitor.class) {
            this.command_line = new CommandLine(args, this.opts);
            try {
                this.command_line.parse();
            }
            catch (IllegalArgumentException e) {
                System.out.println("Illegal arguments: " + e.getMessage());
                this.help(this.opts);
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return 1;
            }
            if (this.command_line.contains(IUiOptions.UiOption.Help)) {
                this.help(this.opts);
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return 1;
            }
            if (this.command_line.contains(IUiOptions.UiOption.Timestamp)) {
                this.flag_timestamp.set(true);
            }
            if (this.command_line.contains(IUiOptions.UiOption.Quiet)) {
                this.flag_info.set(false);
                this.flag_error.set(false);
            }
            if (this.command_line.contains(IUiOptions.UiOption.Debug)) {
                this.flag_debug.set(true);
            }
            if (this.command_line.contains(IUiOptions.UiOption.CancelOnInterrupt)) {
                this.flag_cancel_on_interrupt.set(true);
            }
            if (this.command_line.contains(IUiOptions.UiOption.JobId)) {
                this.id = this.command_line.get(IUiOptions.UiOption.JobId);
            } else if (this.command_line.contains(IUiOptions.UiOption.ManagedReservationId)) {
                this.id = this.command_line.get(IUiOptions.UiOption.ManagedReservationId);
            } else if (this.command_line.contains(IUiOptions.UiOption.ReservationId)) {
                this.id = this.command_line.get(IUiOptions.UiOption.ReservationId);
            } else {
                System.out.println(this.command_line.formatHelp(DuccJobMonitor.class.getName()));
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return 1;
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            this.main = Thread.currentThread();
            Killer killer = new Killer(this.main);
            Runtime.getRuntime().addShutdownHook(killer);
            this.adjustWakeupInterval();
            String urlString = this.getUrl(this.id);
            String lastMessage = "";
            String thisMessage = "";
            String lastRationale = "";
            String thisRationale = "";
            StringBuffer message = new StringBuffer();
            message.append("id:" + this.id);
            message.append(" location:");
            message.append(ManagementFactory.getRuntimeMXBean().getName());
            this.info(message.toString());
            this.debug(urlString);
            boolean connectionFailed = false;
            while (this.flag_observer.get()) {
                long start;
                MonitorInfo monitorInfo;
                block52: {
                    DuccEventHttpDispatcherCl dispatcher = null;
                    monitorInfo = null;
                    try {
                        dispatcher = new DuccEventHttpDispatcherCl(urlString, this.urlTimeout);
                        monitorInfo = (MonitorInfo)dispatcher.dispatchJson(MonitorInfo.class);
                        if (connectionFailed) {
                            this.info("id:" + this.id + " warning:Connection to DUCC restored");
                            connectionFailed = false;
                        }
                    }
                    catch (ConnectException e) {
                        if (connectionFailed) break block52;
                        this.info("id:" + this.id + " warning:Connection to DUCC failed -- retrying");
                        connectionFailed = true;
                    }
                }
                if (monitorInfo != null) {
                    if (monitorInfo.isRegression(this.previousMonitorInfo)) continue;
                    this.previousMonitorInfo = monitorInfo;
                    this.displayRemotePids(monitorInfo);
                    int stateCount = monitorInfo.stateSequence.size();
                    this.debug("states:" + stateCount);
                    String state2 = NotFound;
                    for (String state2 : monitorInfo.stateSequence) {
                        this.debug("list:" + state2);
                    }
                    message = new StringBuffer();
                    message.append("id:" + this.id);
                    message.append(" state:" + state2);
                    if (state2.equals(StateRunning)) {
                        message.append(this.details(monitorInfo));
                    } else if (state2.equals(StateCompleting)) {
                        this.flag_cancel_on_interrupt.set(false);
                        message.append(this.details(monitorInfo));
                    } else if (state2.equals(StateCompleted)) {
                        this.flag_cancel_on_interrupt.set(false);
                        message.append(this.details(monitorInfo));
                    } else if (this.context == IDuccContext.DuccContext.Reservation && state2.equals(StateAssigned)) {
                        this.flag_cancel_on_interrupt.set(false);
                        message.append(this.details(monitorInfo));
                    }
                    thisMessage = message.toString();
                    if (!thisMessage.equals(lastMessage)) {
                        boolean suppress = false;
                        if (state2.equals(StateRunning)) {
                            if (this.seenRemotePids.size() == 0) {
                                suppress = true;
                                if (this.delayedRunning == null) {
                                    this.delayedRunning = message.toString();
                                }
                            } else {
                                this.delayedRunning = null;
                            }
                        }
                        if (!suppress) {
                            if (this.delayedRunning != null) {
                                this.info(this.delayedRunning);
                                this.delayedRunning = null;
                            }
                            this.info(thisMessage);
                            lastMessage = thisMessage;
                        }
                    }
                    if (state2.equals(StateWaitingForResources) && !monitorInfo.rationale.equals("") && !(thisRationale = monitorInfo.rationale).equals(lastRationale)) {
                        this.info(thisRationale);
                        lastRationale = thisRationale;
                    }
                    if (this.context == IDuccContext.DuccContext.Reservation && state2.equals(StateAssigned)) {
                        if (monitorInfo.nodes != null && monitorInfo.nodes.size() > 0) {
                            StringBuffer sb = new StringBuffer();
                            sb.append("nodes: ");
                            for (String node : monitorInfo.nodes) {
                                sb.append(node);
                                sb.append(" ");
                            }
                            String nodes = sb.toString().trim();
                            this.info(nodes);
                        }
                        return 0;
                    }
                    if (state2.equals(StateCompleted)) {
                        if (monitorInfo.total.equals(monitorInfo.done)) {
                            if (!monitorInfo.rationale.equals("")) {
                                message = new StringBuffer();
                                message.append("id:" + this.id);
                                message.append(" rationale:" + monitorInfo.rationale);
                                thisMessage = message.toString();
                                this.info(thisMessage);
                            }
                            int rc = 1;
                            message = new StringBuffer();
                            message.append("id:" + this.id);
                            try {
                                rc = Integer.parseInt(monitorInfo.code);
                                message.append(" rc:" + rc);
                            }
                            catch (NumberFormatException e) {
                                message.append(" code:" + monitorInfo.code);
                            }
                            thisMessage = message.toString();
                            this.info(thisMessage);
                            return rc;
                        }
                        if (!monitorInfo.errorLogs.isEmpty()) {
                            message = new StringBuffer();
                            message.append("id:" + this.id);
                            List errorLogs = monitorInfo.errorLogs;
                            for (String errorLog : errorLogs) {
                                message.append(" file:" + errorLog);
                            }
                            thisMessage = message.toString();
                            this.info(thisMessage);
                        }
                        if (!monitorInfo.rationale.equals("")) {
                            message = new StringBuffer();
                            message.append("id:" + this.id);
                            message.append(" rationale:" + monitorInfo.rationale);
                            thisMessage = message.toString();
                            this.info(thisMessage);
                        }
                        message = new StringBuffer();
                        message.append("id:" + this.id);
                        message.append(" rc:1");
                        thisMessage = message.toString();
                        this.info(thisMessage);
                        return 1;
                    }
                }
                long end = start = System.currentTimeMillis();
                while (!this.isTimeExpired(start, end, this.wakeupInterval) && this.flag_observer.get()) {
                    try {
                        Thread.sleep(this.wakeupInterval);
                    }
                    catch (InterruptedException e) {
                        this.debug(e);
                    }
                    end = System.currentTimeMillis();
                }
            }
            return 0;
        }
    }

    private boolean isTimeExpired(long start, long end, long interval) {
        boolean retVal = false;
        long diff = end - start;
        if (diff >= interval) {
            retVal = true;
        }
        this.trace("start:" + start + " " + "end:" + end + " " + "diff:" + diff + " " + "interval:" + interval + " " + "result:" + retVal);
        return retVal;
    }

    public int run(String[] args) {
        int code = 1;
        try {
            code = this.runInternal(args);
        }
        catch (Exception e) {
            this.messageProcessor.status("ERROR: " + e.toString());
            e.printStackTrace();
        }
        this.debug("rc=" + code);
        return code;
    }

    private class Killer
    extends Thread {
        public Killer(Thread thread) {
        }

        @Override
        public void run() {
            StringBuffer message = new StringBuffer();
            if (DuccMonitor.this.flag_cancel_on_interrupt.get()) {
                message.append("killer: cancel");
                DuccMonitor.this.cancel();
            } else {
                message.append("killer: no cancel");
            }
            DuccMonitor.this.debug(message.toString());
            DuccMonitor.this.flag_observer.set(false);
        }
    }
}

