/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.cli;

import java.util.ArrayList;
import java.util.Properties;
import org.apache.uima.ducc.cli.CliBase;
import org.apache.uima.ducc.cli.CliVersion;
import org.apache.uima.ducc.cli.IDuccCallback;
import org.apache.uima.ducc.cli.IUiOptions;
import org.apache.uima.ducc.common.utils.DuccProperties;
import org.apache.uima.ducc.common.utils.DuccSchedulerClasses;
import org.apache.uima.ducc.common.utils.IllegalConfigurationException;
import org.apache.uima.ducc.transport.event.AbstractDuccOrchestratorEvent;
import org.apache.uima.ducc.transport.event.DuccEvent;
import org.apache.uima.ducc.transport.event.IDuccContext;
import org.apache.uima.ducc.transport.event.SubmitServiceDuccEvent;
import org.apache.uima.ducc.transport.event.SubmitServiceReplyDuccEvent;
import org.apache.uima.ducc.transport.event.cli.ServiceRequestProperties;

public class DuccManagedReservationSubmit
extends CliBase {
    private static String dt = "Managed Reservation";
    private ServiceRequestProperties serviceRequestProperties;
    private IUiOptions.UiOption[] opts = new IUiOptions.UiOption[]{IUiOptions.UiOption.Help, IUiOptions.UiOption.Debug, IUiOptions.UiOption.Description, IUiOptions.UiOption.WorkingDirectory, IUiOptions.UiOption.LogDirectory, IUiOptions.UiOption.Environment, IUiOptions.UiOption.AttachConsole, IUiOptions.UiOption.ProcessExecutableRequired, IUiOptions.UiOption.ProcessExecutableArgs, IUiOptions.UiOption.ProcessMemorySize, IUiOptions.UiOption.SchedulingClass, IUiOptions.UiOption.Specification, IUiOptions.UiOption.SuppressConsoleLog, IUiOptions.UiOption.Timestamp, IUiOptions.UiOption.WaitForCompletion, IUiOptions.UiOption.CancelOnInterrupt, IUiOptions.UiOption.ServiceDependency};

    public DuccManagedReservationSubmit(String[] args) throws Exception {
        this(args, null);
    }

    public DuccManagedReservationSubmit(ArrayList<String> args) throws Exception {
        this(args, null);
    }

    public DuccManagedReservationSubmit(Properties props) throws Exception {
        this(props, null);
    }

    public DuccManagedReservationSubmit(String[] args, IDuccCallback consoleCb) throws Exception {
        this.serviceRequestProperties = new ServiceRequestProperties();
        this.init(this.getClass().getName(), this.opts, args, (DuccProperties)this.serviceRequestProperties, consoleCb);
    }

    public DuccManagedReservationSubmit(ArrayList<String> args, IDuccCallback consoleCb) throws Exception {
        String[] arg_array = args.toArray(new String[args.size()]);
        this.serviceRequestProperties = new ServiceRequestProperties();
        this.init(this.getClass().getName(), this.opts, arg_array, (DuccProperties)this.serviceRequestProperties, consoleCb);
    }

    public DuccManagedReservationSubmit(Properties props, IDuccCallback consoleCb) throws Exception {
        this.serviceRequestProperties = new ServiceRequestProperties();
        this.init(this.getClass().getName(), this.opts, props, (DuccProperties)this.serviceRequestProperties, consoleCb);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute() throws Exception {
        String pname = IUiOptions.UiOption.SchedulingClass.pname();
        String scheduling_class = this.serviceRequestProperties.getProperty(pname);
        if (scheduling_class != null) {
            try {
                String np_scheduling_class;
                DuccSchedulerClasses duccSchedulerClasses = DuccSchedulerClasses.getInstance();
                if (duccSchedulerClasses.isPreemptable(scheduling_class) && (np_scheduling_class = duccSchedulerClasses.getDebugClassSpecificName(scheduling_class)) != null) {
                    this.serviceRequestProperties.setProperty(pname, np_scheduling_class);
                    String msg = "Changed the scheduling_class from " + scheduling_class + " to the non-preemptable " + np_scheduling_class;
                    this.message(msg);
                }
            }
            catch (Exception e) {
                throw new IllegalConfigurationException("Error in DUCC configuration files - see administrator", (Throwable)e);
            }
        }
        this.check_heap_size(IUiOptions.UiOption.ProcessExecutableArgs.pname());
        ServiceRequestProperties serviceProperties = (ServiceRequestProperties)this.serviceRequestProperties.clone();
        this.serviceRequestProperties.setProperty(IUiOptions.UiOption.ProcessPipelineCount.pname(), "1");
        this.serviceRequestProperties.setProperty(IUiOptions.UiOption.ProcessDeploymentsMax.pname(), "1");
        this.serviceRequestProperties.setProperty(IUiOptions.UiOption.ServiceTypeOther.pname(), "");
        SubmitServiceDuccEvent ev = new SubmitServiceDuccEvent((DuccProperties)this.serviceRequestProperties, CliVersion.getVersion());
        SubmitServiceReplyDuccEvent reply = null;
        try {
            reply = (SubmitServiceReplyDuccEvent)this.dispatcher.dispatchAndWaitForDuccReply((DuccEvent)ev);
        }
        finally {
            this.dispatcher.close();
        }
        boolean rc = this.extractReply((AbstractDuccOrchestratorEvent)reply);
        if (rc) {
            this.saveSpec("managed-reservation.properties", (DuccProperties)serviceProperties);
            this.startMonitors(true, IDuccContext.DuccContext.ManagedReservation);
        }
        return rc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        int code = 1;
        try {
            DuccManagedReservationSubmit ds = new DuccManagedReservationSubmit(args);
            boolean rc = ds.execute();
            if (rc) {
                System.out.println(dt + " " + ds.getDuccId() + " submitted.");
                code = ds.getReturnCode();
            } else {
                System.out.println(dt + " Could not submit ");
            }
        }
        catch (Throwable e) {
            System.out.println(dt + " Cannot initialize: " + e);
            Throwable t = e;
            while ((t = t.getCause()) != null) {
                System.out.println("  ... " + t);
            }
            for (String arg : args) {
                if (!arg.equals("--debug")) continue;
                e.printStackTrace();
                break;
            }
        }
        finally {
            System.exit(code);
        }
    }
}

