/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.cli;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.CountDownLatch;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.uima.ducc.cli.CliFixups;
import org.apache.uima.ducc.cli.CommandLine;
import org.apache.uima.ducc.cli.ConsoleListener;
import org.apache.uima.ducc.cli.DefaultCallback;
import org.apache.uima.ducc.cli.DispatcherFactory;
import org.apache.uima.ducc.cli.DuccManagedReservationSubmit;
import org.apache.uima.ducc.cli.DuccUiUtilities;
import org.apache.uima.ducc.cli.IDuccCallback;
import org.apache.uima.ducc.cli.IUiOption;
import org.apache.uima.ducc.cli.IUiOptions;
import org.apache.uima.ducc.cli.MonitorListener;
import org.apache.uima.ducc.common.crypto.Crypto;
import org.apache.uima.ducc.common.utils.DuccProperties;
import org.apache.uima.ducc.common.utils.DuccPropertiesResolver;
import org.apache.uima.ducc.common.utils.Utils;
import org.apache.uima.ducc.transport.dispatcher.IDuccEventDispatcher;
import org.apache.uima.ducc.transport.event.AbstractDuccOrchestratorEvent;
import org.apache.uima.ducc.transport.event.IDuccContext;

public abstract class CliBase
implements IUiOptions {
    private String myClassName = "N/A";
    private boolean init_done = false;
    protected String ducc_home;
    protected IDuccEventDispatcher dispatcher;
    protected CommandLine commandLine;
    protected long friendlyId = -1L;
    protected int returnCode = 0;
    protected DuccProperties cli_props;
    protected ArrayList<String> errors = new ArrayList();
    protected ArrayList<String> warnings = new ArrayList();
    protected ArrayList<String> messages = new ArrayList();
    protected boolean debug;
    private boolean load_defaults = true;
    protected ConsoleListener console_listener = null;
    protected boolean suppress_console_log;
    protected String host_address = "N/A";
    protected boolean console_attach = false;
    protected IDuccCallback consoleCb = null;
    protected MonitorListener monitor_listener = null;
    CountDownLatch waiter = null;
    protected Properties userSpecifiedProperties;

    public abstract boolean execute() throws Exception;

    protected void inhibitDefaults() {
        this.load_defaults = false;
    }

    String getLogDirectory(String working_directory) throws IOException {
        File f;
        String log_directory = this.cli_props.getProperty(IUiOptions.UiOption.LogDirectory.pname());
        if (log_directory.startsWith(File.separator)) {
            f = new File(log_directory);
        } else {
            f = new File(working_directory, log_directory);
            log_directory = f.getCanonicalPath();
            this.cli_props.setProperty(IUiOptions.UiOption.LogDirectory.pname(), log_directory);
        }
        f.mkdirs();
        if (!f.isDirectory() || !f.canWrite()) {
            throw new IllegalArgumentException("Specified log_directory is not a writable directory: " + log_directory);
        }
        return log_directory;
    }

    String getWorkingDirectory() throws IOException {
        String working_directory = this.cli_props.getProperty(IUiOptions.UiOption.WorkingDirectory.pname());
        File f = new File(working_directory);
        if (!f.exists()) {
            throw new IllegalArgumentException("Working directory " + working_directory + " does not exist.");
        }
        if (!f.isAbsolute()) {
            working_directory = f.getCanonicalPath();
            this.cli_props.setProperty(IUiOptions.UiOption.WorkingDirectory.pname(), working_directory);
        }
        return working_directory;
    }

    boolean check_service_dependencies(String endpoint) {
        String deps = this.cli_props.getProperty(IUiOptions.UiOption.ServiceDependency.pname());
        try {
            String dependencies = DuccUiUtilities.check_service_dependencies(endpoint, deps);
            if (dependencies != null) {
                this.cli_props.setProperty(IUiOptions.UiOption.ServiceDependency.pname(), dependencies);
            }
            return true;
        }
        catch (Throwable t) {
            this.message("ERROR:", t.toString());
            return false;
        }
    }

    void check_heap_size(String argsOption) {
        int memGB;
        long sizeGB;
        char factor;
        int shift;
        String jvmArgs = this.cli_props.getProperty(argsOption);
        String memSize = this.cli_props.getProperty(IUiOptions.UiOption.ProcessMemorySize.pname());
        if (jvmArgs == null || memSize == null) {
            return;
        }
        String xmxRegex = "-Xmx([0-9]+)($|[\\skKmMgG])";
        Pattern patn = Pattern.compile(xmxRegex);
        Matcher matcher = patn.matcher(jvmArgs);
        Long size = null;
        String unit = null;
        while (matcher.find()) {
            size = Long.valueOf(matcher.group(1));
            unit = matcher.group(2);
        }
        if (size == null) {
            return;
        }
        if (unit.isEmpty()) {
            unit = " ";
        }
        if ((shift = "gmk".indexOf(factor = unit.toLowerCase().charAt(0))) < 0) {
            shift = 3;
        }
        if ((sizeGB = size >> 10 * shift) >= (long)(memGB = Integer.valueOf(memSize).intValue())) {
            String text = "WARNING - process_memory_size is " + memSize + "G but the max heap is " + size + unit + " --- swapping may occur";
            this.message(text);
        }
    }

    void setUser() throws Exception {
        String signatureRequiredProperty;
        String user = DuccUiUtilities.getUser();
        this.cli_props.setProperty(IUiOptions.UiOption.User.pname(), user);
        String property = DuccPropertiesResolver.getInstance().getProperty("ducc.signature.required");
        if (property != null && (signatureRequiredProperty = property.trim().toLowerCase()).equals("on")) {
            Crypto crypto = new Crypto(user, true);
            byte[] cypheredMessage = crypto.getSignature();
            this.cli_props.put((Object)IUiOptions.UiOption.Signature.pname(), (Object)cypheredMessage);
        }
    }

    protected synchronized void init(String myClassName, IUiOptions.UiOption[] opts, String[] args, DuccProperties cli_props, IDuccCallback consoleCb) throws Exception {
        this.init(myClassName, opts, args, null, cli_props, consoleCb, "orchestrator");
    }

    protected synchronized void init(String myClassName, IUiOptions.UiOption[] opts, Properties props, DuccProperties cli_props, IDuccCallback consoleCb) throws Exception {
        this.init(myClassName, opts, null, props, cli_props, consoleCb, "orchestrator");
    }

    protected synchronized void init(String myClassName, IUiOption[] uiOpts, String[] args, Properties props, DuccProperties cli_props, IDuccCallback consoleCb, String servlet) throws Exception {
        if (args != null) {
            CliFixups.cleanupArgs(args, myClassName);
        } else {
            CliFixups.cleanupProps(props, myClassName);
        }
        if (this.init_done) {
            return;
        }
        this.consoleCb = consoleCb == null ? new DefaultCallback() : consoleCb;
        this.myClassName = myClassName;
        this.ducc_home = Utils.findDuccHome();
        this.cli_props = cli_props;
        this.commandLine = new CommandLine(args, uiOpts, props);
        try {
            this.commandLine.parse();
        }
        catch (Exception e) {
            this.usage(e.getMessage());
        }
        if (this.commandLine.contains(IUiOptions.UiOption.Help)) {
            this.usage(null);
        }
        this.debug = this.commandLine.contains(IUiOptions.UiOption.Debug);
        String fname = null;
        for (IUiOption spec : new IUiOption[]{IUiOptions.UiOption.Specification, IUiOptions.UiOption.Register}) {
            if (!this.commandLine.isOption(spec) || !this.commandLine.contains(spec)) continue;
            fname = this.commandLine.get(spec);
            if (fname.length() != 0) break;
            fname = null;
            break;
        }
        if (fname != null) {
            FileInputStream fis = new FileInputStream(new File(fname));
            Properties defaults = new Properties();
            defaults.load(fis);
            fis.close();
            CliFixups.cleanupProps(defaults, myClassName);
            if (props != null) {
                defaults.putAll((Map<?, ?>)props);
            }
            this.commandLine = new CommandLine(args, uiOpts, defaults);
            this.commandLine.parse();
        }
        this.commandLine.verify();
        this.setOptions(uiOpts);
        this.userSpecifiedProperties = (Properties)cli_props.clone();
        this.suppress_console_log = cli_props.containsKey((Object)IUiOptions.UiOption.SuppressConsoleLog.pname());
        cli_props.setProperty(IUiOptions.UiOption.SubmitPid.pname(), ManagementFactory.getRuntimeMXBean().getName());
        if (this.load_defaults) {
            this.setDefaults(uiOpts, this.suppress_console_log);
        }
        this.setUser();
        this.host_address = InetAddress.getLocalHost().getHostAddress();
        this.initConsoleListener();
        if (!cli_props.containsKey((Object)IUiOptions.UiOption.AllInOne.pname())) {
            this.dispatcher = DispatcherFactory.create(cli_props, servlet);
        }
        this.init_done = true;
    }

    /*
     * Enabled aggressive block sorting
     */
    void setOptions(IUiOption[] uiOpts) throws Exception {
        String envNames = DuccPropertiesResolver.get((String)"ducc.environment.propagated");
        List<String> envNameList = envNames != null ? Arrays.asList(envNames.split("\\s+")) : new ArrayList<String>(0);
        Map<IUiOption, String> parsed = this.commandLine.allOptions();
        Iterator<IUiOption> i$ = parsed.keySet().iterator();
        while (true) {
            String val;
            IUiOption opt;
            block8: {
                if (!i$.hasNext()) {
                    return;
                }
                opt = i$.next();
                if (opt.optargs() && "true".equals(opt.deflt())) {
                    boolean bval = this.commandLine.getBoolean(opt);
                    if (bval) {
                        val = "";
                        break block8;
                    } else {
                        if (!this.debug) continue;
                        System.out.println("CLI omitted boolean " + opt.pname() + " = '" + parsed.get(opt) + "'");
                        continue;
                    }
                }
                val = parsed.get(opt);
                if (val == null) {
                    val = "";
                } else if (val.contains("${")) {
                    val = this.resolvePlaceholders(val, envNameList);
                }
            }
            val = val.trim();
            this.cli_props.put((Object)opt.pname(), (Object)val);
            if (!this.debug) continue;
            System.out.println("CLI set " + opt.pname() + " = '" + val + "'");
        }
    }

    void setDefaults(IUiOption[] uiOpts, boolean suppress_console) throws IOException {
        String logDir = null;
        String workingDir = null;
        ArrayList<String> envNameList = new ArrayList<String>(0);
        for (IUiOption uiopt : uiOpts) {
            String val;
            if (!this.cli_props.containsKey((Object)uiopt.pname())) {
                if (!uiopt.optargs() && !uiopt.noargs() && uiopt.deflt() != null) {
                    String deflt = uiopt.deflt();
                    if (deflt.startsWith("$$")) {
                        if ((deflt = DuccPropertiesResolver.get((String)deflt.substring(2))) == null) {
                            throw new IllegalArgumentException("Invalid default (undefined property) for " + uiopt.pname());
                        }
                    } else if (deflt.contains("${")) {
                        deflt = this.resolvePlaceholders(deflt, envNameList);
                    }
                    if (this.debug) {
                        System.out.println("CLI set default: " + uiopt.pname() + " = " + deflt);
                    }
                    this.cli_props.put((Object)uiopt.pname(), (Object)deflt);
                }
            } else if (!(uiopt != IUiOptions.UiOption.ProcessMemorySize && uiopt != IUiOptions.UiOption.ReservationMemorySize || (val = this.cli_props.getStringProperty(uiopt.pname())).matches("^\\d+$"))) {
                throw new IllegalArgumentException("Invalid non-numeric value for " + uiopt.pname() + ": " + val);
            }
            if (uiopt == IUiOptions.UiOption.WorkingDirectory) {
                workingDir = this.getWorkingDirectory();
                continue;
            }
            if (uiopt == IUiOptions.UiOption.LogDirectory) {
                logDir = this.getLogDirectory(workingDir);
                continue;
            }
            if (uiopt != IUiOptions.UiOption.Environment) continue;
            String environment = this.cli_props.getProperty(uiopt.pname());
            String allInOne = this.cli_props.getProperty(IUiOptions.UiOption.AllInOne.pname());
            environment = DuccUiUtilities.fixupEnvironment(environment, allInOne, logDir);
            this.cli_props.setProperty(uiopt.pname(), environment);
        }
    }

    private String resolvePlaceholders(String contents, List<String> envNameList) {
        Pattern pattern = Pattern.compile("\\$\\{(.*?)\\}");
        Matcher matcher = pattern.matcher(contents);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            String key = matcher.group(1);
            String value = System.getProperty(key);
            if (value == null) {
                value = System.getenv(key);
            }
            if (value != null) {
                matcher.appendReplacement(sb, value);
                continue;
            }
            matcher.appendReplacement(sb, "");
            value = "${" + key + "}";
            sb.append(value);
            if (envNameList.contains(key)) continue;
            this.message("WARN: undefined placeholder", value, "not replaced");
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    void saveSpec(String name, DuccProperties props) throws Exception {
        String directory = props.getProperty("log_directory") + File.separator + this.friendlyId;
        String fileName = directory + File.separator + name;
        File f = new File(directory);
        f.mkdirs();
        if (!f.exists()) {
            throw new IllegalStateException("saveSpec: Cannot create log directory: " + f.toString());
        }
        String comments = null;
        OutputStreamWriter out = new OutputStreamWriter(new FileOutputStream(fileName));
        String key = IUiOptions.UiOption.Signature.pname();
        if (props.containsKey((Object)key)) {
            Object value = props.remove((Object)key);
            props.store((Writer)out, comments);
            props.put((Object)key, value);
        } else {
            props.store((Writer)out, comments);
        }
        out.close();
        fileName = directory + File.separator + "specified-by-user.properties";
        out = new OutputStreamWriter(new FileOutputStream(fileName));
        this.userSpecifiedProperties.store(out, comments);
        out.close();
    }

    boolean extractReply(AbstractDuccOrchestratorEvent reply) {
        String pid;
        ArrayList value_submit_errors;
        boolean rc = true;
        Properties properties = reply.getProperties();
        ArrayList value_submit_warnings = (ArrayList)properties.get(IUiOptions.UiOption.SubmitWarnings.pname());
        if (value_submit_warnings != null) {
            this.message("Job warnings:");
            Iterator reasons = value_submit_warnings.iterator();
            while (reasons.hasNext()) {
                this.message("WARN:", (String)reasons.next());
            }
        }
        if ((value_submit_errors = (ArrayList)properties.get(IUiOptions.UiOption.SubmitErrors.pname())) != null) {
            this.message("Job errors:");
            Iterator reasons = value_submit_errors.iterator();
            while (reasons.hasNext()) {
                this.message("ERROR:", (String)reasons.next());
            }
            rc = false;
        }
        if ((pid = reply.getProperties().getProperty(IUiOptions.UiOption.JobId.pname())) == null) {
            this.message("ERROR: Request ID not found in reply");
            rc = false;
        } else {
            this.friendlyId = Long.parseLong(pid);
            if (this.friendlyId < 0L) {
                this.message("ERROR: Invalid Request ID", pid);
                rc = false;
            }
        }
        return rc;
    }

    void usage(String message) {
        if (message != null) {
            System.out.println(message);
        }
        System.out.println(this.commandLine.formatHelp(this.myClassName));
        System.exit(1);
    }

    public boolean setProperty(String key, String value) {
        if (!this.commandLine.isOptionName(key)) {
            return false;
        }
        this.cli_props.setProperty(key, value);
        return true;
    }

    protected IDuccCallback getCallback() {
        return this.consoleCb;
    }

    synchronized void message(String ... e) {
        if (e.length > 1) {
            StringBuffer sb = new StringBuffer();
            int i = 0;
            for (i = 0; i < e.length - 1; ++i) {
                sb.append(e[i]);
                sb.append(' ');
            }
            sb.append(e[i]);
            this.consoleCb.status(sb.toString());
        } else {
            this.consoleCb.status(e[0]);
        }
    }

    public int getReturnCode() {
        this.waitForCompletion();
        return this.returnCode;
    }

    public synchronized long getDuccId() {
        return this.friendlyId;
    }

    synchronized void consoleExits() {
        if (this.waiter != null) {
            this.waiter.countDown();
        }
    }

    synchronized void monitorExits(int rc) {
        this.returnCode = rc;
        if (this.waiter != null) {
            this.waiter.countDown();
        }
        if (this.console_listener != null) {
            this.console_listener.shutdown();
        }
    }

    protected synchronized void startMonitors(boolean start_stdin, IDuccContext.DuccContext context) throws Exception {
        boolean monitor_attach;
        int wait_count = 0;
        if (this.console_listener != null) {
            ++wait_count;
        }
        boolean bl = monitor_attach = this.cli_props.containsKey((Object)IUiOptions.UiOption.WaitForCompletion.pname()) || this.cli_props.containsKey((Object)IUiOptions.UiOption.CancelOnInterrupt.pname());
        if (monitor_attach) {
            ++wait_count;
        }
        if (wait_count > 0) {
            this.waiter = new CountDownLatch(wait_count);
            if (this.console_listener != null) {
                this.startConsoleListener(start_stdin);
            }
            if (monitor_attach) {
                this.startMonitor(context);
            }
        }
    }

    protected synchronized void startMonitor(IDuccContext.DuccContext context) {
        this.monitor_listener = new MonitorListener(this, this.friendlyId, this.cli_props, context);
        Thread mlt = new Thread(this.monitor_listener);
        mlt.start();
    }

    protected void initConsoleListener() throws Exception {
        String key;
        String env;
        String value;
        this.console_attach = this.cli_props.containsKey((Object)IUiOptions.UiOption.AttachConsole.pname());
        if (this.console_attach) {
            this.console_listener = new ConsoleListener(this, this.consoleCb);
            value = this.console_listener.getConsoleHostAddress();
            if (this.myClassName.equals(DuccManagedReservationSubmit.class.getName())) {
                value = value + "?splitstreams";
            }
        } else if (this.suppress_console_log) {
            value = "suppress";
        } else {
            return;
        }
        env = (env = this.cli_props.getProperty(key = IUiOptions.UiOption.Environment.pname())) == null ? "DUCC_CONSOLE_LISTENER=" + value : env + " DUCC_CONSOLE_LISTENER=" + value;
        this.cli_props.setProperty(key, env);
    }

    protected synchronized void startConsoleListener(boolean start_stdin) throws Exception {
        if (this.console_attach) {
            this.console_listener.startStdin(start_stdin);
            Thread t = new Thread(this.console_listener);
            t.start();
        } else {
            this.message("WARN: Attermpt to start console but no console listener is defined.");
        }
    }

    protected synchronized void stopListeners() {
        if (this.console_listener != null) {
            this.console_listener.shutdown();
            this.console_listener = null;
        }
        if (this.monitor_listener != null) {
            this.monitor_listener.shutdown();
            this.monitor_listener = null;
        }
    }

    public boolean isConsoleAttached() {
        return this.console_listener != null && !this.console_listener.isShutdown();
    }

    public boolean waitForCompletion() {
        try {
            if (this.waiter != null) {
                this.waiter.await();
                return true;
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return false;
    }
}

