/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.cli.ws;

import java.net.InetAddress;
import org.apache.uima.ducc.common.utils.DuccPropertiesResolver;
import org.apache.uima.ducc.common.utils.Utils;

public class DuccWebQuery {
    protected DuccPropertiesResolver dpr = DuccPropertiesResolver.getInstance();
    protected String DUCC_HOME = Utils.findDuccHome();
    protected String ws_scheme = "http";
    protected String ws_host = "localhost";
    protected String ws_port = "42133";
    protected String ws_servlet = null;
    protected boolean showURL = true;

    protected DuccWebQuery(String servlet) {
        this.assert_ducc_home();
        this.determine_host();
        this.determine_port();
        this.ws_servlet = servlet;
    }

    protected void assert_ducc_home() {
        if (this.DUCC_HOME == null) {
            throw new RuntimeException("DUCC_HOME not specified");
        }
    }

    protected void determine_host() {
        try {
            this.ws_host = InetAddress.getLocalHost().getHostName();
        }
        catch (Exception e) {
            // empty catch block
        }
        String host = this.dpr.getProperty("ducc.ws.node");
        if (host != null) {
            this.ws_host = host;
        }
        if (this.ws_host != null && this.ws_host.length() > 0 && !this.ws_host.contains(".")) {
            try {
                InetAddress addr = InetAddress.getLocalHost();
                String canonicalHostName = addr.getCanonicalHostName();
                if (canonicalHostName.startsWith(this.ws_host)) {
                    this.ws_host = canonicalHostName;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected void determine_port() {
        String port = this.dpr.getProperty("ducc.ws.port");
        if (port != null) {
            this.ws_port = port;
        }
    }

    protected String getUrlString() {
        String urlString = this.ws_scheme + "://" + this.ws_host + ":" + this.ws_port + this.ws_servlet;
        if (this.showURL) {
            System.out.println(urlString);
        }
        return urlString;
    }
}

