/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.cli;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLStreamHandler;
import java.util.HashMap;
import org.apache.uima.UIMAFramework;
import org.apache.uima.aae.client.UimaASProcessStatus;
import org.apache.uima.aae.client.UimaAsBaseCallbackListener;
import org.apache.uima.adapter.jms.client.BaseUIMAAsynchronousEngineCommon_impl;
import org.apache.uima.adapter.jms.client.BaseUIMAAsynchronousEngine_impl;
import org.apache.uima.cas.CAS;
import org.apache.uima.collection.EntityProcessStatus;
import org.apache.uima.ducc.cli.AServicePing;
import org.apache.uima.ducc.cli.ServiceStatistics;
import org.apache.uima.ducc.cli.UimaAsServiceMonitor;
import org.apache.uima.ducc.common.IServiceStatistics;
import org.apache.uima.ducc.common.TcpStreamHandler;
import org.apache.uima.ducc.common.utils.DuccProperties;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.util.Level;

public class UimaAsPing
extends AServicePing {
    String ep;
    String endpoint;
    String broker;
    int meta_timeout;
    String broker_host;
    int broker_jmx_port;
    boolean connected;
    UimaAsServiceMonitor monitor;
    int[] queueSizeWindow;
    int queueCursor = 0;
    String nodeIp;
    String pid;
    boolean gmfail = false;

    @Override
    public void init(String args, String ep) throws Exception {
        this.ep = ep;
        int ndx = ep.indexOf(":");
        ep = ep.substring(ndx + 1);
        ndx = ep.indexOf(":");
        this.endpoint = ep.substring(0, ndx).trim();
        this.broker = ep.substring(ndx + 1).trim();
        URL url = null;
        try {
            url = new URL(null, this.broker, (URLStreamHandler)new TcpStreamHandler());
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Invalid broker URL: " + this.broker);
        }
        this.broker_host = url.getHost();
        UIMAFramework.getLogger(BaseUIMAAsynchronousEngineCommon_impl.class).setLevel(Level.OFF);
        UIMAFramework.getLogger(BaseUIMAAsynchronousEngine_impl.class).setLevel(Level.OFF);
        UIMAFramework.getLogger().setLevel(Level.OFF);
        if (args == null) {
            this.meta_timeout = 5000;
            this.broker_jmx_port = 1099;
        } else {
            String[] as = args.split(",");
            StringWriter sw = new StringWriter();
            for (String s : as) {
                sw.write(s + "\n");
            }
            StringReader sr = new StringReader(sw.toString());
            DuccProperties props = new DuccProperties();
            try {
                props.load((Reader)sr);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.meta_timeout = props.getIntProperty("meta-timeout", 5000);
            String broker_tmp_jmx = props.getProperty("broker-jmx-port");
            if (broker_tmp_jmx.equals("none")) {
                this.broker_jmx_port = -1;
                this.monitor = null;
            } else {
                this.broker_jmx_port = props.getIntProperty("broker-jmx-port", 1099);
                this.monitor = new UimaAsServiceMonitor(this.endpoint, this.broker_host, this.broker_jmx_port);
            }
        }
    }

    @Override
    public void stop() {
        if (this.monitor != null) {
            this.monitor.stop();
        }
    }

    void evaluateService(IServiceStatistics stats) {
        try {
            if (this.monitor != null) {
                this.monitor.collect();
                long cc = this.monitor.getProducerCount();
                if (cc > 0L) {
                    this.last_use = System.currentTimeMillis();
                }
            }
            stats.setHealthy(true);
        }
        catch (Throwable t) {
            stats.setHealthy(false);
            this.monitor.setJmxFailure(t.getMessage());
        }
    }

    @Override
    public long getLastUse() {
        return this.last_use;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public IServiceStatistics getStatistics() {
        ResourceInitializationException excp;
        String failure_reason;
        ServiceStatistics statistics;
        String methodName;
        block16: {
            methodName = "getStatistics";
            statistics = new ServiceStatistics(false, false, "<NA>");
            failure_reason = null;
            this.nodeIp = "N/A";
            this.pid = "N/A";
            this.evaluateService(statistics);
            BaseUIMAAsynchronousEngine_impl uimaAsEngine = new BaseUIMAAsynchronousEngine_impl();
            UimaCbListener listener = new UimaCbListener();
            uimaAsEngine.addStatusCallbackListener((UimaAsBaseCallbackListener)listener);
            HashMap<String, Object> appCtx = new HashMap<String, Object>();
            appCtx.put("ServerURI", this.broker);
            appCtx.put("Endpoint", this.endpoint);
            appCtx.put("GetMetaTimeout", this.meta_timeout);
            appCtx.put("cas_initial_heap_size", "1000");
            excp = null;
            this.gmfail = false;
            uimaAsEngine.initialize(appCtx);
            statistics.setAlive(true);
            statistics.setHealthy(statistics.isHealthy());
            listener.ok();
            try {
                uimaAsEngine.stop();
            }
            catch (Throwable e) {
                this.doLog(methodName, "Exception on UIMA-AS connection stop: " + e.toString());
            }
            break block16;
            catch (ResourceInitializationException e) {
                try {
                    excp = e;
                    listener.timeout();
                    statistics.setHealthy(false);
                    statistics.setAlive(false);
                }
                catch (Throwable throwable) {
                    try {
                        uimaAsEngine.stop();
                    }
                    catch (Throwable e2) {
                        this.doLog(methodName, "Exception on UIMA-AS connection stop: " + e2.toString());
                    }
                    throw throwable;
                }
                try {
                    uimaAsEngine.stop();
                }
                catch (Throwable e3) {
                    this.doLog(methodName, "Exception on UIMA-AS connection stop: " + e3.toString());
                }
            }
        }
        if (this.gmfail || excp != null) {
            failure_reason = "Cannot issue getMeta to: " + this.endpoint + ":" + this.broker;
            if (excp != null) {
                failure_reason = excp.getCause() == null ? failure_reason + ": " + excp.toString() : failure_reason + ": " + excp.getCause();
            }
            this.doLog(methodName, failure_reason);
        }
        if (this.monitor == null) {
            if (failure_reason != null) {
                statistics.setInfo(failure_reason);
            } else {
                statistics.setInfo("Ping to " + this.nodeIp + ": " + this.pid + " ok. (JMX disabled.)");
            }
        } else {
            this.monitor.setSource(this.nodeIp, this.pid, this.gmfail, failure_reason);
            statistics.setInfo(this.monitor.format());
        }
        return statistics;
    }

    class UimaCbListener
    extends UimaAsBaseCallbackListener {
        public void ok() {
            UimaAsPing.this.gmfail = false;
        }

        public void timeout() {
            String methodName = "UimaAsPing:get-meta";
            UimaAsPing.this.doLog(methodName, null, "Get-Meta timeout from ", UimaAsPing.this.nodeIp, "PID", UimaAsPing.this.pid);
            UimaAsPing.this.gmfail = true;
        }

        public void onBeforeMessageSend(UimaASProcessStatus status) {
        }

        public void onBeforeProcessMeta(String IP, String p) {
            String methodName = "UimaAsPing:onBeforeProcessMeta";
            UimaAsPing.this.doLog(methodName, null, "Get-Meta received from ", IP, ":", p, "for", UimaAsPing.this.ep);
            UimaAsPing.this.pid = p;
            UimaAsPing.this.nodeIp = IP;
        }

        public void initializationComplete(EntityProcessStatus aStatus) {
        }

        public void entityProcessComplete(CAS aCas, EntityProcessStatus aStatus) {
        }

        public void collectionProcessComplete(EntityProcessStatus aStatus) {
        }
    }
}

