/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.cli;

import com.google.gson.Gson;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.management.ManagementFactory;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Date;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.PosixParser;
import org.apache.uima.ducc.cli.CliBase;
import org.apache.uima.ducc.cli.DefaultCallback;
import org.apache.uima.ducc.cli.DuccJobMonitor;
import org.apache.uima.ducc.cli.IDuccCallback;
import org.apache.uima.ducc.cli.IUiOptions;
import org.apache.uima.ducc.common.json.MonitorInfo;
import org.apache.uima.ducc.common.utils.DuccPropertiesResolver;
import org.apache.uima.ducc.common.utils.SynchronizedSimpleDateFormat;
import org.apache.uima.ducc.common.utils.Utils;
import org.apache.uima.ducc.transport.event.IDuccContext;

public abstract class DuccMonitor {
    protected static final int RC_SUCCESS = 0;
    protected static final int RC_FAILURE = 1;
    protected static final int RC_HELP = 1;
    protected static final String NotFound = "NotFound";
    protected static final String StateRunning = "Running";
    protected static final String StateCompleting = "Completing";
    protected static final String StateCompleted = "Completed";
    private Options options = new Options();
    private IUiOptions.UiOption[] opts = new IUiOptions.UiOption[0];
    private String id = null;
    private AtomicBoolean flag_cancel_on_interrupt = new AtomicBoolean(false);
    private AtomicBoolean flag_debug = new AtomicBoolean(false);
    private AtomicBoolean flag_error = new AtomicBoolean(true);
    private AtomicBoolean flag_info = new AtomicBoolean(true);
    private AtomicBoolean flag_trace = new AtomicBoolean(false);
    private AtomicBoolean flag_timestamp = new AtomicBoolean(false);
    private AtomicBoolean flag_observer = new AtomicBoolean(true);
    private int milliseconds = 1;
    private int seconds = 1000 * this.milliseconds;
    private int wakeupInterval = 15 * this.seconds;
    private int urlTimeout = 60 * this.seconds;
    private Thread main = null;
    private DuccPropertiesResolver duccPropertiesResolver = null;
    private IDuccContext.DuccContext context = null;
    IDuccCallback messageProcessor = null;
    private SynchronizedSimpleDateFormat sdf = new SynchronizedSimpleDateFormat("dd/MM/yyyy HH:mm:ss");
    private IUiOptions.UiOption[] optsSubmitJob = new IUiOptions.UiOption[]{IUiOptions.UiOption.Help, IUiOptions.UiOption.Debug, IUiOptions.UiOption.Quiet, IUiOptions.UiOption.Timestamp, IUiOptions.UiOption.JobId, IUiOptions.UiOption.CancelOnInterrupt};
    private IUiOptions.UiOption[] optsMonitorJob = new IUiOptions.UiOption[]{IUiOptions.UiOption.Help, IUiOptions.UiOption.Debug, IUiOptions.UiOption.Quiet, IUiOptions.UiOption.Timestamp, IUiOptions.UiOption.JobId};
    private IUiOptions.UiOption[] optsSubmitManagedReservation = new IUiOptions.UiOption[]{IUiOptions.UiOption.Help, IUiOptions.UiOption.Debug, IUiOptions.UiOption.Quiet, IUiOptions.UiOption.Timestamp, IUiOptions.UiOption.ManagedReservationId, IUiOptions.UiOption.CancelOnInterrupt};
    private IUiOptions.UiOption[] optsMonitorManagedReservation = new IUiOptions.UiOption[]{IUiOptions.UiOption.Help, IUiOptions.UiOption.Debug, IUiOptions.UiOption.Quiet, IUiOptions.UiOption.Timestamp, IUiOptions.UiOption.ManagedReservationId};

    protected DuccMonitor(IDuccContext.DuccContext context, boolean submit) {
        this.initialize(context, submit, new DefaultCallback());
    }

    protected DuccMonitor(IDuccContext.DuccContext context, boolean submit, IDuccCallback messageProcessor) {
        this.initialize(context, submit, messageProcessor);
    }

    public abstract void help(Options var1);

    public abstract void cancel();

    public abstract String getUrl(String var1);

    public String getHost() {
        String host = this.duccPropertiesResolver.getFileProperty("ducc.ws.node");
        if (host == null) {
            host = this.duccPropertiesResolver.getFileProperty("ducc.head");
        }
        return host;
    }

    public String getPort() {
        String port = this.duccPropertiesResolver.getFileProperty("ducc.ws.port");
        return port;
    }

    public String getId() {
        return this.id;
    }

    private void initialize(IDuccContext.DuccContext context, boolean submit, IDuccCallback messageProcessor) {
        this.context = context;
        if (context != null) {
            switch (context) {
                case Job: {
                    if (submit) {
                        this.opts = this.optsSubmitJob;
                        break;
                    }
                    this.opts = this.optsMonitorJob;
                    break;
                }
                case ManagedReservation: {
                    if (submit) {
                        this.opts = this.optsSubmitManagedReservation;
                        break;
                    }
                    this.opts = this.optsMonitorManagedReservation;
                    break;
                }
            }
        }
        this.options = CliBase.makeOptions(this.opts);
        if (messageProcessor != null) {
            this.messageProcessor = messageProcessor;
        }
    }

    protected void trace(String message) {
        if (this.flag_trace.get()) {
            this.messageProcessor.status(this.timestamp(message));
        }
    }

    protected void debug(String message) {
        if (this.flag_debug.get()) {
            this.messageProcessor.status(this.timestamp(message));
        }
    }

    protected void debug(Exception e) {
        if (this.flag_debug.get()) {
            this.messageProcessor.status(e.toString());
        }
    }

    private void info(String message) {
        if (this.flag_info.get()) {
            this.messageProcessor.status(this.timestamp(message));
        }
    }

    private void error(String message) {
        if (this.flag_error.get()) {
            this.messageProcessor.status(this.timestamp(message));
        }
    }

    protected String timestamp(String message) {
        String tMessage = message;
        if (this.flag_timestamp.get()) {
            String date = this.sdf.format(new Date());
            tMessage = date + " " + message;
        }
        return tMessage;
    }

    private String details(MonitorInfo monitorInfo) {
        StringBuffer sb = new StringBuffer();
        switch (this.context) {
            case Job: {
                sb.append(" ");
                sb.append("total:");
                sb.append(monitorInfo.total);
                sb.append(" ");
                sb.append("done:");
                sb.append(monitorInfo.done);
                sb.append(" ");
                sb.append("error:");
                sb.append(monitorInfo.error);
                sb.append(" ");
                sb.append("retry:");
                sb.append(monitorInfo.retry);
                sb.append(" ");
                sb.append("procs:");
                sb.append(monitorInfo.procs);
            }
        }
        return sb.toString();
    }

    private void adjustWakeupInterval() {
        String rate = this.duccPropertiesResolver.getFileProperty("ducc.orchestrator.state.publish.rate");
        try {
            this.wakeupInterval = Integer.parseInt(rate);
        }
        catch (Exception e) {
            this.debug(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int runInternal(String[] args) throws Exception {
        String ducc_home = Utils.findDuccHome();
        if (ducc_home == null) {
            this.messageProcessor.status("Missing required environment variable: DUCC_HOME");
            return 1;
        }
        this.duccPropertiesResolver = DuccPropertiesResolver.getInstance();
        Class<DuccMonitor> clazz = DuccMonitor.class;
        synchronized (DuccMonitor.class) {
            PosixParser parser = new PosixParser();
            CommandLine commandLine = parser.parse(this.options, args);
            if (commandLine.hasOption("help")) {
                this.help(this.options);
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return 1;
            }
            if (commandLine.getOptions().length == 0) {
                this.help(this.options);
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return 1;
            }
            if (commandLine.hasOption(IUiOptions.UiOption.Timestamp.pname())) {
                this.flag_timestamp.set(true);
            }
            if (commandLine.hasOption(IUiOptions.UiOption.Quiet.pname())) {
                this.flag_info.set(false);
                this.flag_error.set(false);
            }
            if (commandLine.hasOption(IUiOptions.UiOption.Debug.pname())) {
                this.flag_debug.set(true);
            }
            if (commandLine.hasOption(IUiOptions.UiOption.CancelOnInterrupt.pname())) {
                this.flag_cancel_on_interrupt.set(true);
            }
            if (commandLine.hasOption(IUiOptions.UiOption.JobId.pname())) {
                this.id = commandLine.getOptionValue(IUiOptions.UiOption.JobId.pname());
            } else if (commandLine.hasOption(IUiOptions.UiOption.ManagedReservationId.pname())) {
                this.id = commandLine.getOptionValue(IUiOptions.UiOption.ManagedReservationId.pname());
            } else {
                HelpFormatter formatter = new HelpFormatter();
                formatter.setWidth(110);
                formatter.printHelp(DuccJobMonitor.class.getName(), this.options);
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return 1;
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            this.main = Thread.currentThread();
            Killer killer = new Killer(this.main);
            Runtime.getRuntime().addShutdownHook(killer);
            this.adjustWakeupInterval();
            String urlString = this.getUrl(this.id);
            String lastMessage = "";
            String thisMessage = "";
            StringBuffer message = new StringBuffer();
            message.append("id:" + this.id);
            message.append(" ");
            message.append("location:");
            message.append(ManagementFactory.getRuntimeMXBean().getName());
            this.info(message.toString());
            while (this.flag_observer.get()) {
                long start;
                String json = this.getSingleLineStatus(urlString);
                if (json != null) {
                    this.debug(json);
                    Gson gson = new Gson();
                    MonitorInfo monitorInfo = (MonitorInfo)gson.fromJson(json, MonitorInfo.class);
                    int stateCount = monitorInfo.stateSequence.size();
                    this.debug("states:" + stateCount);
                    if (stateCount <= 0) {
                        message = new StringBuffer();
                        message.append("id:" + this.id);
                        message.append(" ");
                        message.append("state:NotFound");
                        thisMessage = message.toString();
                        this.info(thisMessage);
                        message = new StringBuffer();
                        message.append("id:" + this.id);
                        message.append(" ");
                        message.append("rc:1");
                        thisMessage = message.toString();
                        this.info(thisMessage);
                        return 1;
                    }
                    String state2 = "";
                    for (String state2 : monitorInfo.stateSequence) {
                        this.debug("list:" + state2);
                    }
                    message = new StringBuffer();
                    message.append("id:" + this.id);
                    message.append(" ");
                    message.append("state:" + state2);
                    if (state2.equals(StateRunning)) {
                        message.append(this.details(monitorInfo));
                    } else if (state2.equals(StateCompleting)) {
                        this.flag_cancel_on_interrupt.set(false);
                        message.append(this.details(monitorInfo));
                    } else if (state2.equals(StateCompleted)) {
                        this.flag_cancel_on_interrupt.set(false);
                        message.append(this.details(monitorInfo));
                    }
                    thisMessage = message.toString();
                    if (!thisMessage.equals(lastMessage)) {
                        this.info(thisMessage);
                        lastMessage = thisMessage;
                    }
                    if (state2.equals(StateCompleted)) {
                        if (monitorInfo.total.equals(monitorInfo.done)) {
                            if (!monitorInfo.rationale.equals("")) {
                                message = new StringBuffer();
                                message.append("id:" + this.id);
                                message.append(" rationale:" + monitorInfo.rationale);
                                thisMessage = message.toString();
                                this.info(thisMessage);
                            }
                            int rc = 1;
                            message = new StringBuffer();
                            message.append("id:" + this.id);
                            try {
                                rc = Integer.parseInt(monitorInfo.code);
                                message.append(" rc:" + rc);
                            }
                            catch (NumberFormatException e) {
                                message.append(" code:" + monitorInfo.code);
                            }
                            thisMessage = message.toString();
                            this.info(thisMessage);
                            return rc;
                        }
                        if (!monitorInfo.errorLogs.isEmpty()) {
                            message = new StringBuffer();
                            message.append("id:" + this.id);
                            ArrayList errorLogs = monitorInfo.errorLogs;
                            for (String errorLog : errorLogs) {
                                message.append(" file:" + errorLog);
                            }
                            thisMessage = message.toString();
                            this.info(thisMessage);
                        }
                        if (!monitorInfo.rationale.equals("")) {
                            message = new StringBuffer();
                            message.append("id:" + this.id);
                            message.append(" rationale:" + monitorInfo.rationale);
                            thisMessage = message.toString();
                            this.info(thisMessage);
                        }
                        message = new StringBuffer();
                        message.append("id:" + this.id);
                        message.append(" rc:1");
                        thisMessage = message.toString();
                        this.info(thisMessage);
                        return 1;
                    }
                } else {
                    this.error("error: accessing " + urlString);
                }
                long end = start = System.currentTimeMillis();
                while (!this.isTimeExpired(start, end, this.wakeupInterval) && this.flag_observer.get()) {
                    try {
                        Thread.sleep(this.wakeupInterval);
                    }
                    catch (InterruptedException e) {
                        this.debug(e);
                    }
                    end = System.currentTimeMillis();
                }
            }
            return 0;
        }
    }

    private boolean isTimeExpired(long start, long end, long interval) {
        boolean retVal = false;
        long diff = end - start;
        if (diff >= interval) {
            retVal = true;
        }
        this.trace("start:" + start + " " + "end:" + end + " " + "diff:" + diff + " " + "interval:" + interval + " " + "result:" + retVal);
        return retVal;
    }

    private String getSingleLineStatus(String urlString) {
        String line = null;
        URL url = null;
        try {
            url = new URL(urlString);
            URLConnection uc = url.openConnection();
            uc.setReadTimeout(this.urlTimeout);
            BufferedReader br = new BufferedReader(new InputStreamReader(uc.getInputStream()));
            line = br.readLine();
            br.close();
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return line;
    }

    public int run(String[] args) {
        int code = 1;
        try {
            code = this.runInternal(args);
        }
        catch (Exception e) {
            this.messageProcessor.status("ERROR: " + e.toString());
        }
        this.debug("rc=" + code);
        return code;
    }

    private class Killer
    extends Thread {
        public Killer(Thread thread) {
        }

        @Override
        public void run() {
            StringBuffer message = new StringBuffer();
            if (DuccMonitor.this.flag_cancel_on_interrupt.get()) {
                message.append("killer: cancel");
                DuccMonitor.this.cancel();
            } else {
                message.append("killer: no cancel");
            }
            DuccMonitor.this.debug(message.toString());
            DuccMonitor.this.flag_observer.set(false);
        }
    }
}

