/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.cli;

import java.util.List;
import java.util.Properties;
import org.apache.uima.ducc.cli.CliBase;
import org.apache.uima.ducc.cli.CliVersion;
import org.apache.uima.ducc.cli.IUiOptions;
import org.apache.uima.ducc.common.utils.DuccProperties;
import org.apache.uima.ducc.transport.event.AbstractDuccOrchestratorEvent;
import org.apache.uima.ducc.transport.event.CancelJobDuccEvent;
import org.apache.uima.ducc.transport.event.CancelJobReplyDuccEvent;
import org.apache.uima.ducc.transport.event.DuccEvent;
import org.apache.uima.ducc.transport.event.cli.JobRequestProperties;

public class DuccJobCancel
extends CliBase {
    JobRequestProperties jobRequestProperties = new JobRequestProperties();
    long canceledPid = -1L;
    String responseMessage = null;
    IUiOptions.UiOption[] opts = new IUiOptions.UiOption[]{IUiOptions.UiOption.Help, IUiOptions.UiOption.Debug, IUiOptions.UiOption.JobId, IUiOptions.UiOption.DjPid, IUiOptions.UiOption.Reason, IUiOptions.UiOption.RoleAdministrator};

    public DuccJobCancel(String[] args) throws Exception {
        this.init(this.getClass().getName(), this.opts, args, (DuccProperties)this.jobRequestProperties, null);
    }

    public DuccJobCancel(List<String> args) throws Exception {
        String[] arg_array = args.toArray(new String[args.size()]);
        this.init(this.getClass().getName(), this.opts, arg_array, (DuccProperties)this.jobRequestProperties, null);
    }

    public DuccJobCancel(Properties props) throws Exception {
        this.init(this.getClass().getName(), this.opts, props, (DuccProperties)this.jobRequestProperties, null);
    }

    public long getCanceledPid() {
        return this.canceledPid;
    }

    public String getResponseMessage() {
        return this.responseMessage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute() throws Exception {
        CancelJobDuccEvent cancelJobDuccEvent = new CancelJobDuccEvent((DuccProperties)this.jobRequestProperties, CliVersion.getVersion());
        CancelJobReplyDuccEvent cancelJobReplyDuccEvent = null;
        try {
            cancelJobReplyDuccEvent = (CancelJobReplyDuccEvent)this.dispatcher.dispatchAndWaitForDuccReply((DuccEvent)cancelJobDuccEvent);
        }
        catch (Exception e) {
            this.message("Job not submitted:", e.getMessage());
            boolean bl = false;
            return bl;
        }
        finally {
            this.dispatcher.close();
        }
        boolean rc = this.extractReply((AbstractDuccOrchestratorEvent)cancelJobReplyDuccEvent);
        String dpId = cancelJobReplyDuccEvent.getProperties().getProperty(IUiOptions.UiOption.DjPid.pname());
        if (dpId != null) {
            this.canceledPid = Long.parseLong(dpId);
        }
        this.responseMessage = cancelJobReplyDuccEvent.getProperties().getProperty(IUiOptions.UiOption.Message.pname());
        return rc;
    }

    public static void main(String[] args) {
        try {
            DuccJobCancel djc = new DuccJobCancel(args);
            boolean rc = djc.execute();
            long id = djc.getDuccId();
            String msg = djc.getResponseMessage();
            long dpid = djc.getCanceledPid();
            if (dpid == -1L) {
                System.out.println("Job " + id + " " + msg);
            } else {
                System.out.println("Process " + id + "." + dpid + " " + msg);
            }
            System.exit(rc ? 0 : 1);
        }
        catch (Exception e) {
            System.out.println("Cannot cancel: " + e.getMessage());
            System.exit(1);
        }
    }
}

