/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.cli;

import java.util.ArrayList;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.uima.ducc.cli.CliBase;
import org.apache.uima.ducc.cli.DuccUiUtilities;
import org.apache.uima.ducc.cli.IDuccCallback;
import org.apache.uima.ducc.cli.IUiOptions;
import org.apache.uima.ducc.common.Pair;
import org.apache.uima.ducc.common.utils.DuccProperties;
import org.apache.uima.ducc.common.utils.DuccPropertiesResolver;
import org.apache.uima.ducc.common.utils.DuccSchedulerClasses;
import org.apache.uima.ducc.transport.event.DuccEvent;
import org.apache.uima.ducc.transport.event.ServiceModifyEvent;
import org.apache.uima.ducc.transport.event.ServiceQueryEvent;
import org.apache.uima.ducc.transport.event.ServiceRegisterEvent;
import org.apache.uima.ducc.transport.event.ServiceStartEvent;
import org.apache.uima.ducc.transport.event.ServiceStopEvent;
import org.apache.uima.ducc.transport.event.ServiceUnregisterEvent;
import org.apache.uima.ducc.transport.event.sm.IService;
import org.apache.uima.ducc.transport.event.sm.IServiceReply;

public class DuccServiceApi
extends CliBase {
    String endpoint = null;
    IDuccCallback callback = null;
    IUiOptions.UiOption[] registration_options = new IUiOptions.UiOption[]{IUiOptions.UiOption.Help, IUiOptions.UiOption.Debug, IUiOptions.UiOption.Description, IUiOptions.UiOption.SchedulingClass, IUiOptions.UiOption.LogDirectory, IUiOptions.UiOption.SuppressConsoleLog, IUiOptions.UiOption.WorkingDirectory, IUiOptions.UiOption.Jvm, IUiOptions.UiOption.ProcessJvmArgs, IUiOptions.UiOption.Classpath, IUiOptions.UiOption.Environment, IUiOptions.UiOption.ProcessMemorySize, IUiOptions.UiOption.ProcessDD, IUiOptions.UiOption.ProcessExecutable, IUiOptions.UiOption.ProcessExecutableArgs, IUiOptions.UiOption.InstanceFailuresLimit, IUiOptions.UiOption.ClasspathOrder, IUiOptions.UiOption.ServiceDependency, IUiOptions.UiOption.ServiceRequestEndpoint, IUiOptions.UiOption.ServiceLinger, IUiOptions.UiOption.ServicePingArguments, IUiOptions.UiOption.ServicePingClass, IUiOptions.UiOption.ServicePingClasspath, IUiOptions.UiOption.ServicePingJvmArgs, IUiOptions.UiOption.ServicePingTimeout, IUiOptions.UiOption.ServicePingDoLog, IUiOptions.UiOption.Register, IUiOptions.UiOption.Autostart, IUiOptions.UiOption.Instances};
    IUiOptions.UiOption[] unregister_options = new IUiOptions.UiOption[]{IUiOptions.UiOption.Help, IUiOptions.UiOption.Debug, IUiOptions.UiOption.Unregister};
    IUiOptions.UiOption[] start_options = new IUiOptions.UiOption[]{IUiOptions.UiOption.Help, IUiOptions.UiOption.Debug, IUiOptions.UiOption.Start, IUiOptions.UiOption.Instances, IUiOptions.UiOption.Update};
    IUiOptions.UiOption[] stop_options = new IUiOptions.UiOption[]{IUiOptions.UiOption.Help, IUiOptions.UiOption.Debug, IUiOptions.UiOption.Stop, IUiOptions.UiOption.Instances, IUiOptions.UiOption.Update};
    IUiOptions.UiOption[] modify_options = new IUiOptions.UiOption[]{IUiOptions.UiOption.Help, IUiOptions.UiOption.Debug, IUiOptions.UiOption.Modify, IUiOptions.UiOption.Instances, IUiOptions.UiOption.Autostart, IUiOptions.UiOption.Activate};
    IUiOptions.UiOption[] query_options = new IUiOptions.UiOption[]{IUiOptions.UiOption.Help, IUiOptions.UiOption.Debug, IUiOptions.UiOption.Query};

    public DuccServiceApi(IDuccCallback cb) {
        this.callback = cb;
    }

    private Pair<Integer, String> getId(IUiOptions.UiOption opt) {
        String sid = this.cli_props.getProperty(opt.pname());
        if (sid == null) {
            throw new IllegalArgumentException("Missing service id: --id <id or endpoint>");
        }
        int id = -1;
        try {
            id = Integer.parseInt(sid);
            return new Pair((Object)id, null);
        }
        catch (NumberFormatException e) {
            if (sid.startsWith(IService.ServiceType.UimaAs.decode()) || sid.startsWith(IService.ServiceType.Custom.decode())) {
                return new Pair((Object)-1, (Object)sid);
            }
            throw new IllegalArgumentException("Invalid id; must be numeric or start with " + IService.ServiceType.UimaAs.decode() + " or " + IService.ServiceType.Custom.decode() + ".");
        }
    }

    private IService.Trinary getAutostart() {
        String auto = this.cli_props.getStringProperty(IUiOptions.UiOption.Autostart.pname(), null);
        if (auto == null) {
            return IService.Trinary.Unset;
        }
        boolean val = Boolean.parseBoolean(auto);
        IService.Trinary answer = IService.Trinary.encode((String)(val ? "true" : "false"));
        if (answer == IService.Trinary.Unset) {
            throw new IllegalArgumentException("--" + IUiOptions.UiOption.Autostart.pname() + " " + auto + " is not 'true' or 'false'");
        }
        return answer;
    }

    private int getInstances(int dflt) {
        int instances;
        String inst = this.cli_props.getProperty(IUiOptions.UiOption.Instances.pname());
        if (inst == null) {
            return dflt;
        }
        try {
            instances = Integer.parseInt(inst);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException(IUiOptions.UiOption.Instances.pname() + " " + inst + " is not numeric.");
        }
        if (instances <= 0) {
            throw new IllegalArgumentException(IUiOptions.UiOption.Instances.pname() + " " + inst + " must be > 0");
        }
        return instances;
    }

    private boolean getActivate() {
        return this.cli_props.containsKey((Object)IUiOptions.UiOption.Activate.pname());
    }

    private boolean getUpdate() {
        return this.cli_props.containsKey((Object)IUiOptions.UiOption.Update.pname());
    }

    private void setLinger() {
        String default_linger = DuccPropertiesResolver.get((String)"ducc.sm.default.linger", (String)"5000");
        String linger = this.cli_props.getStringProperty(IUiOptions.UiOption.ServiceLinger.pname(), default_linger);
        try {
            Long.parseLong(linger);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException(IUiOptions.UiOption.ServiceLinger.pname() + " is not numeric: " + linger);
        }
    }

    String extractEndpoint(String jvmargs) {
        String dd = this.cli_props.getStringProperty(IUiOptions.UiOption.ProcessDD.pname());
        String working_dir = this.cli_props.getStringProperty(IUiOptions.UiOption.WorkingDirectory.pname());
        this.endpoint = DuccUiUtilities.getEndpoint(working_dir, dd, jvmargs);
        if (this.debug) {
            System.out.println("Service endpoint resolves to " + this.endpoint);
        }
        return this.endpoint;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IServiceReply register(String[] args) throws Exception {
        DuccSchedulerClasses duccSchedulerClasses;
        DuccProperties dp = new DuccProperties();
        this.init(this.getClass().getName(), this.registration_options, args, null, dp, this.callback, "sm");
        this.setLinger();
        String uimaDD = this.cli_props.getStringProperty(IUiOptions.UiOption.ProcessDD.pname(), null);
        String customCmd = this.cli_props.getStringProperty(IUiOptions.UiOption.ProcessExecutable.pname(), null);
        String endpoint = this.cli_props.getStringProperty(IUiOptions.UiOption.ServiceRequestEndpoint.pname(), null);
        if (endpoint == null || endpoint.startsWith(IService.ServiceType.UimaAs.decode())) {
            if (uimaDD == null) {
                throw new IllegalArgumentException("Must specify --process_DD for UIMA-AS services");
            }
            if (customCmd != null) {
                this.message("WARN", "--process_executable is ignored for UIMA-AS services");
            }
            if (this.fixupClasspath(IUiOptions.UiOption.Classpath.pname()) == null) {
                throw new IllegalArgumentException("Specified classpath contains only DUCC jars");
            }
            String jvmarg_string = this.cli_props.getProperty(IUiOptions.UiOption.ProcessJvmArgs.pname());
            String inferred_endpoint = this.extractEndpoint(jvmarg_string);
            if (endpoint == null) {
                endpoint = inferred_endpoint;
            } else if (!inferred_endpoint.equals(endpoint)) {
                throw new IllegalArgumentException("Specified endpoint does not match endpoint extracted from UIMA DD\n --service_request_endpoint: " + endpoint + "\n                  extracted: " + inferred_endpoint);
            }
        } else if (endpoint.startsWith(IService.ServiceType.Custom.decode())) {
            if (uimaDD != null) {
                this.message("WARN", "--process_DD is ignored for CUSTOM endpoints");
            }
            if (!this.cli_props.containsKey((Object)IUiOptions.UiOption.ServicePingClass.pname())) {
                throw new IllegalArgumentException("Custom service is missing ping class name.");
            }
            this.fixupClasspath(IUiOptions.UiOption.ServicePingClasspath.pname());
        } else {
            throw new IllegalArgumentException("Invalid service endpoint: " + endpoint);
        }
        String scheduling_class = this.cli_props.getProperty(IUiOptions.UiOption.SchedulingClass.pname());
        if (scheduling_class != null && (duccSchedulerClasses = DuccSchedulerClasses.getInstance()).isPreemptable(scheduling_class)) {
            throw new IllegalArgumentException("Invalid pre-emptable scheduling class: " + scheduling_class);
        }
        if (!this.check_service_dependencies(endpoint)) {
            throw new IllegalArgumentException("Invalid service dependencies");
        }
        int instances = this.cli_props.getIntProperty(IUiOptions.UiOption.Instances.pname(), 1);
        IService.Trinary autostart = this.getAutostart();
        String user = (String)this.cli_props.remove((Object)IUiOptions.UiOption.User.pname());
        byte[] auth_block = (byte[])this.cli_props.remove((Object)IUiOptions.UiOption.Signature.pname());
        this.cli_props.remove((Object)IUiOptions.UiOption.SubmitPid.pname());
        this.cli_props.remove((Object)IUiOptions.UiOption.Register.pname());
        this.cli_props.remove((Object)IUiOptions.UiOption.Instances.pname());
        this.cli_props.remove((Object)IUiOptions.UiOption.Autostart.pname());
        ServiceRegisterEvent ev = new ServiceRegisterEvent(user, instances, autostart, endpoint, this.cli_props, auth_block);
        try {
            IServiceReply iServiceReply = (IServiceReply)this.dispatcher.dispatchAndWaitForDuccReply((DuccEvent)ev);
            return iServiceReply;
        }
        finally {
            this.dispatcher.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IServiceReply unregister(String[] args) throws Exception {
        DuccProperties dp = new DuccProperties();
        this.init(this.getClass().getName(), this.unregister_options, args, null, dp, this.callback, "sm");
        Pair<Integer, String> id = this.getId(IUiOptions.UiOption.Unregister);
        String user = dp.getProperty(IUiOptions.UiOption.User.pname());
        byte[] auth_block = (byte[])dp.get((Object)IUiOptions.UiOption.Signature.pname());
        ServiceUnregisterEvent ev = new ServiceUnregisterEvent(user, (long)((Integer)id.first()).intValue(), (String)id.second(), auth_block);
        try {
            IServiceReply iServiceReply = (IServiceReply)this.dispatcher.dispatchAndWaitForDuccReply((DuccEvent)ev);
            return iServiceReply;
        }
        finally {
            this.dispatcher.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IServiceReply start(String[] args) throws Exception {
        DuccProperties dp = new DuccProperties();
        this.init(this.getClass().getName(), this.start_options, args, null, dp, this.callback, "sm");
        Pair<Integer, String> id = this.getId(IUiOptions.UiOption.Start);
        String user = dp.getProperty(IUiOptions.UiOption.User.pname());
        byte[] auth_block = (byte[])dp.get((Object)IUiOptions.UiOption.Signature.pname());
        ServiceStartEvent ev = new ServiceStartEvent(user, ((Integer)id.first()).intValue(), (String)id.second(), auth_block);
        int instances = this.getInstances(-1);
        boolean update = this.getUpdate();
        ev.setInstances(instances);
        ev.setUpdate(update);
        try {
            IServiceReply iServiceReply = (IServiceReply)this.dispatcher.dispatchAndWaitForDuccReply((DuccEvent)ev);
            return iServiceReply;
        }
        finally {
            this.dispatcher.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IServiceReply stop(String[] args) throws Exception {
        DuccProperties dp = new DuccProperties();
        this.init(this.getClass().getName(), this.stop_options, args, null, dp, this.callback, "sm");
        Pair<Integer, String> id = this.getId(IUiOptions.UiOption.Stop);
        String user = dp.getProperty(IUiOptions.UiOption.User.pname());
        byte[] auth_block = (byte[])dp.get((Object)IUiOptions.UiOption.Signature.pname());
        ServiceStopEvent ev = new ServiceStopEvent(user, (long)((Integer)id.first()).intValue(), (String)id.second(), auth_block);
        int instances = this.getInstances(-1);
        boolean update = this.getUpdate();
        ev.setInstances(instances);
        ev.setUpdate(update);
        try {
            IServiceReply iServiceReply = (IServiceReply)this.dispatcher.dispatchAndWaitForDuccReply((DuccEvent)ev);
            return iServiceReply;
        }
        finally {
            this.dispatcher.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IServiceReply modify(String[] args) throws Exception {
        DuccProperties dp = new DuccProperties();
        this.init(this.getClass().getName(), this.modify_options, args, null, dp, this.callback, "sm");
        Pair<Integer, String> id = this.getId(IUiOptions.UiOption.Modify);
        String user = dp.getProperty(IUiOptions.UiOption.User.pname());
        byte[] auth_block = (byte[])dp.get((Object)IUiOptions.UiOption.Signature.pname());
        ServiceModifyEvent ev = new ServiceModifyEvent(user, (long)((Integer)id.first()).intValue(), (String)id.second(), auth_block);
        int instances = this.getInstances(-1);
        IService.Trinary autostart = this.getAutostart();
        boolean activate = this.getActivate();
        ev.setInstances(instances);
        ev.setAutostart(autostart);
        ev.setActivate(activate);
        try {
            IServiceReply iServiceReply = (IServiceReply)this.dispatcher.dispatchAndWaitForDuccReply((DuccEvent)ev);
            return iServiceReply;
        }
        finally {
            this.dispatcher.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IServiceReply query(String[] args) throws Exception {
        DuccProperties dp = new DuccProperties();
        this.init(this.getClass().getName(), this.query_options, args, null, dp, this.callback, "sm");
        Pair<Integer, String> id = null;
        String sid = this.cli_props.getProperty(IUiOptions.UiOption.Query.pname()).trim();
        id = sid == null || sid.equals("") ? new Pair<Integer, String>((Object)-1, null) : this.getId(IUiOptions.UiOption.Query);
        String user = dp.getProperty(IUiOptions.UiOption.User.pname());
        byte[] auth_block = (byte[])dp.get((Object)IUiOptions.UiOption.Signature.pname());
        ServiceQueryEvent ev = new ServiceQueryEvent(user, (long)((Integer)id.first()).intValue(), (String)id.second(), auth_block);
        try {
            IServiceReply iServiceReply = (IServiceReply)this.dispatcher.dispatchAndWaitForDuccReply((DuccEvent)ev);
            return iServiceReply;
        }
        finally {
            this.dispatcher.close();
        }
    }

    void help() {
        HelpFormatter formatter = new HelpFormatter();
        formatter.setWidth(120);
        System.out.println("------------- Register Options ------------------");
        Options options = DuccServiceApi.makeOptions(this.registration_options);
        formatter.printHelp(this.getClass().getName(), options);
        System.out.println("\n\n------------- Unregister Options ------------------");
        options = DuccServiceApi.makeOptions(this.unregister_options);
        formatter.printHelp(this.getClass().getName(), options);
        System.out.println("\n\n------------- Start Options ------------------");
        options = DuccServiceApi.makeOptions(this.start_options);
        formatter.printHelp(this.getClass().getName(), options);
        System.out.println("\n\n------------- Stop Options ------------------");
        options = DuccServiceApi.makeOptions(this.stop_options);
        formatter.printHelp(this.getClass().getName(), options);
        System.out.println("\n\n------------- Modify Options ------------------");
        options = DuccServiceApi.makeOptions(this.modify_options);
        formatter.printHelp(this.getClass().getName(), options);
        System.out.println("\n\n------------- Query Options ------------------");
        options = DuccServiceApi.makeOptions(this.query_options);
        formatter.printHelp(this.getClass().getName(), options);
        System.exit(1);
    }

    @Override
    public boolean execute() {
        return false;
    }

    static boolean format_reply(IUiOptions.UiOption verb, IServiceReply reply) {
        String ep = reply.getEndpoint() != null ? reply.getEndpoint() : "";
        String id = reply.getId() != -1L ? " ID[" + String.valueOf(reply.getId()) + "]" : "";
        String result = reply.getReturnCode() ? " succeeded - " : " failed - ";
        String msg = "Service " + (Object)((Object)verb) + result + reply.getMessage() + " - " + ep + id;
        switch (verb) {
            case Register: 
            case Unregister: 
            case Start: 
            case Stop: 
            case Modify: {
                System.out.println(msg);
                break;
            }
            case Query: {
                if (reply.getReturnCode()) {
                    System.out.println(reply.toString());
                    break;
                }
                System.out.println(msg);
            }
        }
        return reply.getReturnCode();
    }

    static boolean Register(String[] args) throws Exception {
        DuccServiceApi api = new DuccServiceApi(null);
        IServiceReply reply = api.register(args);
        return DuccServiceApi.format_reply(IUiOptions.UiOption.Register, reply);
    }

    static boolean Unregister(String[] args) throws Exception {
        DuccServiceApi api = new DuccServiceApi(null);
        IServiceReply reply = api.unregister(args);
        return DuccServiceApi.format_reply(IUiOptions.UiOption.Unregister, reply);
    }

    static boolean Start(String[] args) throws Exception {
        DuccServiceApi api = new DuccServiceApi(null);
        IServiceReply reply = api.start(args);
        return DuccServiceApi.format_reply(IUiOptions.UiOption.Start, reply);
    }

    static boolean Stop(String[] args) throws Exception {
        DuccServiceApi api = new DuccServiceApi(null);
        IServiceReply reply = api.stop(args);
        return DuccServiceApi.format_reply(IUiOptions.UiOption.Stop, reply);
    }

    static boolean Modify(String[] args) throws Exception {
        DuccServiceApi api = new DuccServiceApi(null);
        IServiceReply reply = api.modify(args);
        return DuccServiceApi.format_reply(IUiOptions.UiOption.Modify, reply);
    }

    static boolean Query(String[] args) throws Exception {
        DuccServiceApi api = new DuccServiceApi(null);
        IServiceReply reply = api.query(args);
        return DuccServiceApi.format_reply(IUiOptions.UiOption.Query, reply);
    }

    static void Help() {
        DuccServiceApi api = new DuccServiceApi(null);
        api.help();
        System.exit(1);
    }

    static IUiOptions.UiOption getVerb(String[] args) {
        IUiOptions.UiOption[] verbs = new IUiOptions.UiOption[]{IUiOptions.UiOption.Register, IUiOptions.UiOption.Modify, IUiOptions.UiOption.Start, IUiOptions.UiOption.Stop, IUiOptions.UiOption.Query, IUiOptions.UiOption.Unregister};
        ArrayList<IUiOptions.UiOption> check = new ArrayList<IUiOptions.UiOption>();
        IUiOptions.UiOption reply = IUiOptions.UiOption.Help;
        for (String s : args) {
            if (!s.startsWith("--")) continue;
            if ((s = s.substring(2)).equals("help")) {
                DuccServiceApi.Help();
            }
            for (IUiOptions.UiOption v : verbs) {
                if (!s.equals(v.pname())) continue;
                reply = v;
                check.add(v);
            }
        }
        if (check.size() > 1) {
            String msg = "";
            for (IUiOptions.UiOption o : check) {
                msg = msg + " " + (Object)((Object)o);
            }
            throw new IllegalArgumentException("Duplicate service actions: " + msg);
        }
        return reply;
    }

    public static void main(String[] args) {
        boolean rc = false;
        try {
            switch (DuccServiceApi.getVerb(args)) {
                case Register: {
                    rc = DuccServiceApi.Register(args);
                    break;
                }
                case Unregister: {
                    rc = DuccServiceApi.Unregister(args);
                    break;
                }
                case Start: {
                    rc = DuccServiceApi.Start(args);
                    break;
                }
                case Stop: {
                    rc = DuccServiceApi.Stop(args);
                    break;
                }
                case Modify: {
                    rc = DuccServiceApi.Modify(args);
                    break;
                }
                case Query: {
                    rc = DuccServiceApi.Query(args);
                    break;
                }
                default: {
                    System.out.println("Missing service action (register, unregister, start, stop, modify, or query)");
                    System.exit(1);
                    break;
                }
            }
        }
        catch (Exception e) {
            System.out.println("Service call failed: " + e);
            for (String arg : args) {
                if (!arg.equals("--debug")) continue;
                e.printStackTrace();
                break;
            }
            System.exit(1);
        }
        System.exit(rc ? 0 : 1);
    }
}

