/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.agent.metrics.collectors;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.uima.ducc.agent.Agent;
import org.apache.uima.ducc.agent.metrics.collectors.CallableNodeUsersCollector;
import org.apache.uima.ducc.common.node.metrics.NodeUsersInfo;
import org.apache.uima.ducc.common.utils.DuccLogger;
import org.apache.uima.ducc.common.utils.Utils;

public class NodeUsersCollector
implements CallableNodeUsersCollector {
    DuccLogger logger;
    Agent agent;
    int uidMax = 500;
    static String ducc_user = System.getProperty("user.name");

    public NodeUsersCollector(Agent agent, DuccLogger logger) {
        this.agent = agent;
        this.logger = logger;
        this.uidMax = Utils.getMaxSystemUserId();
    }

    public boolean excludeUser(String userId) {
        String userFilter = System.getProperty("ducc.agent.rogue.process.user.exclusion.filter");
        if (userFilter != null) {
            String[] excludedUsers;
            for (String excludedUser : excludedUsers = userFilter.split(",")) {
                if (!excludedUser.equals(userId)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean excludeProcess(String process) {
        String processFilter = System.getProperty("ducc.agent.rogue.process.exclusion.filter");
        if (processFilter != null) {
            String[] excludedProcesses;
            for (String excludedProcess : excludedProcesses = processFilter.split(",")) {
                if (!excludedProcess.equals(process)) continue;
                return true;
            }
        }
        return false;
    }

    private void aggregate(Set<ProcessInfo> processList, ProcessInfo cpi) {
        boolean added = false;
        for (ProcessInfo pi : processList) {
            if (pi.getPid() == cpi.getPPid()) {
                pi.getChildren().add(cpi);
                added = true;
                if (pi.isRogue()) {
                    cpi.setRogue(true);
                    break;
                }
            } else if (pi.getChildren().size() > 0) {
                for (ProcessInfo childpi : pi.getChildren()) {
                    if (childpi.getPid() != cpi.getPPid()) continue;
                    added = true;
                    if (!childpi.isRogue()) break;
                    cpi.setRogue(true);
                    break;
                }
            }
            if (!added) continue;
            pi.getChildren().add(cpi);
            if (this.logger == null) break;
            this.logger.info("aggregate", null, new Object[]{"********* Adding Child Process With PID:" + cpi.getPid() + " As Child of Process:" + cpi.getPPid()});
            break;
        }
        if (!added) {
            processList.add(cpi);
            if (this.logger != null) {
                this.logger.info("aggregate", null, new Object[]{"********* Adding Process With PID:" + cpi.getPid() + " NO PARENT"});
            }
        }
    }

    private boolean duccDaemon(String[] tokens) {
        String location = "duccDaemon";
        for (String token : tokens) {
            if (token.startsWith("-Dducc.deploy.components")) {
                String component;
                int pos = token.indexOf("=");
                if (pos > -1 && (component = token.substring(pos + 1)).trim().startsWith("uima-as")) break;
                if (this.logger != null) {
                    this.logger.trace(location, null, new Object[]{"********** Process with PID:" + tokens[1] + " Is a Ducc Daemon:" + token + ". Skipping...."});
                }
                return true;
            }
            if (!token.startsWith("-Dactivemq.base")) continue;
            if (this.logger != null) {
                this.logger.trace(location, null, new Object[]{"********** Process with PID:" + tokens[1] + " Is an ActiveMQ Broker:" + token + ". Skipping...."});
            }
            return true;
        }
        return false;
    }

    private boolean processAncestorIsOwnedByDucc(String ppid, Set<RunningProcess> list) {
        for (RunningProcess pi : list) {
            if (!pi.getPid().equals(ppid)) continue;
            if (pi.getOwner().equalsIgnoreCase(ducc_user)) {
                return true;
            }
            return this.processAncestorIsOwnedByDucc(pi.getPpid(), list);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TreeMap<String, NodeUsersInfo> call() throws Exception {
        String location = "call";
        TreeMap<String, NodeUsersInfo> map = new TreeMap<String, NodeUsersInfo>();
        ArrayList<String> currentPids = new ArrayList<String>();
        InputStream stream = null;
        BufferedReader reader = null;
        try {
            String line;
            ProcessBuilder pb = Utils.isMac() ? new ProcessBuilder("ps", "-Ao", "user=,pid=,ppid=,uid=,args=") : new ProcessBuilder("ps", "-Ao", "user:32,pid,ppid,uid,args", "--no-heading");
            pb.redirectErrorStream(true);
            Process proc = pb.start();
            stream = proc.getInputStream();
            reader = new BufferedReader(new InputStreamReader(stream));
            String regex = "\\s+";
            if (this.agent != null) {
                this.agent.copyAllUserReservations(map);
            }
            if (this.logger != null) {
                this.logger.debug(location, null, new Object[]{"********** User Process Map Size After copyAllUserReservations:" + map.size()});
            }
            if (this.agent != null) {
                this.agent.getRogueProcessReaper().copyAllUserRogueProcesses(map);
            }
            if (this.logger != null) {
                this.logger.debug(location, null, new Object[]{"********** User Process Map Size After copyAllUserRougeProcesses:" + map.size()});
            }
            HashSet<ProcessInfo> processList = new HashSet<ProcessInfo>();
            HashSet<RunningProcess> tempProcessList = new HashSet<RunningProcess>();
            ArrayList<String> procList = new ArrayList<String>();
            while ((line = reader.readLine()) != null) {
                procList.add(line);
                String[] tokens = line.split(regex);
                if (tokens.length <= 0) continue;
                RunningProcess p = new RunningProcess(tokens[1], tokens[2], tokens[0]);
                tempProcessList.add(p);
            }
            for (String procInfo : procList) {
                String[] tokens = procInfo.split(regex);
                String user = tokens[0];
                String pid = tokens[1];
                String ppid = tokens[2];
                String uid = tokens[3];
                String cmd = tokens[4];
                if (tokens.length <= 0) continue;
                try {
                    if (Integer.valueOf(uid) < this.uidMax) {
                        continue;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                if (this.processAncestorIsOwnedByDucc(pid, tempProcessList) || ducc_user.equalsIgnoreCase(user)) continue;
                if (this.logger != null) {
                    this.logger.trace(location, null, new Object[]{line});
                }
                if (this.excludeUser(user) || this.excludeProcess(cmd) || Utils.getPID().equals(pid) || this.agent == null) continue;
                NodeUsersInfo nui = null;
                if (map.containsKey(user)) {
                    nui = map.get(user);
                } else {
                    nui = new NodeUsersInfo(user);
                    map.put(user, nui);
                }
                if (this.logger != null) {
                    this.logger.info(location, null, new Object[]{"User:" + user + " Reservations:" + nui.getReservations().size() + " Rogue Processes:" + nui.getRogueProcesses().size()});
                }
                currentPids.add(pid);
                if (this.logger != null) {
                    this.logger.trace(location, null, new Object[]{"Current Promuscess (Before Calling aggregate() - PID:" + pid + " PPID:" + ppid + " Process List Size:" + processList.size()});
                }
                ProcessInfo pi = new ProcessInfo(Integer.parseInt(pid), Integer.parseInt(ppid));
                this.aggregate(processList, pi);
                List userReservations = nui.getReservations();
                if (userReservations.size() > 0) {
                    boolean found = false;
                    for (NodeUsersInfo.NodeProcess rogue : nui.getRogueProcesses()) {
                        if (!rogue.getPid().equals(pid)) continue;
                        found = true;
                        break;
                    }
                    if (found || this.agent.isManagedProcess(processList, pi)) continue;
                    nui.addPid(pid, ppid, cmd.endsWith("java"));
                    continue;
                }
                if (!this.agent.isRogueProcess(user, processList, pi)) continue;
                if (nui.getRogueProcesses().size() == 0 || !this.inRogueList(nui.getRogueProcesses(), pid)) {
                    pi.setRogue(true);
                }
                this.agent.getRogueProcessReaper().submitRogueProcessForKill(user, pid, ppid, cmd.endsWith("java"));
            }
        }
        catch (Exception e) {
            if (this.logger == null) {
                e.printStackTrace();
            } else {
                this.logger.error(location, null, (Throwable)e, new Object[0]);
            }
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Exception e) {}
            }
        }
        StringBuffer sb = new StringBuffer();
        if (currentPids.isEmpty()) {
            for (Map.Entry entry : map.entrySet()) {
                ((NodeUsersInfo)entry.getValue()).getReserveProcesses().clear();
                ((NodeUsersInfo)entry.getValue()).getRogueProcesses().clear();
            }
        }
        for (Map.Entry entry : map.entrySet()) {
            sb.append(((NodeUsersInfo)entry.getValue()).toString()).append("\n");
        }
        if (this.logger == null) {
            System.out.println(sb.toString());
            System.out.println("***************************************************************************************");
        } else if (sb.length() > 0) {
            this.logger.info(location, null, new Object[]{sb.toString()});
            this.logger.info(location, null, new Object[]{"******************************************************************************"});
        }
        this.agent.getRogueProcessReaper().removeDeadRogueProcesses(currentPids);
        return map;
    }

    private boolean inRogueList(List<NodeUsersInfo.NodeProcess> rogueProcesses, String pid) {
        for (NodeUsersInfo.NodeProcess rogue : rogueProcesses) {
            if (!rogue.getPid().equals(pid)) continue;
            return true;
        }
        return false;
    }

    public static void main(String[] args) {
    }

    public class RunningProcess {
        String pid;
        String ppid;
        String owner;

        public RunningProcess(String pid, String ppid, String owner) {
            this.pid = pid;
            this.ppid = ppid;
            this.owner = owner;
        }

        public String getPid() {
            return this.pid;
        }

        public String getPpid() {
            return this.ppid;
        }

        public String getOwner() {
            return this.owner;
        }
    }

    public class ProcessInfo {
        private int pid;
        private int ppid;
        boolean rogue;
        Set<ProcessInfo> childProcesses = new HashSet<ProcessInfo>();

        ProcessInfo(int pid, int ppid) {
            this.pid = pid;
            this.ppid = ppid;
        }

        public int getPid() {
            return this.pid;
        }

        public int getPPid() {
            return this.ppid;
        }

        public boolean isRogue() {
            return this.rogue;
        }

        public void setRogue(boolean rogue) {
            this.rogue = rogue;
        }

        public Set<ProcessInfo> getChildren() {
            return this.childProcesses;
        }
    }
}

