/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.agent.deploy.uima;

import java.io.File;
import java.lang.management.ManagementFactory;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.management.InstanceNotFoundException;
import javax.management.JMX;
import javax.management.MBeanServer;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import org.apache.camel.CamelContext;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.uima.aae.UimaASApplicationEvent;
import org.apache.uima.aae.UimaASApplicationExitEvent;
import org.apache.uima.aae.controller.AnalysisEngineController;
import org.apache.uima.adapter.jms.activemq.SpringContainerDeployer;
import org.apache.uima.adapter.jms.service.UIMA_Service;
import org.apache.uima.analysis_engine.AnalysisEngineManagement;
import org.apache.uima.ducc.agent.deploy.AbstractManagedService;
import org.apache.uima.ducc.agent.deploy.ServiceStateNotificationAdapter;
import org.apache.uima.ducc.agent.deploy.uima.UimaAsServiceConfiguration;
import org.apache.uima.ducc.common.main.DuccService;
import org.apache.uima.ducc.common.utils.DuccLogger;
import org.apache.uima.ducc.common.utils.Utils;
import org.apache.uima.ducc.common.utils.XStreamUtils;
import org.apache.uima.ducc.transport.agent.IUimaPipelineAEComponent;
import org.apache.uima.ducc.transport.agent.UimaPipelineAEComponent;
import org.apache.uima.ducc.transport.event.common.DuccUimaDeploymentDescriptor;
import org.apache.uima.ducc.transport.event.common.IProcessState;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;

public class ManagedUimaService
extends AbstractManagedService
implements ApplicationListener<ApplicationEvent> {
    private SpringContainerDeployer serviceDeployer;
    private String saxonJarPath;
    private String dd2SpringXslPath;
    private String processJmxUrl = null;
    protected static DuccLogger logger;
    private String agentStateUpdateEndpoint = "";
    private UimaAsServiceConfiguration configFactory;

    public static void main(String[] args) {
        try {
            ManagedUimaService ms = new ManagedUimaService("${DUCC_HOME}/lib/saxon8/saxon8.jar", "${DUCC_HOME}/bin/dd2spring.xsl", null, (CamelContext)new DefaultCamelContext());
            ms.deploy(new String[]{XStreamUtils.marshall((Object)new DuccUimaDeploymentDescriptor(args[0]))});
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public ManagedUimaService(String saxonJarPath, String dd2SpringXslPath, ServiceStateNotificationAdapter serviceAdapter, CamelContext context) {
        super(serviceAdapter, context);
        this.saxonJarPath = saxonJarPath;
        this.dd2SpringXslPath = dd2SpringXslPath;
    }

    public DuccLogger getLogger() {
        return new DuccLogger(DuccService.class);
    }

    @Override
    public void onServiceStateChange(IProcessState.ProcessState state) {
        super.notifyAgentWithStatus(state);
    }

    public void setConfigFactory(UimaAsServiceConfiguration configFactory) {
        this.configFactory = configFactory;
    }

    public void setAgentStateUpdateEndpoint(String agentUpdateEndpoint) {
        this.agentStateUpdateEndpoint = agentUpdateEndpoint;
    }

    @Override
    public void quiesceAndStop() {
        try {
            AnalysisEngineController topLevelController;
            if (this.configFactory != null) {
                this.configFactory.stop();
            }
            if (this.serviceDeployer != null && (topLevelController = this.serviceDeployer.getTopLevelController()) != null && !topLevelController.isStopped()) {
                this.serviceDeployer.undeploy(1000);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void terminate() {
        this.currentState = IProcessState.ProcessState.Stopped;
        System.out.println("Service STOPPED");
        try {
            if (this.configFactory != null) {
                this.configFactory.stop();
            }
            super.notifyAgentWithStatus(this.currentState);
            if (this.serviceDeployer != null) {
                this.serviceDeployer.getTopLevelController().stop();
            }
            this.stopIt();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void killService() {
        logger.info("killService", null, new Object[]{"Ducc UIMA Service process received STOP event. Stopping UIMA AS ..."});
        if (this.serviceDeployer != null) {
            this.serviceDeployer.getTopLevelController().stop();
        }
        logger.info("killService", null, new Object[]{"Ducc UIMA Service process stopped UIMA AS and exiting via System.exit()"});
        System.exit(-1);
    }

    @Override
    public void stopService() {
        this.quiesceAndStop();
        this.currentState = IProcessState.ProcessState.Stopped;
        System.exit(0);
    }

    public String[] getServiceArgs(String[] args) throws Exception {
        String ddPath = args[0];
        ddPath = Utils.resolvePlaceholderIfExists((String)ddPath, (Properties)System.getProperties());
        return new String[]{"-saxonURL", Utils.resolvePlaceholderIfExists((String)this.saxonJarPath, (Properties)System.getProperties()), "-xslt", Utils.resolvePlaceholderIfExists((String)this.dd2SpringXslPath, (Properties)System.getProperties()), "-dd", ddPath};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deploy(String[] args) throws Exception {
        this.processJmxUrl = super.getProcessJmxUrl();
        System.out.println("Connect jConsole to this process using JMX URL:" + this.processJmxUrl);
        UIMA_Service service = new UIMA_Service();
        StringBuffer sb = new StringBuffer("Deploying UIMA AS with args:\n");
        for (String arg : args) {
            sb.append(arg + "\n");
        }
        System.out.println(sb.toString());
        String[] serviceArgs = this.getServiceArgs(args);
        sb.setLength(0);
        sb.append("Service Args:\n");
        for (String arg : serviceArgs) {
            sb.append(" " + arg);
        }
        System.out.println(sb.toString());
        System.out.println("ManagedUimaService initializing...");
        String[] contextFiles = service.initialize(serviceArgs);
        if (contextFiles == null) {
            throw new Exception("Spring Context Files Not Generated. Unable to Launch Uima AS Service");
        }
        File generatedFile = new File(contextFiles[0]);
        while (!generatedFile.exists()) {
            File i$ = generatedFile;
            synchronized (i$) {
                generatedFile.wait(500L);
            }
        }
        System.out.println("ManagedUimaService initialized - ready to process. Agent State Update endpoint:" + this.agentStateUpdateEndpoint);
        System.out.println(".... Verified dd2spring generated spring context file:" + contextFiles[0]);
        super.notifyAgentWithStatus(IProcessState.ProcessState.Initializing, this.processJmxUrl);
        ScheduledThreadPoolExecutor executor = new ScheduledThreadPoolExecutor(1);
        executor.prestartAllCoreThreads();
        UimaAEJmxMonitor monitor = new UimaAEJmxMonitor(this, serviceArgs);
        executor.scheduleAtFixedRate(monitor, 20L, 30L, TimeUnit.SECONDS);
        try {
            this.serviceDeployer = service.deploy(contextFiles, (ApplicationListener)this);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        executor.shutdownNow();
        if (this.serviceDeployer == null || this.serviceDeployer.initializationFailed()) {
            this.currentState = IProcessState.ProcessState.FailedInitialization;
            System.out.println(">>> Failed to Deploy UIMA Service. Check UIMA Log for Details");
            super.notifyAgentWithStatus(IProcessState.ProcessState.FailedInitialization);
        } else {
            this.currentState = IProcessState.ProcessState.Running;
            monitor.run();
            super.notifyAgentWithStatus(this.currentState, this.processJmxUrl);
        }
    }

    public void updateAgent(List<IUimaPipelineAEComponent> pipeline) {
        super.notifyAgentWithStatus(pipeline);
    }

    public void onApplicationEvent(ApplicationEvent event) {
        if (event instanceof UimaASApplicationExitEvent) {
            String reason = "ProcessCASFailed";
            if (!((UimaASApplicationExitEvent)event).getEventTrigger().equals((Object)UimaASApplicationEvent.EventTrigger.ExceededErrorThreshold)) {
                reason = "ExceededErrorThreshold";
            }
            this.notifyAgentWithStatus(IProcessState.ProcessState.Stopping, reason);
        }
    }

    public static class UimaAEJmxMonitor
    implements Runnable {
        MBeanServer server = null;
        ManagedUimaService service;
        static int howManySeenSoFar = 1;
        public List<IUimaPipelineAEComponent> aeStateList = new ArrayList<IUimaPipelineAEComponent>();

        public UimaAEJmxMonitor(ManagedUimaService service, String[] serviceArgs) throws Exception {
            this.server = ManagementFactory.getPlatformMBeanServer();
            this.service = service;
        }

        private IUimaPipelineAEComponent getUimaAeByName(String name) {
            for (IUimaPipelineAEComponent aeState : this.aeStateList) {
                if (!aeState.getAeName().equals(name)) continue;
                return aeState;
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                ObjectName uimaServicePattern = new ObjectName("org.apache.uima:type=ee.jms.services,*");
                HashSet<ObjectInstance> mbeans = new HashSet<ObjectInstance>(this.server.queryMBeans(uimaServicePattern, null));
                ArrayList<IUimaPipelineAEComponent> componentsToDelete = new ArrayList<IUimaPipelineAEComponent>();
                boolean updateAgent = false;
                for (ObjectInstance instance : mbeans) {
                    String[] aeObjectNameParts;
                    String targetName = instance.getObjectName().getKeyProperty("name");
                    if (targetName.endsWith("FlowController") || !instance.getClassName().equals("org.apache.uima.analysis_engine.impl.AnalysisEngineManagementImpl") || (aeObjectNameParts = instance.getObjectName().toString().split(",")).length == 3) continue;
                    StringBuffer sb = new StringBuffer();
                    for (String part : aeObjectNameParts) {
                        if (part.startsWith("org.apache.uima:type") || part.startsWith("s=")) continue;
                        sb.append("/");
                        if (part.endsWith("Components")) {
                            part = part.substring(0, part.indexOf("Components")).trim();
                        }
                        sb.append(part.substring(part.indexOf("=") + 1));
                    }
                    AnalysisEngineManagement proxy = JMX.newMBeanProxy(this.server, instance.getObjectName(), AnalysisEngineManagement.class);
                    IUimaPipelineAEComponent aeState = null;
                    aeState = this.getUimaAeByName(sb.toString());
                    if (aeState == null) {
                        if (AnalysisEngineManagement.State.valueOf((String)proxy.getState()).equals((Object)AnalysisEngineManagement.State.Ready)) continue;
                        aeState = new UimaPipelineAEComponent(sb.toString(), proxy.getThreadId(), AnalysisEngineManagement.State.valueOf((String)proxy.getState()));
                        this.aeStateList.add(aeState);
                        ((UimaPipelineAEComponent)aeState).startInitialization = System.currentTimeMillis();
                        aeState.setAeState(AnalysisEngineManagement.State.Initializing);
                        updateAgent = true;
                    } else if (AnalysisEngineManagement.State.valueOf((String)proxy.getState()).equals((Object)AnalysisEngineManagement.State.Initializing)) {
                        updateAgent = true;
                        aeState.setInitializationTime(System.currentTimeMillis() - ((UimaPipelineAEComponent)aeState).startInitialization);
                    } else if (aeState.getAeState().equals((Object)AnalysisEngineManagement.State.Initializing) && AnalysisEngineManagement.State.valueOf((String)proxy.getState()).equals((Object)AnalysisEngineManagement.State.Ready)) {
                        aeState.setAeState(AnalysisEngineManagement.State.Ready);
                        updateAgent = true;
                        UimaAEJmxMonitor uimaAEJmxMonitor = this;
                        synchronized (uimaAEJmxMonitor) {
                            try {
                                this.wait(5L);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                        }
                        aeState.setInitializationTime(proxy.getInitializationTime());
                        componentsToDelete.add(aeState);
                    }
                    DuccService.getDuccLogger((String)this.getClass().getName()).debug("UimaAEJmxMonitor.run()", null, new Object[]{"---- AE Name:" + proxy.getName() + " AE State:" + proxy.getState() + " AE init time=" + aeState.getInitializationTime() + " Proxy Init time=" + proxy.getInitializationTime() + " Proxy Thread ID:" + proxy.getThreadId()});
                }
                howManySeenSoFar = 1;
                if (updateAgent) {
                    DuccService.getDuccLogger((String)this.getClass().getName()).debug("UimaAEJmxMonitor.run()", null, new Object[]{"---- Publishing UimaPipelineAEComponent List - size=" + this.aeStateList.size()});
                    try {
                        this.service.updateAgent(this.aeStateList);
                    }
                    catch (Exception ex) {
                        throw ex;
                    }
                    finally {
                        for (IUimaPipelineAEComponent aeState : componentsToDelete) {
                            this.aeStateList.remove(aeState);
                        }
                    }
                }
            }
            catch (UndeclaredThrowableException e) {
                if (!(e.getCause() instanceof InstanceNotFoundException)) {
                    if (howManySeenSoFar > 3) {
                        DuccService.getDuccLogger((String)this.getClass().getName()).info("UimaAEJmxMonitor.run()", null, (Throwable)e, new Object[0]);
                        howManySeenSoFar = 1;
                        throw e;
                    }
                    ++howManySeenSoFar;
                }
            }
            catch (Throwable e) {
                howManySeenSoFar = 1;
                DuccService.getDuccLogger((String)this.getClass().getName()).info("UimaAEJmxMonitor.run()", null, e, new Object[0]);
            }
        }
    }
}

