/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.agent.processors;

import java.io.RandomAccessFile;
import java.util.TreeMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.camel.Exchange;
import org.apache.uima.ducc.agent.NodeAgent;
import org.apache.uima.ducc.agent.metrics.collectors.NodeCpuCollector;
import org.apache.uima.ducc.agent.metrics.collectors.NodeLoadAverageCollector;
import org.apache.uima.ducc.agent.metrics.collectors.NodeMemInfoCollector;
import org.apache.uima.ducc.agent.metrics.collectors.NodeUsersCollector;
import org.apache.uima.ducc.agent.processors.BaseProcessor;
import org.apache.uima.ducc.agent.processors.NodeMetricsProcessor;
import org.apache.uima.ducc.common.DuccNode;
import org.apache.uima.ducc.common.Node;
import org.apache.uima.ducc.common.agent.metrics.memory.NodeMemory;
import org.apache.uima.ducc.common.node.metrics.NodeCpuInfo;
import org.apache.uima.ducc.common.node.metrics.NodeLoadAverage;
import org.apache.uima.ducc.common.node.metrics.NodeMetrics;
import org.apache.uima.ducc.common.node.metrics.NodeUsersInfo;
import org.apache.uima.ducc.common.utils.DuccLogger;
import org.apache.uima.ducc.transport.event.NodeMetricsUpdateDuccEvent;

public class LinuxNodeMetricsProcessor
extends BaseProcessor
implements NodeMetricsProcessor {
    DuccLogger logger = DuccLogger.getLogger(this.getClass(), (String)"Agent");
    public static String[] MeminfoTargetFields = new String[]{"MemTotal:", "MemFree:", "SwapTotal:", "SwapFree:"};
    private NodeAgent agent;
    private String osname;
    private String osversion;
    private String osarch;
    private final ExecutorService pool = Executors.newCachedThreadPool();
    private RandomAccessFile memInfoFile;
    private RandomAccessFile loadAvgFile;
    private int swapThreshold = 0;

    public LinuxNodeMetricsProcessor() {
        this.osname = System.getProperty("os.name");
        this.osversion = System.getProperty("os.version");
        this.osarch = System.getProperty("os.arch");
        if (System.getProperty("ducc.node.min.swap.threshold") != null) {
            try {
                this.swapThreshold = Integer.valueOf(System.getProperty("ducc.node.min.swap.threshold"));
                this.logger.info("ctor", null, new Object[]{"Ducc Node Min Swap Threshold:" + this.swapThreshold});
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public void setAgent(NodeAgent agent) {
        this.agent = agent;
    }

    public void initMemInfo(String memInfoFilePath) throws Exception {
        this.memInfoFile = new RandomAccessFile(memInfoFilePath, "r");
    }

    public void initLoadAvg(String loadAvgFilePath) throws Exception {
        this.loadAvgFile = new RandomAccessFile(loadAvgFilePath, "r");
    }

    @Override
    public void stop() {
        try {
            if (this.memInfoFile != null) {
                this.memInfoFile.close();
            }
            if (this.loadAvgFile != null) {
                this.loadAvgFile.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void process(Exchange e) {
        String methodName = "process";
        try {
            if (NodeAgent.logCounter.incrementAndGet() % 10L == 0L) {
                if (this.agent.useCgroups) {
                    this.logger.info(methodName, null, new Object[]{"\t****\n\t**** Agent CGroups status: enabled"});
                } else {
                    this.logger.info(methodName, null, new Object[]{"\t****\n\t**** Agent CGroups status: disabled. Reason:" + NodeAgent.cgroupFailureReason});
                }
            }
            NodeMemInfoCollector memCollector = new NodeMemInfoCollector(MeminfoTargetFields);
            Future<NodeMemory> nmiFuture = this.pool.submit(memCollector);
            NodeLoadAverageCollector loadAvgCollector = new NodeLoadAverageCollector();
            Future<NodeLoadAverage> loadFuture = this.pool.submit(loadAvgCollector);
            NodeCpuCollector cpuCollector = new NodeCpuCollector();
            NodeCpuInfo cpuInfo = new NodeCpuInfo(this.agent.numProcessors, String.valueOf(cpuCollector.call()));
            e.getIn().setHeader("node", (Object)this.agent.getIdentity().getName());
            NodeMemory memInfo = nmiFuture.get();
            TreeMap<Object, Object> users = null;
            if (this.agent.receivedDuccState) {
                NodeUsersCollector nodeUsersCollector = new NodeUsersCollector(this.agent, this.logger);
                this.logger.info(methodName, null, new Object[]{"... Agent Collecting User Processes"});
                Future<TreeMap<String, NodeUsersInfo>> nuiFuture = this.pool.submit(nodeUsersCollector);
                users = nuiFuture.get();
            } else {
                users = new TreeMap();
            }
            NodeLoadAverage lav = loadFuture.get();
            NodeMetrics nodeMetrics = new NodeMetrics(this.agent.getIdentity(), memInfo, lav, cpuInfo, users);
            DuccNode node = new DuccNode(this.agent.getIdentity(), nodeMetrics, this.agent.useCgroups);
            if (this.agent.getNodeInfo() == null) {
                this.agent.setNodeInfo((Node)node);
            }
            node.duccLingExists(this.agent.duccLingExists());
            node.runWithDuccLing(this.agent.runWithDuccLing());
            this.logger.info(methodName, null, new Object[]{"... Agent " + node.getNodeIdentity().getName() + " OS Name:" + this.osname + " OS Version:" + this.osversion + " OS Arch:" + this.osarch + " CPU Count:" + cpuInfo.getAvailableProcessors() + " CPU Load Average:" + lav.getLoadAvg1() + " Posting Memory (KB):" + node.getNodeMetrics().getNodeMemory().getMemTotal() + " Memory Free (KB):" + node.getNodeMetrics().getNodeMemory().getMemFree() + " Swap Total (KB):" + node.getNodeMetrics().getNodeMemory().getSwapTotal() + " Swap Free (KB):" + node.getNodeMetrics().getNodeMemory().getSwapFree() + " Low Swap Threshold Defined in ducc.properties (KB):" + this.swapThreshold});
            this.logger.trace(methodName, null, new Object[]{"... Agent " + node.getNodeIdentity().getName() + " Posting Users:" + node.getNodeMetrics().getNodeUsersMap().size()});
            if (this.swapThreshold > 0 && node.getNodeMetrics().getNodeMemory().getSwapFree() < (long)this.swapThreshold) {
                this.agent.killProcessDueToLowSwapSpace(this.swapThreshold);
            }
            NodeMetricsUpdateDuccEvent updateEvent = new NodeMetricsUpdateDuccEvent((Node)node, this.agent.getInventoryRef().size());
            e.getIn().setBody((Object)updateEvent, NodeMetricsUpdateDuccEvent.class);
        }
        catch (Exception ex) {
            this.logger.error(methodName, null, (Throwable)ex, new Object[]{"Agent"});
        }
    }
}

