/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.agent.metrics.collectors;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.RandomAccessFile;
import java.util.concurrent.Callable;
import org.apache.uima.ducc.agent.metrics.collectors.AbstractMetricCollector;
import org.apache.uima.ducc.common.node.metrics.NodeLoadAverage;
import org.apache.uima.ducc.common.node.metrics.UptimeNodeLoadAverage;

public class NodeLoadAverageCollector
extends AbstractMetricCollector
implements Callable<NodeLoadAverage> {
    public NodeLoadAverageCollector() {
        super(null, 0, 0);
    }

    public NodeLoadAverageCollector(RandomAccessFile metricFile, int howMany, int offset) {
        super(metricFile, howMany, offset);
    }

    @Override
    public NodeLoadAverage call() throws Exception {
        return this.collect();
    }

    private NodeLoadAverage collect() throws Exception {
        String line;
        InputStream stream = null;
        BufferedReader reader = null;
        UptimeNodeLoadAverage uptimeLoadAverage = new UptimeNodeLoadAverage();
        ProcessBuilder pb = new ProcessBuilder("uptime");
        pb.redirectErrorStream(true);
        Process proc = pb.start();
        stream = proc.getInputStream();
        reader = new BufferedReader(new InputStreamReader(stream));
        String regex = "\\s+";
        String filter = "load average:";
        while ((line = reader.readLine()) != null) {
            int pos = 0;
            pos = line.indexOf(filter);
            if (pos <= -1) continue;
            String la = line.substring(pos + filter.length()).replaceAll(regex, "");
            String[] averages = la.split(",");
            uptimeLoadAverage.setLoadAvg1(averages[0]);
            uptimeLoadAverage.setLoadAvg5(averages[1]);
            uptimeLoadAverage.setLoadAvg15(averages[2]);
        }
        proc.waitFor();
        return uptimeLoadAverage;
    }
}

