/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.agent.launcher;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.uima.ducc.agent.NodeAgent;
import org.apache.uima.ducc.agent.launcher.CommandExecutor;
import org.apache.uima.ducc.agent.launcher.ManagedProcess;
import org.apache.uima.ducc.agent.launcher.Process;
import org.apache.uima.ducc.common.container.FlagsHelper;
import org.apache.uima.ducc.common.utils.DuccLogger;
import org.apache.uima.ducc.common.utils.TimeStamp;
import org.apache.uima.ducc.common.utils.Utils;
import org.apache.uima.ducc.common.utils.id.DuccId;
import org.apache.uima.ducc.transport.cmdline.ACommandLine;
import org.apache.uima.ducc.transport.cmdline.ICommandLine;
import org.apache.uima.ducc.transport.cmdline.JavaCommandLine;
import org.apache.uima.ducc.transport.cmdline.NonJavaCommandLine;
import org.apache.uima.ducc.transport.event.DuccEvent;
import org.apache.uima.ducc.transport.event.ProcessStopDuccEvent;
import org.apache.uima.ducc.transport.event.common.IDuccProcess;
import org.apache.uima.ducc.transport.event.common.IDuccProcessType;
import org.apache.uima.ducc.transport.event.common.IProcessState;
import org.apache.uima.ducc.transport.event.common.ITimeWindow;
import org.apache.uima.ducc.transport.event.common.TimeWindow;

public class DuccCommandExecutor
extends CommandExecutor {
    DuccLogger logger = DuccLogger.getLogger(this.getClass(), (String)"Agent");
    private static AtomicInteger nextPort = new AtomicInteger(30000);

    public DuccCommandExecutor(NodeAgent agent, ICommandLine cmdLine, String host, String ip, Process managedProcess) throws Exception {
        super(agent, cmdLine, host, ip, managedProcess);
    }

    public DuccCommandExecutor(ICommandLine cmdLine, String host, String ip, Process managedProcess) throws Exception {
        super(null, cmdLine, host, ip, managedProcess);
    }

    private boolean useDuccSpawn() {
        if (this.managedProcess.isAgentProcess() || Utils.isWindows()) {
            return false;
        }
        String useSpawn = System.getProperty("ducc.agent.launcher.use.ducc_spawn");
        return useSpawn != null && useSpawn.toLowerCase().equals("true");
    }

    private boolean createCGroupContainer(IDuccProcess duccProcess, String containerId, String owner) throws Exception {
        if (this.agent.cgroupsManager.createContainer(containerId, owner, this.useDuccSpawn())) {
            this.logger.info("createCGroupContainer", null, new Object[]{"Calculating CPU shares \nProcess Max Memory=" + duccProcess.getCGroup().getMaxMemoryLimit() + "\nNode Memory Total=" + this.agent.getNodeInfo().getNodeMetrics().getNodeMemory().getMemTotal()});
            long cpuShares = duccProcess.getCGroup().getMaxMemoryLimit() / this.agent.getNodeInfo().getNodeMetrics().getNodeMemory().getMemTotal();
            this.logger.info("createCGroupContainer", null, new Object[]{"\nCalculated Shares=" + cpuShares});
            this.agent.cgroupsManager.setContainerCpuShares(containerId, owner, this.useDuccSpawn(), cpuShares);
            return this.agent.cgroupsManager.setContainerMaxMemoryLimit(containerId, owner, this.useDuccSpawn(), duccProcess.getCGroup().getMaxMemoryLimit());
        }
        return false;
    }

    private String getContainerId() {
        String containerId = ((ManagedProcess)this.managedProcess).getDuccProcess().getProcessType().equals((Object)IDuccProcessType.ProcessType.Service) ? String.valueOf(((ManagedProcess)this.managedProcess).getDuccProcess().getCGroup().getId()) : ((ManagedProcess)this.managedProcess).getWorkDuccId().getFriendly() + "." + ((ManagedProcess)this.managedProcess).getDuccProcess().getCGroup().getId();
        return containerId;
    }

    @Override
    public Process exec(ICommandLine cmdLine, Map<String, String> processEnv) throws Exception {
        String methodName = "exec";
        try {
            String[] cmd = this.getDeployableCommandLine(cmdLine, processEnv);
            if (this.isKillCommand(cmdLine)) {
                this.logger.info(methodName, null, new Object[]{"Killing process"});
                this.stopProcess(cmdLine, cmd);
            } else {
                IDuccProcess duccProcess = ((ManagedProcess)this.managedProcess).getDuccProcess();
                if (!this.agent.virtualAgent) {
                    double percentOfTotal = (double)duccProcess.getCGroup().getMaxMemoryLimit() / (double)(this.agent.getNodeInfo().getNodeMetrics().getNodeMemory().getMemTotal() * 1024L);
                    long adjustedTotalSwapAvailable = this.agent.getNodeInfo().getNodeMetrics().getNodeMemory().getSwapTotal() - 0x100000L;
                    long maxProcessSwapUsage = (long)((double)adjustedTotalSwapAvailable * percentOfTotal) * 1024L;
                    ((ManagedProcess)this.managedProcess).setMaxSwapThreshold(maxProcessSwapUsage);
                    this.logger.info(methodName, null, new Object[]{"---Process DuccId:" + duccProcess.getDuccId() + " CGroup.getMaxMemoryLimit():" + duccProcess.getCGroup().getMaxMemoryLimit() / 1024L / 1024L + " MBs" + " Node Memory Total:" + this.agent.getNodeInfo().getNodeMetrics().getNodeMemory().getMemTotal() / 1024L + " MBs" + " Percentage Of Real Memory:" + percentOfTotal + " Adjusted Total Swap Available On Node:" + adjustedTotalSwapAvailable / 1024L + " MBs" + " Process Entitled To Max:" + maxProcessSwapUsage / 1024L / 1024L + " MBs of Swap"});
                    if (this.agent.useCgroups) {
                        String containerId = this.getContainerId();
                        this.logger.info(methodName, null, new Object[]{"Checking for CGroup Existance with ID:" + containerId});
                        if (!this.agent.cgroupsManager.cgroupExists(this.agent.cgroupsManager.getDuccCGroupBaseDir() + "/" + containerId)) {
                            this.logger.info(methodName, null, new Object[]{"No CGroup with ID:" + containerId + " Found"});
                            boolean failed = false;
                            try {
                                if (this.createCGroupContainer(duccProcess, containerId, ((ManagedProcess)this.managedProcess).getOwner())) {
                                    this.logger.info(methodName, null, new Object[]{"Created CGroup with ID:" + containerId + " With Memory Limit=" + ((ManagedProcess)this.managedProcess).getDuccProcess().getCGroup().getMaxMemoryLimit() + " Bytes"});
                                } else {
                                    this.logger.info(methodName, null, new Object[]{"Failed To Create CGroup with ID:" + containerId});
                                    duccProcess.setProcessState(IProcessState.ProcessState.Failed);
                                    duccProcess.setReasonForStoppingProcess("CGroupCreationFailed");
                                    failed = true;
                                    this.agent.stop();
                                }
                            }
                            catch (Exception e) {
                                this.logger.error(methodName, null, (Throwable)e, new Object[0]);
                                failed = true;
                                this.agent.stop();
                            }
                            if (failed) {
                                throw new RuntimeException("The Agent is Unable To Create A CGroup with Container ID: " + containerId + ". Rejecting Deployment of Process with ID:" + duccProcess.getDuccId());
                            }
                        } else {
                            this.logger.info(methodName, null, new Object[]{"CGroup Exists with ID:" + containerId});
                        }
                        String[] cgroupCmd = new String[cmd.length + 3];
                        cgroupCmd[0] = this.agent.cgroupsManager.getCGroupsUtilsDir() + "/cgexec";
                        cgroupCmd[1] = "-g";
                        cgroupCmd[2] = this.agent.cgroupsManager.getSubsystems() + ":ducc/" + containerId;
                        int inx = 3;
                        for (String cmdPart : cmd) {
                            cgroupCmd[inx++] = cmdPart;
                        }
                        this.startProcess(cmdLine, cgroupCmd, processEnv);
                    } else {
                        this.startProcess(cmdLine, cmd, processEnv);
                    }
                } else {
                    this.startProcess(cmdLine, cmd, processEnv);
                }
            }
            return this.managedProcess;
        }
        catch (Exception e) {
            if (((ManagedProcess)this.managedProcess).getDuccProcess() != null) {
                DuccId duccId = ((ManagedProcess)this.managedProcess).getDuccId();
                this.logger.error(methodName, duccId, ((ManagedProcess)this.managedProcess).getDuccProcess().getDuccId(), (Throwable)e, new Object[0]);
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void stopProcess(ICommandLine cmdLine, String[] cmd) throws Exception {
        String methodName = "stopProcess";
        Future<?> future = ((ManagedProcess)this.managedProcess).getFuture();
        if (future == null) {
            throw new Exception("Future Object not Found. Unable to Stop Process with PID:" + ((ManagedProcess)this.managedProcess).getPid());
        }
        if (((ManagedProcess)this.managedProcess).getDuccProcess().getPID() == null || ((ManagedProcess)this.managedProcess).getDuccProcess().getPID().trim().length() == 0) {
            throw new Exception("Process Stop Command Failed. PID not provided.");
        }
        long maxTimeToWaitForProcessToStop = 60000L;
        if (this.agent.configurationFactory.processStopTimeout != null) {
            maxTimeToWaitForProcessToStop = Long.valueOf(this.agent.configurationFactory.processStopTimeout);
        }
        try {
            block31: {
                if (((ManagedProcess)this.managedProcess).doKill() || ((ManagedProcess)this.managedProcess).getDuccProcess().getProcessType().equals((Object)IDuccProcessType.ProcessType.Service) || ((ManagedProcess)this.managedProcess).getDuccProcess().getProcessType().equals((Object)IDuccProcessType.ProcessType.Pop) || ((ManagedProcess)this.managedProcess).getDuccProcess().getProcessState().equals((Object)IProcessState.ProcessState.Initializing) || ((ManagedProcess)this.managedProcess).getDuccProcess().getProcessState().equals((Object)IProcessState.ProcessState.Starting) || ((ManagedProcess)this.managedProcess).getDuccProcess().getProcessState().equals((Object)IProcessState.ProcessState.FailedInitialization)) {
                    this.logger.info(methodName, ((ManagedProcess)this.managedProcess).getDuccId(), new Object[]{">>>>>>>>>>>>>>> Killing Process:" + ((ManagedProcess)this.managedProcess).getPid()});
                    if (((ManagedProcess)this.managedProcess).getDuccProcess().getProcessType().equals((Object)IDuccProcessType.ProcessType.Service) || ((ManagedProcess)this.managedProcess).getDuccProcess().getProcessType().equals((Object)IDuccProcessType.ProcessType.Pop)) {
                        NonJavaCommandLine cmdL;
                        if (Utils.isWindows()) {
                            cmdL = new NonJavaCommandLine("taskkill");
                            cmdL.addArgument("/PID");
                        } else {
                            cmdL = new NonJavaCommandLine("/bin/kill");
                            cmdL.addArgument("-15");
                        }
                        cmdL.addArgument(((ManagedProcess)this.managedProcess).getDuccProcess().getPID());
                        String[] sigTermCmdLine = this.getDeployableCommandLine((ICommandLine)cmdL, new HashMap<String, String>());
                        this.doExec(new ProcessBuilder(sigTermCmdLine), sigTermCmdLine, true);
                        try {
                            this.logger.info(methodName, ((ManagedProcess)this.managedProcess).getDuccId(), new Object[]{"------------ Agent Starting Timer For Process with PID:" + ((ManagedProcess)this.managedProcess).getDuccProcess().getPID() + " Process State: " + ((ManagedProcess)this.managedProcess).getDuccProcess().getProcessState()});
                            future.get(maxTimeToWaitForProcessToStop, TimeUnit.MILLISECONDS);
                            return;
                        }
                        catch (TimeoutException te) {
                            if (!((ManagedProcess)this.managedProcess).getDuccProcess().getProcessState().equals((Object)IProcessState.ProcessState.Running)) return;
                            this.logger.info(methodName, ((ManagedProcess)this.managedProcess).getDuccId(), new Object[]{"------------ Agent Timed-out Waiting for Process with PID:" + ((ManagedProcess)this.managedProcess).getDuccProcess().getPID() + " to Stop. Process State:" + ((ManagedProcess)this.managedProcess).getDuccProcess().getProcessState() + " .Process did not stop in allotted time of " + maxTimeToWaitForProcessToStop + " millis"});
                            this.logger.info(methodName, ((ManagedProcess)this.managedProcess).getDuccId(), new Object[]{">>>>>>>>>>>>>>> Killing Process:" + ((ManagedProcess)this.managedProcess).getDuccProcess().getPID() + " .Process State:" + ((ManagedProcess)this.managedProcess).getDuccProcess().getProcessState()});
                            this.doExec(new ProcessBuilder(cmd), cmd, true);
                        }
                        return;
                    } else {
                        this.doExec(new ProcessBuilder(cmd), cmd, true);
                    }
                    return;
                }
                HashMap<String, String> msgHeader = new HashMap<String, String>();
                msgHeader.put("processPID", ((ManagedProcess)this.managedProcess).getPid());
                msgHeader.put("nodeip", ((ManagedProcess)this.managedProcess).getDuccProcess().getNodeIdentity().getIp());
                this.logger.info(methodName, ((ManagedProcess)this.managedProcess).getDuccId(), new Object[]{"Agent Sending Stop request to remote process with PID:" + ((ManagedProcess)this.managedProcess).getPid() + " On Node:" + ((ManagedProcess)this.managedProcess).getDuccProcess().getNodeIdentity().getIp()});
                if (((ManagedProcess)this.managedProcess).getSocketEndpoint() != null) {
                    this.logger.info(methodName, null, new Object[]{"Agent Sending <<STOP>> to Endpoint:" + ((ManagedProcess)this.managedProcess).getSocketEndpoint()});
                    this.agent.getEventDispatcherForRemoteProcess().dispatch((DuccEvent)new ProcessStopDuccEvent(new HashMap()), ((ManagedProcess)this.managedProcess).getSocketEndpoint(), msgHeader);
                    break block31;
                }
                this.agent.getEventDispatcherForRemoteProcess().dispatch((DuccEvent)new ProcessStopDuccEvent(new HashMap()), msgHeader);
            }
            this.logger.info(methodName, ((ManagedProcess)this.managedProcess).getDuccId(), new Object[]{"------------ Agent Dispatched STOP Request to Process with PID:" + ((ManagedProcess)this.managedProcess).getDuccProcess().getPID() + " Process State: " + ((ManagedProcess)this.managedProcess).getDuccProcess().getProcessState() + " Waiting for Process to Stop. Timout Value:" + maxTimeToWaitForProcessToStop + " millis"});
            try {
                if (((ManagedProcess)this.managedProcess).getDuccProcess().getProcessState().equals((Object)IProcessState.ProcessState.Running)) {
                    this.logger.info(methodName, ((ManagedProcess)this.managedProcess).getDuccId(), new Object[]{"------------ Agent Starting Timer For Process with PID:" + ((ManagedProcess)this.managedProcess).getDuccProcess().getPID() + " Process State: " + ((ManagedProcess)this.managedProcess).getDuccProcess().getProcessState()});
                    future.get(maxTimeToWaitForProcessToStop, TimeUnit.MILLISECONDS);
                    return;
                }
                this.logger.info(methodName, ((ManagedProcess)this.managedProcess).getDuccId(), new Object[]{"------------ Agent Dispatched STOP Request to Process with PID:" + ((ManagedProcess)this.managedProcess).getDuccProcess().getPID() + " Process State: " + ((ManagedProcess)this.managedProcess).getDuccProcess().getProcessState() + " .Process Not In Running State"});
                return;
            }
            catch (TimeoutException tex) {
                if (((ManagedProcess)this.managedProcess).getDuccProcess().getProcessState().equals((Object)IProcessState.ProcessState.Running) || ((ManagedProcess)this.managedProcess).getDuccProcess().getProcessState().equals((Object)IProcessState.ProcessState.Stopping)) {
                    this.logger.info(methodName, ((ManagedProcess)this.managedProcess).getDuccId(), new Object[]{"------------ Agent Timed-out Waiting for Process with PID:" + ((ManagedProcess)this.managedProcess).getDuccProcess().getPID() + " to Stop. Process State:" + ((ManagedProcess)this.managedProcess).getDuccProcess().getProcessState() + " .Process did not stop in allotted time of " + maxTimeToWaitForProcessToStop + " millis"});
                    this.logger.info(methodName, ((ManagedProcess)this.managedProcess).getDuccId(), new Object[]{">>>>>>>>>>>>>>> Killing Process:" + ((ManagedProcess)this.managedProcess).getDuccProcess().getPID() + " .Process State:" + ((ManagedProcess)this.managedProcess).getDuccProcess().getProcessState()});
                    this.doExec(new ProcessBuilder(cmd), cmd, true);
                    return;
                }
                this.logger.info(methodName, ((ManagedProcess)this.managedProcess).getDuccId(), new Object[]{"------------ Agent Timed-out Waiting for Process with PID:" + ((ManagedProcess)this.managedProcess).getDuccProcess().getPID() + " to Stop but the process is not in a running state. Process State:" + ((ManagedProcess)this.managedProcess).getDuccProcess().getProcessState()});
            }
            return;
            catch (Exception ex) {
                try {
                    this.logger.error(methodName, ((ManagedProcess)this.managedProcess).getDuccId(), (Throwable)ex, new Object[0]);
                }
                catch (Throwable throwable) {
                    this.logger.info(methodName, ((ManagedProcess)this.managedProcess).getDuccId(), new Object[]{"------------ Agent Dispatched STOP Request to Process with PID:" + ((ManagedProcess)this.managedProcess).getDuccProcess().getPID() + " Process State: " + ((ManagedProcess)this.managedProcess).getDuccProcess().getProcessState() + " Waiting for Process to Stop. Timout Value:" + maxTimeToWaitForProcessToStop + " millis"});
                    try {
                        if (((ManagedProcess)this.managedProcess).getDuccProcess().getProcessState().equals((Object)IProcessState.ProcessState.Running)) {
                            this.logger.info(methodName, ((ManagedProcess)this.managedProcess).getDuccId(), new Object[]{"------------ Agent Starting Timer For Process with PID:" + ((ManagedProcess)this.managedProcess).getDuccProcess().getPID() + " Process State: " + ((ManagedProcess)this.managedProcess).getDuccProcess().getProcessState()});
                            future.get(maxTimeToWaitForProcessToStop, TimeUnit.MILLISECONDS);
                            throw throwable;
                        } else {
                            this.logger.info(methodName, ((ManagedProcess)this.managedProcess).getDuccId(), new Object[]{"------------ Agent Dispatched STOP Request to Process with PID:" + ((ManagedProcess)this.managedProcess).getDuccProcess().getPID() + " Process State: " + ((ManagedProcess)this.managedProcess).getDuccProcess().getProcessState() + " .Process Not In Running State"});
                        }
                        throw throwable;
                    }
                    catch (TimeoutException tex) {
                        if (((ManagedProcess)this.managedProcess).getDuccProcess().getProcessState().equals((Object)IProcessState.ProcessState.Running) || ((ManagedProcess)this.managedProcess).getDuccProcess().getProcessState().equals((Object)IProcessState.ProcessState.Stopping)) {
                            this.logger.info(methodName, ((ManagedProcess)this.managedProcess).getDuccId(), new Object[]{"------------ Agent Timed-out Waiting for Process with PID:" + ((ManagedProcess)this.managedProcess).getDuccProcess().getPID() + " to Stop. Process State:" + ((ManagedProcess)this.managedProcess).getDuccProcess().getProcessState() + " .Process did not stop in allotted time of " + maxTimeToWaitForProcessToStop + " millis"});
                            this.logger.info(methodName, ((ManagedProcess)this.managedProcess).getDuccId(), new Object[]{">>>>>>>>>>>>>>> Killing Process:" + ((ManagedProcess)this.managedProcess).getDuccProcess().getPID() + " .Process State:" + ((ManagedProcess)this.managedProcess).getDuccProcess().getProcessState()});
                            this.doExec(new ProcessBuilder(cmd), cmd, true);
                            throw throwable;
                        }
                        this.logger.info(methodName, ((ManagedProcess)this.managedProcess).getDuccId(), new Object[]{"------------ Agent Timed-out Waiting for Process with PID:" + ((ManagedProcess)this.managedProcess).getDuccProcess().getPID() + " to Stop but the process is not in a running state. Process State:" + ((ManagedProcess)this.managedProcess).getDuccProcess().getProcessState()});
                    }
                    throw throwable;
                }
                this.logger.info(methodName, ((ManagedProcess)this.managedProcess).getDuccId(), new Object[]{"------------ Agent Dispatched STOP Request to Process with PID:" + ((ManagedProcess)this.managedProcess).getDuccProcess().getPID() + " Process State: " + ((ManagedProcess)this.managedProcess).getDuccProcess().getProcessState() + " Waiting for Process to Stop. Timout Value:" + maxTimeToWaitForProcessToStop + " millis"});
                try {
                    if (((ManagedProcess)this.managedProcess).getDuccProcess().getProcessState().equals((Object)IProcessState.ProcessState.Running)) {
                        this.logger.info(methodName, ((ManagedProcess)this.managedProcess).getDuccId(), new Object[]{"------------ Agent Starting Timer For Process with PID:" + ((ManagedProcess)this.managedProcess).getDuccProcess().getPID() + " Process State: " + ((ManagedProcess)this.managedProcess).getDuccProcess().getProcessState()});
                        future.get(maxTimeToWaitForProcessToStop, TimeUnit.MILLISECONDS);
                        return;
                    }
                    this.logger.info(methodName, ((ManagedProcess)this.managedProcess).getDuccId(), new Object[]{"------------ Agent Dispatched STOP Request to Process with PID:" + ((ManagedProcess)this.managedProcess).getDuccProcess().getPID() + " Process State: " + ((ManagedProcess)this.managedProcess).getDuccProcess().getProcessState() + " .Process Not In Running State"});
                    return;
                }
                catch (TimeoutException tex) {
                    if (((ManagedProcess)this.managedProcess).getDuccProcess().getProcessState().equals((Object)IProcessState.ProcessState.Running) || ((ManagedProcess)this.managedProcess).getDuccProcess().getProcessState().equals((Object)IProcessState.ProcessState.Stopping)) {
                        this.logger.info(methodName, ((ManagedProcess)this.managedProcess).getDuccId(), new Object[]{"------------ Agent Timed-out Waiting for Process with PID:" + ((ManagedProcess)this.managedProcess).getDuccProcess().getPID() + " to Stop. Process State:" + ((ManagedProcess)this.managedProcess).getDuccProcess().getProcessState() + " .Process did not stop in allotted time of " + maxTimeToWaitForProcessToStop + " millis"});
                        this.logger.info(methodName, ((ManagedProcess)this.managedProcess).getDuccId(), new Object[]{">>>>>>>>>>>>>>> Killing Process:" + ((ManagedProcess)this.managedProcess).getDuccProcess().getPID() + " .Process State:" + ((ManagedProcess)this.managedProcess).getDuccProcess().getProcessState()});
                        this.doExec(new ProcessBuilder(cmd), cmd, true);
                        return;
                    }
                    this.logger.info(methodName, ((ManagedProcess)this.managedProcess).getDuccId(), new Object[]{"------------ Agent Timed-out Waiting for Process with PID:" + ((ManagedProcess)this.managedProcess).getDuccProcess().getPID() + " to Stop but the process is not in a running state. Process State:" + ((ManagedProcess)this.managedProcess).getDuccProcess().getProcessState()});
                }
                return;
            }
        }
        catch (Exception e) {
            this.logger.error(methodName, ((ManagedProcess)this.managedProcess).getDuccId(), (Throwable)e, new Object[0]);
        }
    }

    private void startProcess(ICommandLine cmdLine, String[] cmd, Map<String, String> processEnv) throws Exception {
        String methodName = "startProcess";
        String millis = TimeStamp.getCurrentMillis();
        ProcessBuilder pb = new ProcessBuilder(cmd);
        if (((ManagedProcess)this.managedProcess).getDuccProcess().getProcessType().equals((Object)IDuccProcessType.ProcessType.Pop) || ((ManagedProcess)this.managedProcess).getDuccProcess().getProcessType().equals((Object)IDuccProcessType.ProcessType.Service)) {
            TimeWindow twi = new TimeWindow();
            ((ManagedProcess)this.managedProcess).getDuccProcess().setTimeWindowInit((ITimeWindow)twi);
            twi.setStart(millis);
            twi.setEnd(millis);
            TimeWindow twr = new TimeWindow();
            ((ManagedProcess)this.managedProcess).getDuccProcess().setTimeWindowRun((ITimeWindow)twr);
            twr.setStart(millis);
        }
        Map<String, String> env = pb.environment();
        env.clear();
        env.putAll(processEnv);
        if (cmdLine instanceof ACommandLine) {
            env.putAll(((ACommandLine)cmdLine).getEnvironment());
        }
        if (this.logger.isTrace()) {
            for (Map.Entry<String, String> entry : env.entrySet()) {
                String message = "key:" + entry.getKey() + " " + "value:" + entry.getValue();
                this.logger.trace(methodName, ((ManagedProcess)this.managedProcess).getDuccId(), new Object[]{message});
            }
        }
        this.doExec(pb, cmd, this.isKillCommand(cmdLine));
    }

    private boolean isAP(ManagedProcess process) {
        return !process.isJd() && process.getDuccProcess().getProcessType().equals((Object)IDuccProcessType.ProcessType.Pop);
    }

    private void doExec(ProcessBuilder pb, String[] cmd, boolean isKillCmd) throws Exception {
        String methodName = "doExec";
        int exitCode = 0;
        try {
            StringBuilder sb = new StringBuilder((this.isKillCommand(this.cmdLine) ? "--->Killing Process " : "---> Launching Process:") + " Using command line:");
            int inx = 0;
            for (String cmdPart : cmd) {
                sb.append("\n\t[").append(inx++).append("]").append(Utils.resolvePlaceholderIfExists((String)cmdPart, (Properties)System.getProperties()));
            }
            this.logger.info(methodName, ((ManagedProcess)this.managedProcess).getDuccId(), new Object[]{sb.toString()});
            java.lang.Process process = pb.start();
            this.postExecStep(process, this.logger, isKillCmd);
            exitCode = process.waitFor();
            if (!this.isKillCommand(this.cmdLine)) {
                this.logger.info(methodName, ((ManagedProcess)this.managedProcess).getDuccId(), new Object[]{">>>>>>>>>>>>> Process with PID:" + ((ManagedProcess)this.managedProcess).getDuccProcess().getPID() + " Terminated. Exit Code:" + exitCode});
                if (this.agent.useCgroups) {
                    String containerId = this.getContainerId();
                    String userId = ((ManagedProcess)this.managedProcess).getOwner();
                    this.agent.cgroupsManager.destroyContainer(containerId, userId, NodeAgent.SIGTERM);
                    this.logger.info(methodName, null, new Object[]{"Removed CGroup Container with ID:" + containerId});
                }
            }
        }
        catch (NullPointerException ex) {
            ((ManagedProcess)this.managedProcess).getDuccProcess().setProcessState(IProcessState.ProcessState.Failed);
            StringBuffer sb = new StringBuffer();
            sb.setLength(0);
            sb.append("\n\tJava ProcessBuilder Failed to Launch Process due to NullPointerException. An Entry in the Command Array Must be Null. Look at Command Array Below:\n");
            for (String cmdPart : cmd) {
                if (cmdPart == null) continue;
                sb.append("\n\t").append(cmdPart);
            }
            this.logger.info(methodName, ((ManagedProcess)this.managedProcess).getDuccId(), new Object[]{sb.toString()});
            ((ManagedProcess)this.managedProcess).getDuccProcess().setProcessState(IProcessState.ProcessState.Failed);
            throw ex;
        }
        catch (Exception ex) {
            ((ManagedProcess)this.managedProcess).getDuccProcess().setProcessState(IProcessState.ProcessState.Failed);
            throw ex;
        }
        finally {
            ((ManagedProcess)this.managedProcess).getDuccProcess().setProcessExitCode(exitCode);
            if (this.isAP((ManagedProcess)this.managedProcess)) {
                ((ManagedProcess)this.managedProcess).getDuccProcess().setProcessState(IProcessState.ProcessState.Stopped);
                if (((ManagedProcess)this.managedProcess).doKill()) {
                    ((ManagedProcess)this.managedProcess).getDuccProcess().setReasonForStoppingProcess(IDuccProcess.ReasonForStoppingProcess.KilledByDucc.toString());
                } else {
                    ((ManagedProcess)this.managedProcess).getDuccProcess().setReasonForStoppingProcess(IDuccProcess.ReasonForStoppingProcess.Other.toString());
                }
            } else if (!(((ManagedProcess)this.managedProcess).getDuccProcess().getProcessState().equals((Object)IProcessState.ProcessState.InitializationTimeout) || ((ManagedProcess)this.managedProcess).getDuccProcess().getProcessState().equals((Object)IProcessState.ProcessState.FailedInitialization) || ((ManagedProcess)this.managedProcess).getDuccProcess().getProcessState().equals((Object)IProcessState.ProcessState.Failed) || ((ManagedProcess)this.managedProcess).getDuccProcess().getProcessState().equals((Object)IProcessState.ProcessState.Killed))) {
                ((ManagedProcess)this.managedProcess).getDuccProcess().setProcessState(IProcessState.ProcessState.Stopped);
            }
        }
    }

    private String[] getDeployableCommandLine(ICommandLine cmdLine, Map<String, String> processEnv) throws Exception {
        String[] cmd = new String[]{};
        try {
            NodeAgent.lock();
            String c_launcher_path = Utils.resolvePlaceholderIfExists((String)System.getProperty("ducc.agent.launcher.ducc_spawn_path"), (Properties)System.getProperties());
            if (this.isKillCommand(cmdLine)) {
                Object[] duccling_nolog = new String[]{c_launcher_path, "-u", ((ManagedProcess)this.managedProcess).getOwner(), "--"};
                cmd = this.useDuccSpawn() ? (String[])Utils.concatAllArrays((Object[])duccling_nolog, (Object[][])new String[][]{{cmdLine.getExecutable()}, cmdLine.getCommandLine()}) : (String[])Utils.concatAllArrays((Object[])new String[]{cmdLine.getExecutable()}, (Object[][])new String[][]{cmdLine.getCommandLine()});
            } else {
                String processType = "-UIMA-";
                block2 : switch (((ManagedProcess)this.managedProcess).getDuccProcess().getProcessType()) {
                    case Pop: {
                        processType = "-POP-";
                        if (!(cmdLine instanceof JavaCommandLine)) break;
                        List options = ((JavaCommandLine)cmdLine).getOptions();
                        for (String option : options) {
                            if (!option.startsWith("-Dducc.deploy.components=")) continue;
                            processType = "-JD-";
                            ((ManagedProcess)this.managedProcess).setIsJD();
                            break block2;
                        }
                        break;
                    }
                    case Service: {
                        break;
                    }
                    case Job_Uima_AS_Process: {
                        processType = "-UIMA-";
                        List options = ((JavaCommandLine)cmdLine).getOptions();
                        boolean isDucc20JpProcess = false;
                        boolean isDucc20ServiceProcess = false;
                        for (String option : options) {
                            if (option.indexOf(FlagsHelper.Name.JpType.pname()) > -1) {
                                isDucc20JpProcess = true;
                            }
                            if (option.indexOf("ducc.deploy.components=service") <= -1) continue;
                            isDucc20ServiceProcess = true;
                        }
                        if (isDucc20JpProcess) {
                            if (!isDucc20ServiceProcess) {
                                ((JavaCommandLine)cmdLine).addOption("-Dducc.deploy.components=job-process");
                            }
                            ((JavaCommandLine)cmdLine).setClassName("org.apache.uima.ducc.user.common.main.DuccJobService");
                            break;
                        }
                        ((JavaCommandLine)cmdLine).addOption("-Dducc.deploy.components=uima-as");
                        ((JavaCommandLine)cmdLine).setClassName("org.apache.uima.ducc.common.main.DuccService");
                    }
                }
                String processLogDir = ((ManagedProcess)this.managedProcess).getProcessInfo().getLogDirectory() + (((ManagedProcess)this.managedProcess).getProcessInfo().getLogDirectory().endsWith(File.separator) ? "" : File.separator) + ((ManagedProcess)this.managedProcess).getWorkDuccId() + File.separator;
                String processLogFile = ((ManagedProcess)this.managedProcess).getWorkDuccId() + processType + this.host;
                String workingDir = ((ManagedProcess)this.managedProcess).getProcessInfo().getWorkingDirectory();
                if (workingDir == null) {
                    workingDir = "NONE";
                }
                Object[] duccling = new String[]{c_launcher_path, "-f", processLogDir + processLogFile, "-w", workingDir, "-u", ((ManagedProcess)this.managedProcess).getOwner(), "--"};
                String executable = cmdLine.getExecutable();
                if (executable == null || executable.trim().length() == 0) {
                    executable = System.getProperty("java.home") + File.separator + "bin" + File.separator + "java";
                }
                ArrayList<String> operationalProperties = new ArrayList<String>();
                if (cmdLine instanceof JavaCommandLine) {
                    String type;
                    String duccHomePath = Utils.findDuccHome();
                    operationalProperties.add("-DDUCC_HOME=" + duccHomePath);
                    operationalProperties.add("-Dducc.deploy.configuration=" + System.getProperty("ducc.deploy.configuration"));
                    if (System.getProperties().containsKey("ducc.agent.managed.process.state.update.endpoint.type") && (type = System.getProperty("ducc.agent.managed.process.state.update.endpoint.type")) != null && type.equalsIgnoreCase("socket")) {
                        operationalProperties.add("-Dducc.agent.process.state.update.port=" + System.getProperty("ducc.agent.process.state.update.port"));
                    }
                    operationalProperties.add("-Dducc.process.log.dir=" + processLogDir);
                    operationalProperties.add("-Dducc.process.log.basename=" + processLogFile);
                    operationalProperties.add("-Dducc.job.id=" + ((ManagedProcess)this.managedProcess).getWorkDuccId());
                }
                String[] operationalPropertiesArray = new String[operationalProperties.size()];
                cmd = this.useDuccSpawn() ? (String[])Utils.concatAllArrays((Object[])duccling, (Object[][])new String[][]{{executable}, operationalProperties.toArray(operationalPropertiesArray), cmdLine.getCommandLine()}) : (String[])Utils.concatAllArrays((Object[])new String[]{executable}, (Object[][])new String[][]{operationalProperties.toArray(operationalPropertiesArray), cmdLine.getCommandLine()});
                processEnv.put("JobId", String.valueOf(((ManagedProcess)this.managedProcess).getWorkDuccId().getFriendly()));
                processEnv.put("DUCC_PROCESS_LOG_PREFIX", processLogDir + processLogFile);
            }
            String[] stringArray = cmd;
            return stringArray;
        }
        catch (Exception ex) {
            ((ManagedProcess)this.managedProcess).getDuccProcess().setProcessState(IProcessState.ProcessState.Failed);
            throw ex;
        }
        finally {
            NodeAgent.unlock();
        }
    }

    @Override
    public void stop() {
    }
}

