/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.agent.launcher;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import org.apache.camel.RoutesBuilder;
import org.apache.uima.ducc.agent.NodeAgent;
import org.apache.uima.ducc.agent.launcher.ManagedProcess;
import org.apache.uima.ducc.agent.launcher.Process;
import org.apache.uima.ducc.common.utils.DuccLogger;
import org.apache.uima.ducc.common.utils.Utils;
import org.apache.uima.ducc.transport.cmdline.ICommandLine;
import org.apache.uima.ducc.transport.event.common.IDuccProcessType;
import org.apache.uima.ducc.transport.event.common.IDuccStandardInfo;
import org.apache.uima.ducc.transport.event.common.IProcessState;

public abstract class CommandExecutor
implements Callable<Process> {
    protected Process managedProcess = null;
    protected String host;
    protected String ip;
    protected ICommandLine cmdLine;
    protected NodeAgent agent;

    public abstract void stop() throws Exception;

    public abstract Process exec(ICommandLine var1, Map<String, String> var2) throws Exception;

    public CommandExecutor(NodeAgent agent, ICommandLine cmdLine, String host, String ip, Process managedProcess) throws Exception {
        this.agent = agent;
        this.host = host;
        this.ip = ip;
        this.managedProcess = managedProcess;
        this.cmdLine = cmdLine;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void postExecStep(java.lang.Process process, DuccLogger logger, boolean isKillCmd) {
        int pid;
        if (!isKillCmd && (pid = Utils.getPID((java.lang.Process)process)) != -1) {
            ((ManagedProcess)this.managedProcess).setPid(String.valueOf(pid));
            if (!((ManagedProcess)this.managedProcess).getDuccProcess().getProcessType().equals((Object)IDuccProcessType.ProcessType.Job_Uima_AS_Process)) {
                if (!((ManagedProcess)this.managedProcess).getDuccProcess().getProcessState().equals((Object)IProcessState.ProcessState.Stopped)) {
                    ((ManagedProcess)this.managedProcess).getDuccProcess().setProcessState(IProcessState.ProcessState.Running);
                }
                try {
                    CommandExecutor commandExecutor = this;
                    synchronized (commandExecutor) {
                        this.wait(5000L);
                    }
                    NodeAgent nodeAgent = this.agent;
                    nodeAgent.getClass();
                    NodeAgent.ProcessMemoryUsageRoute rb = nodeAgent.new NodeAgent.ProcessMemoryUsageRoute(this.agent, ((ManagedProcess)this.managedProcess).getDuccProcess(), (ManagedProcess)this.managedProcess);
                    this.agent.getContext().addRoutes((RoutesBuilder)rb);
                }
                catch (Exception e) {
                    logger.error("postExecStep", null, (Throwable)e, new Object[0]);
                }
            }
        }
        ((ManagedProcess)this.managedProcess).drainProcessStreams(process, logger, System.out, isKillCmd);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Process call() throws Exception {
        Process deployedProcess = null;
        try {
            HashMap<String, String> env = new HashMap<String, String>();
            if (!this.isKillCommand(this.cmdLine)) {
                env.put("IP", this.ip);
                env.put("NodeName", this.host);
                env.put("ProcessDuccId", ((ManagedProcess)this.managedProcess).getDuccId().getUnique());
                env.put("ProcessDuccIdFriendly", ((ManagedProcess)this.managedProcess).getDuccId().getFriendly() + "");
                if (((ManagedProcess)this.managedProcess).getDuccProcess().getProcessType().equals((Object)IDuccProcessType.ProcessType.Job_Uima_AS_Process)) {
                    IDuccStandardInfo processInfo = ((ManagedProcess)this.managedProcess).getProcessInfo();
                    long maxInitTime = 0L;
                    if (processInfo != null) {
                        maxInitTime = processInfo.getProcessInitializationTimeMax();
                    }
                    this.agent.getLogger().info("CommandExecutor.call", ((ManagedProcess)this.managedProcess).getWorkDuccId(), new Object[]{"Starting Process Initialization Monitor with Max Process Initialization Time:" + maxInitTime});
                    ((ManagedProcess)this.managedProcess).startInitializationTimer(maxInitTime);
                }
            }
            deployedProcess = this.exec(this.cmdLine, env);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (((ManagedProcess)this.managedProcess).getDuccProcess().getProcessType().equals((Object)IDuccProcessType.ProcessType.Job_Uima_AS_Process)) {
                ((ManagedProcess)this.managedProcess).stopInitializationTimer();
            }
        }
        return deployedProcess;
    }

    protected boolean isKillCommand(ICommandLine cmdLine) {
        return cmdLine.getExecutable() != null && (cmdLine.getExecutable().startsWith("/bin/kill") || cmdLine.getExecutable().startsWith("taskkill"));
    }
}

