/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.agent;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.uima.ducc.common.node.metrics.NodeUsersInfo;
import org.apache.uima.ducc.common.utils.DuccLogger;

public class RogueProcessReaper {
    private Map<String, RogueProcessEntry> userRogueProcessMap = new TreeMap<String, RogueProcessEntry>();
    private Map<String, Process> processMap = new HashMap<String, Process>();
    private int counterValue = 1;
    private int cleanupCounterValue = 5;
    int maxSecondsBeforeEntryExpires = 120;
    private DuccLogger logger;
    boolean doKillRogueProcess = false;
    private String reaperScript;

    public RogueProcessReaper(DuccLogger logger, int counterValue, int cleanupCounterValue) {
        this.cleanupCounterValue = cleanupCounterValue > 0 ? cleanupCounterValue : counterValue + 5;
        this.reaperScript = System.getProperty("ducc.agent.rogue.process.reaper.script");
        if (System.getProperty("ducc.agent.rogue.process.purge.delay") != null) {
            try {
                this.maxSecondsBeforeEntryExpires = Integer.valueOf(System.getProperty("ducc.agent.rogue.process.purge.delay"));
            }
            catch (Exception e) {
                if (logger == null) {
                    e.printStackTrace();
                } else {
                    logger.error("RogueProcessReaper.ctor", null, (Throwable)e, new Object[0]);
                }
                this.maxSecondsBeforeEntryExpires = 120;
            }
        }
        this.logger = logger;
        if (Boolean.getBoolean("ducc.agent.rogue.process.kill")) {
            this.doKillRogueProcess = true;
        }
        if (logger == null) {
            System.out.println("ducc.agent.rogue.process.kill=" + this.doKillRogueProcess);
        } else {
            logger.info("RogueProcessReaper.ctor", null, new Object[]{"ducc.agent.rogue.process.kill=" + this.doKillRogueProcess});
        }
    }

    public void submitRogueProcessForKill(String user, String pid, String ppid, boolean isJava) {
        String methodName = "RogueProcessReaper.submitRogueProcessForKill";
        RogueProcessEntry entry = null;
        if (this.userRogueProcessMap.containsKey(pid)) {
            entry = this.userRogueProcessMap.get(pid);
        } else {
            if (this.cleanupCounterValue <= this.counterValue) {
                this.cleanupCounterValue += this.counterValue;
            }
            entry = new RogueProcessEntry(this.counterValue, this.cleanupCounterValue, user, this.maxSecondsBeforeEntryExpires, isJava, ppid);
            this.userRogueProcessMap.put(pid, entry);
        }
        entry.markAsRogue(3);
        if (!entry.isRogue()) {
            if (this.logger == null) {
                System.out.println("PID:" + pid + " Not Rogue Yet - It takes 3 iterations to make it Rogue");
            } else {
                this.logger.info("submitRogueProcessForKill", null, new Object[]{"PID:" + pid + " Not Rogue Yet - It takes 3 iterations to make it Rogue"});
            }
            return;
        }
        if (this.reaperScript != null) {
            try {
                long counter;
                if (this.logger != null) {
                    this.logger.info("RogueProcessReaper.submitRogueProcessForKill", null, new Object[]{"Decrementing Counter - Current Value:" + entry.counter.getCount()});
                }
                if ((counter = entry.countDown()) == 0L && !entry.isKilled()) {
                    if (this.logger == null) {
                        System.out.println("Process Scheduled for Kill PID:" + pid + " Owner:" + user + " ");
                    } else {
                        this.logger.info("RogueProcessReaper.submitRogueProcessForKill", null, new Object[]{"Process Scheduled for Kill PID:" + pid + " Owner:" + user + " "});
                    }
                    entry.resetCounter(this.counterValue);
                    this.kill(user, pid);
                    entry.killed();
                } else if (this.logger == null) {
                    System.out.println("Process ***NOT*** Scheduled for Kill PID:" + pid + " Owner:" + user);
                } else {
                    this.logger.info("RogueProcessReaper.submitRogueProcessForKill", null, new Object[]{"Process ***NOT*** Scheduled for Kill PID:" + pid + " Owner:" + user});
                }
                if (entry.isKilled() && entry.countDownCleanupCounter() == 0L) {
                    if (this.logger == null) {
                        System.out.println("Removing Entry From RougeProcessMap for PID:" + pid + " Owner:" + user);
                    } else {
                        this.logger.info("RogueProcessReaper.submitRogueProcessForKill", null, new Object[]{"Removing Entry From RougeProcessMap for PID:" + pid + " Owner:" + user});
                    }
                    this.userRogueProcessMap.remove(pid);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (this.logger == null) {
            System.out.println("Ducc Not Configured to Kill Rogue Proces (PID:)" + pid + " Owner:" + user + ". Change (or define) ducc.agent.rogue.process.reaper.script property in ducc.properties if you want rogue processes to be cleaned up.");
        } else {
            this.logger.info("RogueProcessReaper.submitRogueProcessForKill", null, new Object[]{"Ducc Not Configured to Kill Rogue Proces (PID:)" + pid + " Owner:" + user + ". Change (or define) ducc.agent.rogue.process.reaper.script property in ducc.properties if you want rogue processes to be cleaned up."});
        }
        if (this.logger == null) {
            System.out.println("UserRougeProcessMap size:" + this.userRogueProcessMap.size());
        } else {
            this.logger.info("RogueProcessReaper.submitRogueProcessForKill", null, new Object[]{"UserRougeProcessMap size:" + this.userRogueProcessMap.size()});
        }
    }

    public List<String> getUserRogueProcesses(String user) {
        ArrayList<String> rogues = new ArrayList<String>();
        for (Map.Entry<String, RogueProcessEntry> entry : this.userRogueProcessMap.entrySet()) {
            if (!entry.getValue().getUser().equals(user) || !entry.getValue().isRogue()) continue;
            rogues.add(entry.getKey());
        }
        return rogues;
    }

    public boolean removeRogueProcess(String pid) {
        if (this.userRogueProcessMap.containsKey(pid)) {
            this.userRogueProcessMap.remove(pid);
            return true;
        }
        return false;
    }

    public void removeDeadRogueProcesses(List<String> currentPids) {
        ArrayList<String> deadPIDs = new ArrayList<String>();
        for (Map.Entry<String, RogueProcessEntry> entry : this.userRogueProcessMap.entrySet()) {
            if (currentPids.contains(entry.getKey())) continue;
            deadPIDs.add(entry.getKey());
        }
        for (String deadPID : deadPIDs) {
            this.userRogueProcessMap.remove(deadPID);
        }
    }

    public void copyAllUserRogueProcesses(TreeMap<String, NodeUsersInfo> map) {
        ArrayList entryCleanupList = new ArrayList();
        for (Map.Entry<String, RogueProcessEntry> entry : this.userRogueProcessMap.entrySet()) {
            NodeUsersInfo nui;
            if (!entry.getValue().isRogue()) continue;
            if (map.containsKey(entry.getValue().getUser())) {
                nui = map.get(entry.getValue().getUser());
            } else {
                nui = new NodeUsersInfo(entry.getValue().getUser());
                map.put(entry.getValue().getUser(), nui);
            }
            nui.addRogueProcess(entry.getKey(), entry.getValue().getPpid(), entry.getValue().isJava());
        }
        for (String entryToRemove : entryCleanupList) {
            if (this.logger == null) {
                System.out.println("Removing Expired Entry From RogueProcessMap for PID:" + entryToRemove);
            } else {
                this.logger.info("copyAllUserRogueProcesses", null, new Object[]{"Removing Expired Entry From RogueProcessMap for PID:" + entryToRemove});
            }
            this.userRogueProcessMap.remove(entryToRemove);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void kill(final String user, final String pid) throws Exception {
        String methodName = "RogueProcessReaper.kill.run()";
        try {
            RogueProcessReaper rogueProcessReaper = this;
            synchronized (rogueProcessReaper) {
                Process p;
                if (this.processMap.containsKey(pid) && (p = this.processMap.get(pid)) != null) {
                    p.destroy();
                }
            }
        }
        catch (Exception e) {
            this.logger.error("RogueProcessReaper.kill.run()", null, (Throwable)e, new Object[0]);
        }
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                InputStream is = null;
                BufferedReader reader = null;
                try {
                    Object repearScriptCommand = new String[]{RogueProcessReaper.this.reaperScript, pid};
                    ProcessBuilder pb = new ProcessBuilder((String)repearScriptCommand);
                    pb.redirectErrorStream(true);
                    Process shellProcess = pb.start();
                    1 var6_10 = this;
                    synchronized (var6_10) {
                        RogueProcessReaper.this.processMap.put(pid, shellProcess);
                    }
                    StringBuffer sb = new StringBuffer();
                    for (String part : repearScriptCommand) {
                        sb.append(part).append(" ");
                    }
                    if (RogueProcessReaper.this.logger == null) {
                        System.out.println("--------- Started Rogue Process Reaper Script For Pid:" + pid + " Owned by:" + user + " Command:" + sb.toString());
                    } else {
                        RogueProcessReaper.this.logger.info("RogueProcessReaper.kill.run()", null, new Object[]{"--------- Started Rogue Process Reaper Script For Pid:" + pid + " Owned by:" + user + " Command:" + sb.toString()});
                    }
                    is = shellProcess.getInputStream();
                    reader = new BufferedReader(new InputStreamReader(is));
                    while (reader.readLine() != null) {
                    }
                    sb.setLength(0);
                    if (RogueProcessReaper.this.logger == null) {
                        System.out.println("--------- Rogue Process Reaper (for PID:" + pid + ") Terminated");
                    } else {
                        RogueProcessReaper.this.logger.info("RogueProcessReaper.kill.run()", null, new Object[]{"--------- Rogue Process Reaper (for PID:" + pid + ") Terminated"});
                    }
                }
                catch (Exception e) {
                    RogueProcessReaper.this.logger.error("RogueProcessReaper.kill.run()", null, (Throwable)e, new Object[0]);
                }
                finally {
                    1 e = this;
                    synchronized (e) {
                        RogueProcessReaper.this.processMap.remove(pid);
                    }
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Exception exception) {}
                    }
                }
            }
        }).start();
    }

    public static void main(String[] args) {
    }

    private static class RogueProcessEntry {
        CountDownLatch counter;
        CountDownLatch cleanupCounter;
        String user;
        boolean killed;
        boolean java;
        String ppid;
        AtomicInteger pendingCounter = new AtomicInteger(1);
        boolean rogue;

        public RogueProcessEntry(int counterValue, int cleanupCounterValue, String user, int maxSecondsBeforeEntryExpires, boolean isJava, String ppid) {
            this.counter = new CountDownLatch(counterValue);
            this.cleanupCounter = new CountDownLatch(cleanupCounterValue);
            this.user = user;
            this.java = isJava;
            this.ppid = ppid;
        }

        public String getPpid() {
            return this.ppid;
        }

        public boolean isRogue() {
            return this.rogue;
        }

        public void killed() {
            this.killed = true;
        }

        public boolean isKilled() {
            return this.killed;
        }

        public String getUser() {
            return this.user;
        }

        public long countDown() {
            this.counter.countDown();
            return this.counter.getCount();
        }

        public void resetCounter(int counterValue) {
            this.counter = new CountDownLatch(counterValue);
        }

        public long countDownCleanupCounter() {
            this.cleanupCounter.countDown();
            return this.cleanupCounter.getCount();
        }

        public void markAsRogue(int ceiling) {
            if (this.pendingCounter.get() < ceiling) {
                this.pendingCounter.addAndGet(1);
            } else {
                this.rogue = true;
            }
        }

        public boolean isJava() {
            return this.java;
        }
    }
}

