/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.agent.processors;

import java.io.FileNotFoundException;
import java.io.RandomAccessFile;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.camel.Exchange;
import org.apache.uima.ducc.agent.NodeAgent;
import org.apache.uima.ducc.agent.launcher.ManagedProcess;
import org.apache.uima.ducc.agent.metrics.collectors.DuccGarbageStatsCollector;
import org.apache.uima.ducc.agent.metrics.collectors.ProcessCpuUsageCollector;
import org.apache.uima.ducc.agent.metrics.collectors.ProcessMajorFaultCollector;
import org.apache.uima.ducc.agent.metrics.collectors.ProcessResidentMemoryCollector;
import org.apache.uima.ducc.agent.processors.BaseProcessor;
import org.apache.uima.ducc.agent.processors.ProcessMetricsProcessor;
import org.apache.uima.ducc.common.agent.metrics.cpu.ProcessCpuUsage;
import org.apache.uima.ducc.common.agent.metrics.memory.ProcessResidentMemory;
import org.apache.uima.ducc.common.agent.metrics.swap.DuccProcessSwapSpaceUsage;
import org.apache.uima.ducc.common.agent.metrics.swap.ProcessMemoryPageLoadUsage;
import org.apache.uima.ducc.common.node.metrics.ProcessGarbageCollectionStats;
import org.apache.uima.ducc.common.utils.DuccLogger;
import org.apache.uima.ducc.common.utils.Utils;
import org.apache.uima.ducc.transport.event.common.IDuccProcess;
import org.apache.uima.ducc.transport.event.common.IDuccProcessType;
import org.apache.uima.ducc.transport.event.common.IProcessState;

public class LinuxProcessMetricsProcessor
extends BaseProcessor
implements ProcessMetricsProcessor {
    private RandomAccessFile statmFile;
    private RandomAccessFile processStatFile;
    private long totalCpuInitUsage = 0L;
    private boolean initializing = true;
    private final ExecutorService pool;
    private IDuccProcess process;
    private DuccGarbageStatsCollector gcStatsCollector;
    private int blockSize = 4096;
    private DuccLogger logger;
    private ManagedProcess managedProcess;
    private NodeAgent agent;
    private int fudgeFactor = 5;
    private volatile boolean closed = true;
    private long clockAtStartOfRun = 0L;
    private long percentCPU = 0L;

    public LinuxProcessMetricsProcessor(DuccLogger logger, IDuccProcess process, NodeAgent agent, String statmFilePath, String nodeStatFilePath, String processStatFilePath, ManagedProcess managedProcess) throws FileNotFoundException {
        this.logger = logger;
        this.statmFile = new RandomAccessFile(statmFilePath, "r");
        this.processStatFile = new RandomAccessFile(processStatFilePath, "r");
        this.managedProcess = managedProcess;
        this.agent = agent;
        this.pool = Executors.newCachedThreadPool();
        this.process = process;
        this.gcStatsCollector = new DuccGarbageStatsCollector(logger, process);
        managedProcess.setMetricsProcessor(this);
        this.blockSize = agent.getOSPageSize();
        if (System.getProperty("ducc.agent.share.size.fudge.factor") != null) {
            try {
                this.fudgeFactor = Integer.parseInt(System.getProperty("ducc.agent.share.size.fudge.factor"));
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
            }
        }
        this.closed = false;
    }

    @Override
    public void stop() {
        try {
            if (this.pool != null) {
                this.pool.shutdown();
            }
        }
        catch (Exception e) {
            this.logger.error("LinuxProcessMetricsProcessor.stop()", null, (Throwable)e, new Object[0]);
        }
    }

    public void close() {
        this.closed = true;
        try {
            if (this.statmFile != null && this.statmFile.getFD().valid()) {
                this.statmFile.close();
            }
            if (this.processStatFile != null && this.processStatFile.getFD().valid()) {
                this.processStatFile.close();
            }
            this.stop();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void process(Exchange e) {
        if (this.closed) {
            return;
        }
        if (this.process.getProcessState().equals((Object)IProcessState.ProcessState.Initializing) || this.process.getProcessState().equals((Object)IProcessState.ProcessState.Running)) {
            try {
                String DUCC_HOME = Utils.findDuccHome();
                long totalSwapUsage = 0L;
                long totalFaults = 0L;
                long totalCpuUsage = 0L;
                long totalRss = 0L;
                Future<ProcessMemoryPageLoadUsage> processMajorFaultUsage = null;
                Future<ProcessCpuUsage> processCpuUsage = null;
                String[] cgroupPids = new String[]{};
                try {
                    if (this.agent.useCgroups) {
                        String containerId = this.agent.cgroupsManager.getContainerId(this.managedProcess);
                        for (String pid : cgroupPids = this.agent.cgroupsManager.getPidsInCgroup(containerId)) {
                            DuccProcessSwapSpaceUsage processSwapSpaceUsage = new DuccProcessSwapSpaceUsage(pid, this.managedProcess.getOwner(), DUCC_HOME + "/admin/ducc_get_process_swap_usage.sh", this.logger);
                            totalSwapUsage += processSwapSpaceUsage.getSwapUsage();
                            ProcessMajorFaultCollector processMajorFaultUsageCollector = new ProcessMajorFaultCollector(this.logger, pid);
                            processMajorFaultUsage = this.pool.submit(processMajorFaultUsageCollector);
                            totalFaults += processMajorFaultUsage.get().getMajorFaults();
                            ProcessCpuUsageCollector processCpuUsageCollector = new ProcessCpuUsageCollector(this.logger, pid, this.processStatFile, 42, 0);
                            processCpuUsage = this.pool.submit(processCpuUsageCollector);
                            totalCpuUsage += processCpuUsage.get().getTotalJiffies() / (long)this.agent.cpuClockRate;
                            RandomAccessFile rStatmFile = new RandomAccessFile("/proc/" + pid + "/statm", "r");
                            ProcessResidentMemoryCollector collector = new ProcessResidentMemoryCollector(rStatmFile, 2, 0);
                            Future<ProcessResidentMemory> prm = this.pool.submit(collector);
                            totalRss += prm.get().get();
                            rStatmFile.close();
                        }
                    } else {
                        DuccProcessSwapSpaceUsage processSwapSpaceUsage = new DuccProcessSwapSpaceUsage(this.process.getPID(), this.managedProcess.getOwner(), DUCC_HOME + "/admin/ducc_get_process_swap_usage.sh", this.logger);
                        totalSwapUsage = processSwapSpaceUsage.getSwapUsage();
                        ProcessMajorFaultCollector processMajorFaultUsageCollector = new ProcessMajorFaultCollector(this.logger, this.process.getPID());
                        processMajorFaultUsage = this.pool.submit(processMajorFaultUsageCollector);
                        totalFaults = processMajorFaultUsage.get().getMajorFaults();
                        ProcessCpuUsageCollector processCpuUsageCollector = new ProcessCpuUsageCollector(this.logger, this.process.getPID(), this.processStatFile, 42, 0);
                        processCpuUsage = this.pool.submit(processCpuUsageCollector);
                        totalCpuUsage = processCpuUsage.get().getTotalJiffies() / (long)this.agent.cpuClockRate;
                        ProcessResidentMemoryCollector collector = new ProcessResidentMemoryCollector(this.statmFile, 2, 0);
                        Future<ProcessResidentMemory> prm = this.pool.submit(collector);
                        totalRss = prm.get().get();
                    }
                }
                catch (Exception exc) {
                    this.logger.error("LinuxProcessMetricsProcessor.process", null, (Throwable)exc, new Object[0]);
                }
                if (this.managedProcess.getDuccProcess().getProcessState().equals((Object)IProcessState.ProcessState.Running)) {
                    if (this.agent.cpuClockRate > 0) {
                        if (this.initializing) {
                            this.initializing = false;
                            this.totalCpuInitUsage = totalCpuUsage;
                            this.clockAtStartOfRun = System.currentTimeMillis();
                        }
                        long timeSinceRunningInSeconds = (System.currentTimeMillis() - this.clockAtStartOfRun) / 1000L;
                        this.percentCPU = 100L * (totalCpuUsage - this.totalCpuInitUsage) / timeSinceRunningInSeconds;
                        this.logger.info("process", null, new Object[]{"----------- PID:" + this.process.getPID() + " CPU Time:" + this.percentCPU + "%"});
                        this.process.setCpuTime(this.percentCPU);
                    } else {
                        this.process.setCpuTime(0L);
                        this.logger.info("process", null, new Object[]{"Agent is unable to determine Node's clock rate. Defaulting CPU Time to 0 For Process with PID:" + this.process.getPID()});
                    }
                } else if (this.managedProcess.getDuccProcess().getProcessState().equals((Object)IProcessState.ProcessState.Initializing)) {
                    this.process.setCpuTime(0L);
                } else {
                    this.process.setCpuTime(this.percentCPU);
                }
                this.process.setMajorFaults(totalFaults);
                long st = System.currentTimeMillis();
                long processSwapUsage = totalSwapUsage * 1024L;
                this.process.setSwapUsage(processSwapUsage);
                this.logger.info("process", null, new Object[]{"----------- PID:" + this.process.getPID() + " Major Faults:" + totalFaults + " Process Swap Usage:" + processSwapUsage + " Max Swap Usage Allowed:" + this.managedProcess.getMaxSwapThreshold() + " Time to Collect Swap Usage:" + (System.currentTimeMillis() - st)});
                if (!(processSwapUsage > 0L && processSwapUsage > this.managedProcess.getMaxSwapThreshold() || this.agent.useCgroups || this.fudgeFactor <= -1 || this.managedProcess.getProcessMemoryAssignment().getMaxMemoryWithFudge() <= 0L)) {
                    long rss = totalRss * (long)(this.blockSize / 1024) / 1024L;
                    this.logger.trace("process", null, new Object[]{"*** Process with PID:" + this.managedProcess.getPid() + " Assigned Memory (MB): " + this.managedProcess.getProcessMemoryAssignment() + " MBs. Current RSS (MB):" + rss});
                    if (rss > this.managedProcess.getProcessMemoryAssignment().getMaxMemoryWithFudge()) {
                        this.logger.error("process", null, new Object[]{"\n\n********************************************************\n\tProcess with PID:" + this.managedProcess.getPid() + " Exceeded its max memory assignment (including a fudge factor) of " + this.managedProcess.getProcessMemoryAssignment().getMaxMemoryWithFudge() + " MBs. This Process Resident Memory Size: " + rss + " MBs .Killing process ...\n********************************************************\n\n"});
                        try {
                            this.managedProcess.kill();
                            this.process.setReasonForStoppingProcess(IDuccProcess.ReasonForStoppingProcess.ExceededShareSize.toString());
                            this.agent.stopProcess(this.process);
                            if (this.agent.useCgroups) {
                                for (String pid : cgroupPids) {
                                    if (pid.equals(this.managedProcess.getDuccProcess().getPID())) continue;
                                    this.killChildProcess(pid, "-15");
                                }
                            }
                        }
                        catch (Exception ee) {
                            this.logger.error("process", null, (Throwable)ee, new Object[0]);
                        }
                        return;
                    }
                }
                this.process.setResidentMemory(totalRss * (long)this.blockSize);
                if (!this.process.getProcessType().equals((Object)IDuccProcessType.ProcessType.Pop)) {
                    ProcessGarbageCollectionStats gcStats = this.gcStatsCollector.collect();
                    this.process.setGarbageCollectionStats(gcStats);
                    this.logger.info("process", null, new Object[]{"PID:" + this.process.getPID() + " Total GC Collection Count :" + gcStats.getCollectionCount() + " Total GC Collection Time :" + gcStats.getCollectionTime()});
                }
            }
            catch (Exception ex) {
                this.logger.error("process", null, new Object[]{e});
                ex.printStackTrace();
            }
        }
    }

    private void killChildProcess(String pid, final String signal) {
        new Thread(){

            @Override
            public void run() {
                String c_launcher_path = Utils.resolvePlaceholderIfExists((String)System.getProperty("ducc.agent.launcher.ducc_spawn_path"), (Properties)System.getProperties());
                try {
                    String[] killCmd = null;
                    String useSpawn = System.getProperty("ducc.agent.launcher.use.ducc_spawn");
                    killCmd = useSpawn != null && useSpawn.toLowerCase().equals("true") ? new String[]{c_launcher_path, "-u", LinuxProcessMetricsProcessor.this.managedProcess.getOwner(), "--", "/bin/kill", signal, LinuxProcessMetricsProcessor.this.managedProcess.getDuccProcess().getPID()} : new String[]{"/bin/kill", "-15", LinuxProcessMetricsProcessor.this.managedProcess.getDuccProcess().getPID()};
                    ProcessBuilder pb = new ProcessBuilder(killCmd);
                    Process p = pb.start();
                    p.wait(60000L);
                    p.destroy();
                }
                catch (Exception e) {
                    LinuxProcessMetricsProcessor.this.logger.error("killChildProcess", LinuxProcessMetricsProcessor.this.managedProcess.getWorkDuccId(), (Throwable)e, new Object[0]);
                }
            }
        }.start();
    }
}

