/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.agent.config;

import com.thoughtworks.xstream.XStream;
import java.util.List;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.Predicate;
import org.apache.camel.Processor;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.dataformat.xstream.XStreamDataFormat;
import org.apache.camel.impl.DefaultClassResolver;
import org.apache.camel.model.ChoiceDefinition;
import org.apache.camel.model.ExpressionNode;
import org.apache.camel.model.OnExceptionDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.model.RoutesDefinition;
import org.apache.camel.spi.ClassResolver;
import org.apache.uima.ducc.agent.NodeAgent;
import org.apache.uima.ducc.agent.event.AgentEventListener;
import org.apache.uima.ducc.agent.launcher.Launcher;
import org.apache.uima.ducc.agent.launcher.ManagedProcess;
import org.apache.uima.ducc.agent.processors.DefaultNodeInventoryProcessor;
import org.apache.uima.ducc.agent.processors.DefaultNodeMetricsProcessor;
import org.apache.uima.ducc.agent.processors.DefaultProcessMetricsProcessor;
import org.apache.uima.ducc.agent.processors.LinuxNodeMetricsProcessor;
import org.apache.uima.ducc.agent.processors.LinuxProcessMetricsProcessor;
import org.apache.uima.ducc.agent.processors.NodeInventoryProcessor;
import org.apache.uima.ducc.agent.processors.NodeMetricsProcessor;
import org.apache.uima.ducc.agent.processors.ProcessMetricsProcessor;
import org.apache.uima.ducc.common.NodeIdentity;
import org.apache.uima.ducc.common.config.CommonConfiguration;
import org.apache.uima.ducc.common.config.DuccBlastGuardPredicate;
import org.apache.uima.ducc.common.utils.DuccLogger;
import org.apache.uima.ducc.common.utils.Utils;
import org.apache.uima.ducc.transport.DuccTransportConfiguration;
import org.apache.uima.ducc.transport.agent.NodeMetricsConfiguration;
import org.apache.uima.ducc.transport.dispatcher.DuccEventDispatcher;
import org.apache.uima.ducc.transport.event.common.IDuccProcess;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@Configuration
@Import(value={DuccTransportConfiguration.class, CommonConfiguration.class, NodeMetricsConfiguration.class})
public class AgentConfiguration {
    DuccLogger logger = new DuccLogger(this.getClass(), "Agent");
    public String ip = System.getenv("IP");
    public String nodeName = System.getenv("NodeName");
    private CamelContext camelContext;
    private RouteBuilder metricsRouteBuilder;
    @Value(value="#{ systemProperties['ducc.agent.launcher.thread.pool.size'] }")
    String launcherThreadPoolSize;
    @Value(value="#{ systemProperties['ducc.agent.launcher.process.stop.timeout'] }")
    public String processStopTimeout;
    @Value(value="#{ systemProperties['ducc.agent.node.inventory.publish.rate.skip'] }")
    public String inventoryPublishRateSkipCount;
    @Value(value="#{ systemProperties['ducc.agent.rogue.process.exclusion.filter'] }")
    public String processExclusionList;
    @Value(value="#{ systemProperties['ducc.agent.rogue.process.user.exclusion.filter'] }")
    public String userExclusionList;
    @Autowired
    DuccTransportConfiguration agentTransport;
    @Autowired
    NodeMetricsConfiguration nodeMetrics;
    @Autowired
    CommonConfiguration common;

    public AgentEventListener agentDelegateListener(NodeAgent agent) {
        return new AgentEventListener(agent);
    }

    private RouteBuilder routeBuilderForNodeMetricsPost(NodeAgent agent, String targetEndpointToReceiveNodeMetricsUpdate, final int nodeMetricsPublishRate) throws Exception {
        NodeMetricsProcessor nmp = this.nodeMetricsProcessor(agent);
        DuccBlastGuardPredicate blastFilter = new DuccBlastGuardPredicate(agent.logger);
        ConfirmProcessor cp = new ConfirmProcessor();
        return new RouteBuilder((Predicate)blastFilter, nmp, targetEndpointToReceiveNodeMetricsUpdate, cp){
            final /* synthetic */ Predicate val$blastFilter;
            final /* synthetic */ Processor val$nmp;
            final /* synthetic */ String val$targetEndpointToReceiveNodeMetricsUpdate;
            final /* synthetic */ Processor val$cp;
            {
                this.val$blastFilter = predicate;
                this.val$nmp = processor;
                this.val$targetEndpointToReceiveNodeMetricsUpdate = string;
                this.val$cp = processor2;
            }

            public void configure() {
                this.onException(Exception.class).handled(true).process((Processor)new ErrorProcessor());
                ((ExpressionNode)((ExpressionNode)this.from("timer:nodeMetricsTimer?fixedRate=true&period=" + nodeMetricsPublishRate).routeId("NodeMetricsPostRoute").filter(this.val$blastFilter).process(this.val$nmp)).to(this.val$targetEndpointToReceiveNodeMetricsUpdate)).process(this.val$cp);
            }
        };
    }

    private RouteBuilder routeBuilderForNodeInventoryPost(final NodeAgent agent, final String targetEndpointToReceiveNodeInventoryUpdate, final int nodeInventoryPublishRate) throws Exception {
        final NodeInventoryProcessor nmp = this.nodeInventoryProcessor(agent);
        return new RouteBuilder(){

            public void configure() {
                Predicate bodyNotNull = this.body().isNotNull();
                DuccBlastGuardPredicate blastGuard = new DuccBlastGuardPredicate(agent.logger);
                this.onException(Exception.class).maximumRedeliveries(0).handled(true).process((Processor)new ErrorProcessor());
                ((ExpressionNode)this.from("timer:nodeInventoryTimer?fixedRate=true&period=" + nodeInventoryPublishRate).routeId("NodeInventoryPostRoute").filter((Predicate)blastGuard).process(nmp)).filter(bodyNotNull).to(targetEndpointToReceiveNodeInventoryUpdate);
            }
        };
    }

    public synchronized RouteBuilder routeBuilderForIncomingRequests(NodeAgent agent, final AgentEventListener delegate) {
        return new RouteBuilder(){

            public void configure() {
                this.onException(Throwable.class).maximumRedeliveries(0).handled(false).process((Processor)new ErrorProcessor());
                this.from(AgentConfiguration.this.common.agentRequestEndpoint).routeId("IncomingRequestsRoute").bean((Object)delegate);
            }
        };
    }

    public synchronized RouteBuilder routeBuilderForManagedProcessStateUpdate(final NodeAgent agent, final AgentEventListener delegate) {
        return new RouteBuilder(){
            Predicate filter;
            {
                this.filter = new DuccNodeFilter(agent);
            }

            public void configure() {
                ((OnExceptionDefinition)this.onException(Throwable.class).maximumRedeliveries(0).handled(true).process((Processor)new ErrorProcessor())).stop();
                ((ChoiceDefinition)this.from(AgentConfiguration.this.common.managedProcessStateUpdateEndpoint).routeId("ManageProcessStateUpdateRoute").choice().when(this.filter).bean((Object)delegate)).end();
            }
        };
    }

    private NodeIdentity nodeIdentity() throws Exception {
        NodeIdentity ni = null;
        ni = this.ip != null ? new NodeIdentity(this.ip, this.nodeName) : new NodeIdentity();
        return ni;
    }

    private Launcher launcher() {
        return new Launcher();
    }

    public DuccEventDispatcher getCommonProcessDispatcher(CamelContext camelContext) throws Exception {
        return this.agentTransport.duccEventDispatcher(this.logger, this.common.managedServiceEndpoint, camelContext);
    }

    @Bean
    public NodeAgent nodeAgent() throws Exception {
        try {
            this.camelContext = this.common.camelContext();
            this.camelContext.disableJMX();
            NodeAgent agent = new NodeAgent(this.nodeIdentity(), this.launcher(), this.camelContext, this);
            this.agentTransport.configureJMSTransport(this.logger, this.common.agentRequestEndpoint, this.camelContext);
            AgentEventListener delegateListener = this.agentDelegateListener(agent);
            if (this.common.managedProcessStateUpdateEndpointType != null && this.common.managedProcessStateUpdateEndpointType.equalsIgnoreCase("socket")) {
                String agentSocketParams = "";
                if (this.common.managedProcessStateUpdateEndpointParams != null) {
                    agentSocketParams = "?" + this.common.managedProcessStateUpdateEndpointParams;
                }
                int agentPort = Utils.findFreePort();
                this.common.managedProcessStateUpdateEndpoint = "mina:tcp://localhost:" + agentPort + agentSocketParams;
                System.setProperty("ducc.agent.process.state.update.port", String.valueOf(agentPort));
            }
            this.camelContext.addRoutes((RoutesBuilder)this.routeBuilderForManagedProcessStateUpdate(agent, delegateListener));
            this.camelContext.addRoutes((RoutesBuilder)this.routeBuilderForIncomingRequests(agent, delegateListener));
            this.camelContext.addRoutes((RoutesBuilder)this.routeBuilderForNodeInventoryPost(agent, this.common.nodeInventoryEndpoint, Integer.parseInt(this.common.nodeInventoryPublishRate)));
            this.metricsRouteBuilder = this.routeBuilderForNodeMetricsPost(agent, this.common.nodeMetricsEndpoint, Integer.parseInt(this.common.nodeMetricsPublishRate));
            this.camelContext.addRoutes((RoutesBuilder)this.metricsRouteBuilder);
            this.logger.info("nodeAgent", null, new Object[]{"------- Agent Initialized - Identity Name:" + agent.getIdentity().getName() + " IP:" + agent.getIdentity().getIp() + " JP State Update Endpoint:" + this.common.managedProcessStateUpdateEndpoint});
            return agent;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Bean
    public NodeMetricsProcessor nodeMetricsProcessor(NodeAgent agent) throws Exception {
        if (Utils.isLinux()) {
            return new LinuxNodeMetricsProcessor(agent, "/proc/meminfo", "/proc/loadavg");
        }
        return new DefaultNodeMetricsProcessor(agent);
    }

    public ProcessMetricsProcessor processMetricsProcessor(NodeAgent agent, IDuccProcess process, ManagedProcess managedProcess) throws Exception {
        if (Utils.isLinux()) {
            return new LinuxProcessMetricsProcessor(this.logger, process, agent, "/proc/" + process.getPID() + "/statm", "/proc/stat", "/proc/" + process.getPID() + "/stat", managedProcess);
        }
        return new DefaultProcessMetricsProcessor(process, agent);
    }

    public NodeInventoryProcessor nodeInventoryProcessor(NodeAgent agent) {
        return new DefaultNodeInventoryProcessor(agent, this.inventoryPublishRateSkipCount);
    }

    public void stopMetricsRoute() {
        String methodName = "stopMetricsRoute";
        try {
            RoutesDefinition rsd = this.metricsRouteBuilder.getRouteCollection();
            for (RouteDefinition rd : rsd.getRoutes()) {
                this.camelContext.stopRoute(rd.getId());
                this.logger.error(methodName, null, new Object[]{">>>> Agent Stopped Metrics Publishing"});
            }
        }
        catch (Exception e) {
            this.logger.error(methodName, null, (Throwable)e, new Object[0]);
        }
    }

    private class DuccNodeFilter
    implements Predicate {
        private NodeAgent agent = null;

        public DuccNodeFilter(NodeAgent agent) {
            this.agent = agent;
        }

        public synchronized boolean matches(Exchange exchange) {
            String methodName = "DuccNodeFilter.matches";
            boolean result = false;
            if (AgentConfiguration.this.common.managedProcessStateUpdateEndpoint.startsWith("mina")) {
                result = true;
            } else {
                try {
                    String nodes = (String)exchange.getIn().getHeader("target-nodes");
                    AgentConfiguration.this.logger.trace(methodName, null, new Object[]{">>>>>>>>> Agent: [" + this.agent.getIdentity().getIp() + "] Received a Message. Is Agent target for message:" + result + ". Target Agents:" + nodes});
                    result = Utils.isTargetNodeForMessage((String)nodes, (List)this.agent.getIdentity().getNodeIdentities());
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    AgentConfiguration.this.logger.error(methodName, null, e, new Object[0]);
                }
            }
            return result;
        }
    }

    public static class TransportProcessor
    implements Processor {
        public void process(Exchange exchange) throws Exception {
            try {
                System.out.println(">>> Agent Received Message of type:" + exchange.getIn().getBody().getClass().getName());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public class ErrorProcessor
    implements Processor {
        public void process(Exchange exchange) throws Exception {
            Throwable caused = (Throwable)exchange.getProperty("CamelExceptionCaught", Throwable.class);
            AgentConfiguration.this.logger.error("ErrorProcessor.process", null, caused, new Object[0]);
        }
    }

    public static class StateUpdateDebugProcessor
    implements Processor {
        DuccLogger logger;

        StateUpdateDebugProcessor(DuccLogger logger) {
            this.logger = logger;
        }

        public void process(Exchange exchange) throws Exception {
            Map map = exchange.getIn().getHeaders();
            StringBuffer sb = new StringBuffer();
            for (Map.Entry entry : map.entrySet()) {
                sb.append((String)entry.getKey()).append("=").append(entry.getValue()).append("\n");
            }
            this.logger.info("StateUpdateDebugProcessor.process", null, new Object[]{"Headers:\n\t" + sb.toString()});
        }
    }

    public static class ConfirmProcessor
    implements Processor {
        boolean first = true;

        public void process(Exchange exchange) throws Exception {
        }
    }

    public class DebugProcessor
    implements Processor {
        public void process(Exchange exchange) throws Exception {
            String methodName = "process";
            XStreamDataFormat xStreamDataFormat = new XStreamDataFormat();
            XStream xStream = xStreamDataFormat.getXStream((ClassResolver)new DefaultClassResolver());
            String marshalledEvent = xStream.toXML(exchange.getIn().getBody());
            AgentConfiguration.this.logger.info(methodName, null, new Object[]{marshalledEvent});
        }
    }
}

