/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.agent;

import java.io.Serializable;
import java.util.Properties;

public class NodeAgentInfo
implements Serializable {
    public static final String OSName = "os.name";
    public static final String OSVersion = "os.version";
    public static final String OSArchitecture = "os.arch";
    public static final String NodeCpus = "node.cpus";
    public static final String JavaVendor = "java.vendor";
    public static final String JavaVersion = "java.version";
    private static final long serialVersionUID = 1L;
    private String hostname;
    private String ip = "N/A";
    private int jmxPort;
    private Properties properties = new Properties();
    private String id;
    private AgentState status = AgentState.INITIALIZING;
    private String agentLog = "N/A";
    private boolean firstHeartbeat = true;

    public NodeAgentInfo(String hostname, String id) {
        this.hostname = hostname;
        this.id = id;
    }

    public boolean isFirstHeartbeat() {
        return this.firstHeartbeat;
    }

    public AgentState getStatus() {
        return this.status;
    }

    public String getAgentLog() {
        return this.agentLog;
    }

    public void setAgentLog(String agentLog) {
        this.agentLog = agentLog;
    }

    public String getIp() {
        return this.ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public void setStatus(AgentState status) {
        this.status = status;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public String getProperty(String key) {
        return this.properties.getProperty(key);
    }

    public void setProperty(String key, String value) {
        this.properties.put(key, value);
    }

    public int getJmxPort() {
        return this.jmxPort;
    }

    public void setJmxPort(int jmxPort) {
        this.jmxPort = jmxPort;
    }

    public String getHostname() {
        return this.hostname;
    }

    public String getId() {
        return this.id;
    }

    public void dump() {
        if (this.firstHeartbeat) {
            this.firstHeartbeat = false;
            System.out.println("+++++++++++ Controller Received Agent Info. \n\tNode:" + this.getHostname() + "\n\tAgent Node IP:" + this.getIp() + "\n\tAgent Node ID:" + this.getId() + "\n\tAgent Log:" + this.getAgentLog() + "\n\tAgent Jmx Port:" + this.getJmxPort() + "\n\tAgent Node OS:" + this.getProperty(OSName) + "\n\tAgent Node OS Level:" + this.getProperty(OSVersion) + "\n\tAgent Node OS Architecture:" + this.getProperty(OSArchitecture) + "\n\tAgent Node CPU Count:" + this.getProperty(NodeCpus) + "\n\tAgent Node Java Vendor:" + this.getProperty(JavaVendor) + "\n\tAgent Node Java Version:" + this.getProperty(JavaVersion));
        }
    }

    public static enum AgentState {
        INITIALIZING,
        READY,
        STOPPED,
        UNREACHABLE,
        FAILED;

    }
}

