/*
 * Decompiled with CFR 0.152.
 */
package org.apache.vinci.transport.vns.service;

import java.net.InetAddress;
import java.util.Enumeration;
import java.util.Hashtable;
import org.apache.vinci.transport.Frame;
import org.apache.vinci.transport.VinciFrame;
import org.apache.vinci.transport.vns.service.ServiceInterface;

public class Service
implements ServiceInterface {
    protected int port = -1;
    protected int minport;
    protected int maxport;
    protected int instance;
    protected String realhost;
    protected String host;
    protected String qhost;
    protected String name;
    protected String level;
    public int actualLevel = -2;
    protected boolean meta;
    protected Hashtable dict;

    public Service(Hashtable H) {
        this.dict = H;
        this.constructAttr();
    }

    private void constructAttr() {
        this.name = (String)this.dict.get("NAME");
        this.instance = this.atoi((String)this.dict.get("INSTANCE"));
        this.level = this.lvl((String)this.dict.get("LEVEL"));
        this.actualLevel = -2;
        this.minport = this.atoi((String)this.dict.get("MINPORT"));
        this.maxport = this.atoi((String)this.dict.get("MAXPORT"));
        this.port = this.atoi((String)this.dict.get("PORT"));
        this.host = (String)this.dict.get("HOST");
        this.qhost = (String)this.dict.get("FDQN");
        this.meta = this.dict.get("META") != null;
        this.realhost = (String)this.dict.get("IP");
        if (this.realhost == null && this.host != null) {
            this.realhost = this.getHostByAddr(this.host);
        }
        if (this.realhost == null && this.qhost != null) {
            this.realhost = this.getHostByAddr(this.qhost);
        }
        if (this.realhost == null) {
            throw new RuntimeException("No IP specified for the service");
        }
    }

    private int atoi(String s) {
        if (s == null) {
            return 0;
        }
        try {
            return Integer.parseInt(s);
        }
        catch (Exception e) {
            return 0;
        }
    }

    public Object getAttr(String name) {
        if (name.equals("name")) {
            return this.name;
        }
        if (name.equals("host")) {
            return this.host;
        }
        if (name.equals("realhost")) {
            if (this.realhost == null) {
                this.realhost = this.getHostByAddr(this.host);
                return this.realhost;
            }
            return this.realhost;
        }
        if (name.equals("qhost")) {
            this.qhost = this.getHostByAddr(this.host);
            return this.qhost;
        }
        if (name.equals("instance")) {
            return new Integer(this.instance);
        }
        if (name.equals("level")) {
            if (this.level == null || this.level.equals("")) {
                this.level = "0";
            }
            return new String(this.level);
        }
        if (name.equals("meta")) {
            Object o = this.dict.get(name.toUpperCase());
            if (o instanceof Frame) {
                return ((Frame)o).toXML();
            }
            return o;
        }
        name = name.toUpperCase();
        return this.dict.get(name);
    }

    public boolean equals(Object o) {
        if (!(o instanceof Service)) {
            return false;
        }
        return o.toString().equals(this.toString());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public void updatePort() {
        if (this.port == -1) {
            this.port = this.minport;
        }
        ++this.port;
        if (this.port > this.maxport || this.port < this.minport) {
            this.port = this.minport;
        }
        this.update();
    }

    public void update() {
        if (this.level != null) {
            this.dict.put("LEVEL", this.level);
        }
        if (this.realhost != null) {
            this.dict.put("IP", this.realhost);
        }
        this.dict.put("INSTANCE", new Integer(this.instance));
        this.dict.put("MINPORT", new Integer(this.minport));
        this.dict.put("MAXPORT", new Integer(this.maxport));
        this.dict.put("PORT", new Integer(this.port));
        this.dict.put("IP", this.getHostByName(this.host));
    }

    private String getHostByName(String host) {
        if (this.realhost != null) {
            return this.realhost;
        }
        return this.getHostByAddr(host);
    }

    private String getHostByAddr(String host) {
        try {
            return InetAddress.getByName(host).getHostAddress();
        }
        catch (Exception e) {
            return null;
        }
    }

    private String lvl(String s) {
        if (s == null) {
            return "0";
        }
        return s;
    }

    public Frame toFrame() {
        VinciFrame F = new VinciFrame();
        Object[] keys = this.dict.keySet().toArray();
        for (int i = 0; i < keys.length; ++i) {
            String S = (String)keys[i];
            Object O = this.dict.get(S);
            F.fadd(S, O.toString());
        }
        return F;
    }

    public String toXML() {
        this.update();
        StringBuffer str = new StringBuffer();
        str.append("<SERVICE>\n");
        Enumeration keys = this.dict.keys();
        while (keys.hasMoreElements()) {
            Object key = keys.nextElement();
            Object value = this.dict.get(key);
            if (value instanceof Frame) {
                str.append("   " + ((Frame)value).toXML());
                continue;
            }
            str.append("   <" + Service.xmlquote(key.toString()) + ">" + Service.xmlquote(value.toString()) + "</" + Service.xmlquote(key.toString()) + ">\n");
        }
        str.append("</SERVICE>\n");
        return str.toString();
    }

    public static String xmlquote(String s) {
        int i = 0;
        StringBuffer result = new StringBuffer();
        for (int j = 0; j < s.length() && i < 4; ++j) {
            if (Service.isEntity(s.charAt(j))) {
                ++i;
                result.append(Service.entityRef(s.charAt(j)));
                continue;
            }
            result.append(s.charAt(j));
        }
        if (i > 3) {
            return "<![CDATA[" + s + "]]>";
        }
        return result.toString();
    }

    static boolean isEntity(char c) {
        return c == '<' || c == '>' || c == '&' || c == '\"' || c == '\'';
    }

    static String entityRef(char c) {
        switch (c) {
            case '<': {
                return "&lt;";
            }
            case '>': {
                return "&gt;";
            }
            case '&': {
                return "&amp;";
            }
            case '\"': {
                return "&quot;";
            }
            case '\'': {
                return "&apos;";
            }
        }
        return "c";
    }

    public String toString() {
        return "NAME/REALHOST/LEVEL/INSTANCE=" + this.name + "/" + this.getHostByName(this.host) + "/" + this.level + "/" + this.instance;
    }
}

