/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.devp2p.v5.topic;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.crypto.Hash;
import org.apache.tuweni.devp2p.DiscoveryService;
import org.apache.tuweni.devp2p.v5.topic.TargetAd;
import org.apache.tuweni.devp2p.v5.topic.Topic;
import org.apache.tuweni.devp2p.v5.topic.TopicTable;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB\u0019\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u0006\u0010\u0010\u001a\u00020\u0011J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\bJ\u0014\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tH\u0002J\b\u0010\u0016\u001a\u00020\u0011H\u0002J\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\u0006\u0010\u0014\u001a\u00020\bJ\u0006\u0010\u001a\u001a\u00020\u0013J\u0016\u0010\u001b\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\b2\u0006\u0010\u001c\u001a\u00020\u0019J\u0018\u0010\u001d\u001a\u00020\u000b*\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tH\u0002J\u0018\u0010\u001e\u001a\u00020\u000b*\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tH\u0002R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000RB\u0010\u0006\u001a6\u0012\u0004\u0012\u00020\b\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t0\u0007j\u001a\u0012\u0004\u0012\u00020\b\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t`\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lorg/apache/tuweni/devp2p/v5/topic/TopicTable;", "", "tableCapacity", "", "queueCapacity", "(II)V", "table", "Ljava/util/HashMap;", "Lorg/apache/tuweni/devp2p/v5/topic/Topic;", "Lcom/google/common/cache/Cache;", "", "Lorg/apache/tuweni/devp2p/v5/topic/TargetAd;", "Lkotlin/collections/HashMap;", "timeSupplier", "Lkotlin/Function0;", "", "clear", "", "contains", "", "topic", "createNewQueue", "gcTable", "getNodes", "", "Lorg/apache/tuweni/bytes/Bytes;", "isEmpty", "put", "enr", "oldest", "youngest", "Companion", "devp2p"})
public final class TopicTable {
    private final Function0<Long> timeSupplier;
    private final HashMap<Topic, Cache<String, TargetAd>> table;
    private final int tableCapacity;
    private final int queueCapacity;
    public static final int MAX_ENTRIES_PER_TOPIC = 100;
    private static final int MAX_TABLE_CAPACITY = 500;
    private static final long TARGET_AD_LIFETIME_MS = 900000L;
    private static final String QUEUE_EMPTY_MSG = "Queue is empty.";
    public static final Companion Companion = new Companion(null);

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Bytes> getNodes(@NotNull Topic topic) {
        List list;
        Cache<String, TargetAd> values;
        Intrinsics.checkParameterIsNotNull((Object)topic, (String)"topic");
        Cache<String, TargetAd> cache = values = this.table.get(topic);
        if (cache != null) {
            void $receiver$iv$iv;
            Iterable $receiver$iv;
            Cache<String, TargetAd> cache2;
            Cache<String, TargetAd> it = cache2 = cache;
            boolean bl = false;
            Iterable iterable = $receiver$iv = (Iterable)values.asMap().values();
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                void it2;
                TargetAd targetAd = (TargetAd)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                Bytes bytes = it2.getEnr();
                collection.add(bytes);
            }
            list = (List)destination$iv$iv;
        } else {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    public final synchronized long put(@NotNull Topic topic, @NotNull Bytes enr) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)topic, (String)"topic");
        Intrinsics.checkParameterIsNotNull((Object)enr, (String)"enr");
        this.gcTable();
        Cache<String, TargetAd> topicQueue = this.table.get(topic);
        String nodeId = Hash.sha2_256((Bytes)enr).toHexString();
        if (topicQueue != null) {
            if (topicQueue.size() < (long)this.queueCapacity) {
                topicQueue.put((Object)nodeId, (Object)new TargetAd(((Number)this.timeSupplier.invoke()).longValue(), enr));
                return 0L;
            }
            return 900000L - (((Number)this.timeSupplier.invoke()).longValue() - this.oldest(topicQueue).getRegTime());
        }
        if (this.table.size() < this.tableCapacity) {
            Cache<String, TargetAd> cache = this.createNewQueue();
            Topic topic2 = topic;
            Map map2 = this.table;
            Cache<String, TargetAd> $this$apply = cache;
            boolean bl = false;
            $this$apply.put((Object)nodeId, (Object)new TargetAd(((Number)this.timeSupplier.invoke()).longValue(), enr));
            Cache<String, TargetAd> cache2 = cache;
            map2.put(topic2, cache2);
            return 0L;
        }
        Set<Map.Entry<Topic, Cache<String, TargetAd>>> set = this.table.entrySet();
        Intrinsics.checkExpressionValueIsNotNull(set, (String)"table.entries");
        Iterable iterable = $receiver$iv = (Iterable)set;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            Map.Entry entry = (Map.Entry)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Object v = it.getValue();
            Intrinsics.checkExpressionValueIsNotNull(v, (String)"it.value");
            Long l = this.youngest((Cache<String, TargetAd>)((Cache)v)).getRegTime();
            collection.add(l);
        }
        Long l = (Long)CollectionsKt.min((Iterable)((List)destination$iv$iv));
        long oldestInTable = l != null ? l : -1L;
        return 900000L - (((Number)this.timeSupplier.invoke()).longValue() - oldestInTable);
    }

    public final boolean contains(@NotNull Topic topic) {
        Intrinsics.checkParameterIsNotNull((Object)topic, (String)"topic");
        return this.table.containsKey(topic);
    }

    public final boolean isEmpty() {
        return this.table.isEmpty();
    }

    public final void clear() {
        this.table.clear();
    }

    private final Cache<String, TargetAd> createNewQueue() {
        Cache cache = CacheBuilder.newBuilder().expireAfterWrite(900000L, TimeUnit.MILLISECONDS).initialCapacity(this.queueCapacity).build();
        Intrinsics.checkExpressionValueIsNotNull((Object)cache, (String)"CacheBuilder.newBuilder(\u2026eCapacity)\n      .build()");
        return cache;
    }

    private final void gcTable() {
        this.table.entrySet().removeIf(gcTable.1.INSTANCE);
    }

    private final TargetAd oldest(@NotNull Cache<String, TargetAd> $this$oldest) {
        Object v0;
        Iterable $receiver$iv = $this$oldest.asMap().values();
        Iterator iterator$iv = $receiver$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v0 = null;
        } else {
            Object minElem$iv = iterator$iv.next();
            TargetAd it = (TargetAd)minElem$iv;
            boolean bl = false;
            long minValue$iv = it.getRegTime();
            while (iterator$iv.hasNext()) {
                Object e$iv = iterator$iv.next();
                TargetAd it2 = (TargetAd)e$iv;
                $i$a$-minBy-TopicTable$oldest$1 = false;
                long v$iv = it2.getRegTime();
                if (minValue$iv <= v$iv) continue;
                minElem$iv = e$iv;
                minValue$iv = v$iv;
            }
            v0 = minElem$iv;
        }
        TargetAd targetAd = v0;
        if (targetAd == null) {
            throw (Throwable)new IllegalArgumentException(QUEUE_EMPTY_MSG);
        }
        return targetAd;
    }

    private final TargetAd youngest(@NotNull Cache<String, TargetAd> $this$youngest) {
        Object v0;
        Iterable $receiver$iv = $this$youngest.asMap().values();
        Iterator iterator$iv = $receiver$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v0 = null;
        } else {
            Object maxElem$iv = iterator$iv.next();
            TargetAd it = (TargetAd)maxElem$iv;
            boolean bl = false;
            long maxValue$iv = it.getRegTime();
            while (iterator$iv.hasNext()) {
                Object e$iv = iterator$iv.next();
                TargetAd it2 = (TargetAd)e$iv;
                $i$a$-maxBy-TopicTable$youngest$1 = false;
                long v$iv = it2.getRegTime();
                if (maxValue$iv >= v$iv) continue;
                maxElem$iv = e$iv;
                maxValue$iv = v$iv;
            }
            v0 = maxElem$iv;
        }
        TargetAd targetAd = v0;
        if (targetAd == null) {
            throw (Throwable)new IllegalArgumentException(QUEUE_EMPTY_MSG);
        }
        return targetAd;
    }

    public TopicTable(int tableCapacity, int queueCapacity) {
        boolean bl;
        this.tableCapacity = tableCapacity;
        this.queueCapacity = queueCapacity;
        this.timeSupplier = DiscoveryService.Companion.getCURRENT_TIME_SUPPLIER$devp2p();
        this.table = new HashMap(this.tableCapacity);
        boolean bl2 = bl = this.tableCapacity > 0;
        if (!bl) {
            boolean bl3 = false;
            String string = "Table capacity value must be positive";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        boolean bl4 = bl = this.queueCapacity > 0;
        if (!bl) {
            boolean bl5 = false;
            String string = "Queue capacity value must be positive";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
    }

    public /* synthetic */ TopicTable(int n, int n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 1) != 0) {
            n = 500;
        }
        if ((n3 & 2) != 0) {
            n2 = 100;
        }
        this(n, n2);
    }

    public TopicTable() {
        this(0, 0, 3, null);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lorg/apache/tuweni/devp2p/v5/topic/TopicTable$Companion;", "", "()V", "MAX_ENTRIES_PER_TOPIC", "", "MAX_TABLE_CAPACITY", "QUEUE_EMPTY_MSG", "", "TARGET_AD_LIFETIME_MS", "", "devp2p"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

