/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.devp2p.v5.storage;

import com.google.common.math.IntMath;
import java.math.RoundingMode;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.crypto.Hash;
import org.apache.tuweni.kademlia.KademliaRoutingTable;
import org.apache.tuweni.kademlia.KademliaRoutingTableKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0006\u0018\u0000  2\u00020\u0001:\u0001 B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0003J\u0006\u0010\u0012\u001a\u00020\u0010J\u000e\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u0003J\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0011\u001a\u00020\u0003J\u0006\u0010\u0017\u001a\u00020\u0003J\u0006\u0010\u0018\u001a\u00020\u0016J\u0010\u0010\u0019\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u0003H\u0002J\u001e\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00030\u001b2\u0006\u0010\u0014\u001a\u00020\u00032\b\b\u0002\u0010\u001c\u001a\u00020\nJ\u0014\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00030\u001b2\u0006\u0010\u001e\u001a\u00020\nJ\u0006\u0010\u001f\u001a\u00020\u0003R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00030\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lorg/apache/tuweni/devp2p/v5/storage/RoutingTable;", "", "selfEnr", "Lorg/apache/tuweni/bytes/Bytes;", "(Lorg/apache/tuweni/bytes/Bytes;)V", "nodeIdCalculation", "Lkotlin/Function1;", "", "selfNodeId", "size", "", "getSize", "()I", "table", "Lorg/apache/tuweni/kademlia/KademliaRoutingTable;", "add", "", "enr", "clear", "distanceToSelf", "targetId", "evict", "", "getSelfEnr", "isEmpty", "key", "nearest", "", "limit", "nodesOfDistance", "distance", "random", "Companion", "devp2p"})
public final class RoutingTable {
    private final byte[] selfNodeId;
    private final Function1<Bytes, byte[]> nodeIdCalculation;
    private final KademliaRoutingTable<Bytes> table;
    private final Bytes selfEnr;
    private static final int BUCKET_SIZE = 16;
    public static final Companion Companion = new Companion(null);

    public final int getSize() {
        return this.table.size();
    }

    @NotNull
    public final Bytes getSelfEnr() {
        return this.selfEnr;
    }

    public final void add(@NotNull Bytes enr) {
        Intrinsics.checkParameterIsNotNull((Object)enr, (String)"enr");
        if (Intrinsics.areEqual((Object)enr, (Object)this.selfEnr) ^ true) {
            this.table.add((Object)enr);
        }
    }

    @NotNull
    public final List<Bytes> nearest(@NotNull Bytes targetId, int limit) {
        Intrinsics.checkParameterIsNotNull((Object)targetId, (String)"targetId");
        return this.table.nearest(this.key(targetId), limit);
    }

    @NotNull
    public static /* synthetic */ List nearest$default(RoutingTable routingTable, Bytes bytes, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 16;
        }
        return routingTable.nearest(bytes, n);
    }

    public final int distanceToSelf(@NotNull Bytes targetId) {
        Intrinsics.checkParameterIsNotNull((Object)targetId, (String)"targetId");
        return this.table.logDistToSelf((Object)targetId);
    }

    public final boolean evict(@NotNull Bytes enr) {
        Intrinsics.checkParameterIsNotNull((Object)enr, (String)"enr");
        return this.table.evict((Object)enr);
    }

    @NotNull
    public final Bytes random() {
        return (Bytes)this.table.getRandom();
    }

    public final boolean isEmpty() {
        return this.table.isEmpty();
    }

    @NotNull
    public final List<Bytes> nodesOfDistance(int distance) {
        return this.table.peersOfDistance(distance);
    }

    public final void clear() {
        this.table.clear();
    }

    private final byte[] key(Bytes enr) {
        byte[] byArray = Hash.sha2_256((Bytes)enr).toArray();
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"Hash.sha2_256(enr).toArray()");
        return byArray;
    }

    public RoutingTable(@NotNull Bytes selfEnr) {
        Intrinsics.checkParameterIsNotNull((Object)selfEnr, (String)"selfEnr");
        this.selfEnr = selfEnr;
        this.selfNodeId = this.key(this.selfEnr);
        this.nodeIdCalculation = (Function1)new Function1<Bytes, byte[]>(this){
            final /* synthetic */ RoutingTable this$0;

            @NotNull
            public final byte[] invoke(@NotNull Bytes enr) {
                Intrinsics.checkParameterIsNotNull((Object)enr, (String)"enr");
                return RoutingTable.access$key(this.this$0, enr);
            }
            {
                this.this$0 = routingTable;
                super(1);
            }
        };
        this.table = new KademliaRoutingTable(this.selfNodeId, 16, 0, this.nodeIdCalculation, (Function1)new Function1<Bytes, Integer>(this){
            final /* synthetic */ RoutingTable this$0;

            public final int invoke(@NotNull Bytes it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                int xorResult = KademliaRoutingTableKt.xorDist((byte[])RoutingTable.access$key(this.this$0, it), (byte[])RoutingTable.access$getSelfNodeId$p(this.this$0));
                return IntMath.log2((int)xorResult, (RoundingMode)RoundingMode.FLOOR);
            }
            {
                this.this$0 = routingTable;
                super(1);
            }
        }, 4, null);
    }

    public static final /* synthetic */ byte[] access$key(RoutingTable $this, Bytes enr) {
        return $this.key(enr);
    }

    public static final /* synthetic */ byte[] access$getSelfNodeId$p(RoutingTable $this) {
        return $this.selfNodeId;
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/apache/tuweni/devp2p/v5/storage/RoutingTable$Companion;", "", "()V", "BUCKET_SIZE", "", "devp2p"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

