/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.devp2p.v5.storage;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.bytes.Bytes32;
import org.apache.tuweni.crypto.Hash;
import org.apache.tuweni.devp2p.v5.ENRStorage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\u00062\u0006\u0010\b\u001a\u00020\u0006H\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0006H\u0016R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/apache/tuweni/devp2p/v5/storage/DefaultENRStorage;", "Lorg/apache/tuweni/devp2p/v5/ENRStorage;", "()V", "storage", "", "", "Lorg/apache/tuweni/bytes/Bytes;", "find", "nodeId", "set", "", "enr", "devp2p"})
public final class DefaultENRStorage
implements ENRStorage {
    private final Map<String, Bytes> storage = new ConcurrentHashMap();

    @Override
    @Nullable
    public Bytes find(@NotNull Bytes nodeId) {
        Intrinsics.checkParameterIsNotNull((Object)nodeId, (String)"nodeId");
        return this.storage.get(nodeId.toHexString());
    }

    @Override
    public void set(@NotNull Bytes enr) {
        Intrinsics.checkParameterIsNotNull((Object)enr, (String)"enr");
        Bytes32 nodeId = Hash.sha2_256((Bytes)enr);
        String string = nodeId.toHexString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"nodeId.toHexString()");
        this.storage.put(string, enr);
    }
}

