/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.devp2p.v5.internal;

import java.util.function.Function;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.bytes.Bytes32;
import org.apache.tuweni.crypto.Hash;
import org.apache.tuweni.crypto.SECP256K1;
import org.apache.tuweni.devp2p.v5.AuthenticationProvider;
import org.apache.tuweni.devp2p.v5.PacketCodec;
import org.apache.tuweni.devp2p.v5.encrypt.AES128GCM;
import org.apache.tuweni.devp2p.v5.internal.DefaultAuthenticationProvider;
import org.apache.tuweni.devp2p.v5.internal.DefaultPacketCodec;
import org.apache.tuweni.devp2p.v5.misc.AuthHeader;
import org.apache.tuweni.devp2p.v5.misc.DecodeResult;
import org.apache.tuweni.devp2p.v5.misc.EncodeResult;
import org.apache.tuweni.devp2p.v5.misc.HandshakeInitParameters;
import org.apache.tuweni.devp2p.v5.misc.SessionKey;
import org.apache.tuweni.devp2p.v5.packet.FindNodeMessage;
import org.apache.tuweni.devp2p.v5.packet.NodesMessage;
import org.apache.tuweni.devp2p.v5.packet.PingMessage;
import org.apache.tuweni.devp2p.v5.packet.PongMessage;
import org.apache.tuweni.devp2p.v5.packet.RandomMessage;
import org.apache.tuweni.devp2p.v5.packet.RegConfirmationMessage;
import org.apache.tuweni.devp2p.v5.packet.RegTopicMessage;
import org.apache.tuweni.devp2p.v5.packet.TicketMessage;
import org.apache.tuweni.devp2p.v5.packet.TopicQueryMessage;
import org.apache.tuweni.devp2p.v5.packet.UdpMessage;
import org.apache.tuweni.devp2p.v5.packet.WhoAreYouMessage;
import org.apache.tuweni.devp2p.v5.storage.RoutingTable;
import org.apache.tuweni.rlp.RLP;
import org.apache.tuweni.rlp.RLPReader;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0007H\u0016J\"\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\r\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00072\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0016J\u0018\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u0016H\u0002J(\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\u00072\u0006\u0010\u001a\u001a\u00020\u001bH\u0002R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lorg/apache/tuweni/devp2p/v5/internal/DefaultPacketCodec;", "Lorg/apache/tuweni/devp2p/v5/PacketCodec;", "keyPair", "Lorg/apache/tuweni/crypto/SECP256K1$KeyPair;", "routingTable", "Lorg/apache/tuweni/devp2p/v5/storage/RoutingTable;", "nodeId", "Lorg/apache/tuweni/bytes/Bytes;", "authenticationProvider", "Lorg/apache/tuweni/devp2p/v5/AuthenticationProvider;", "(Lorg/apache/tuweni/crypto/SECP256K1$KeyPair;Lorg/apache/tuweni/devp2p/v5/storage/RoutingTable;Lorg/apache/tuweni/bytes/Bytes;Lorg/apache/tuweni/devp2p/v5/AuthenticationProvider;)V", "decode", "Lorg/apache/tuweni/devp2p/v5/misc/DecodeResult;", "message", "encode", "Lorg/apache/tuweni/devp2p/v5/misc/EncodeResult;", "Lorg/apache/tuweni/devp2p/v5/packet/UdpMessage;", "destNodeId", "handshakeParams", "Lorg/apache/tuweni/devp2p/v5/misc/HandshakeInitParameters;", "encodeRandomMessage", "tag", "Lorg/apache/tuweni/devp2p/v5/packet/RandomMessage;", "read", "senderNodeId", "contentWithHeader", "reader", "Lorg/apache/tuweni/rlp/RLPReader;", "Companion", "devp2p"})
public final class DefaultPacketCodec
implements PacketCodec {
    private final SECP256K1.KeyPair keyPair;
    private final RoutingTable routingTable;
    private final Bytes nodeId;
    private final AuthenticationProvider authenticationProvider;
    private static final int WHO_ARE_YOU_MESSAGE_LENGTH = 48;
    public static final Companion Companion = new Companion(null);

    @Override
    @NotNull
    public EncodeResult encode(@NotNull UdpMessage message, @NotNull Bytes destNodeId, @Nullable HandshakeInitParameters handshakeParams) {
        EncodeResult encodeResult;
        AuthHeader authHeader;
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        Intrinsics.checkParameterIsNotNull((Object)destNodeId, (String)"destNodeId");
        if (message instanceof WhoAreYouMessage) {
            Bytes magic = UdpMessage.Companion.magic(this.nodeId);
            Bytes content = message.encode();
            Bytes bytes = Bytes.wrap((Bytes[])new Bytes[]{magic, content});
            Intrinsics.checkExpressionValueIsNotNull((Object)bytes, (String)"Bytes.wrap(magic, content)");
            return new EncodeResult(magic, bytes);
        }
        Bytes tag = UdpMessage.Companion.tag(this.nodeId, destNodeId);
        if (message instanceof RandomMessage) {
            return this.encodeRandomMessage(tag, (RandomMessage)message);
        }
        String string = destNodeId.toHexString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"destNodeId.toHexString()");
        SessionKey sessionKey = this.authenticationProvider.findSessionKey(string);
        HandshakeInitParameters handshakeInitParameters = handshakeParams;
        if (handshakeInitParameters != null) {
            HandshakeInitParameters handshakeInitParameters2;
            HandshakeInitParameters it = handshakeInitParameters2 = handshakeInitParameters;
            boolean bl = false;
            authHeader = sessionKey == null ? this.authenticationProvider.authenticate(handshakeParams) : null;
        } else {
            authHeader = null;
        }
        AuthHeader authHeader2 = authHeader;
        String string2 = destNodeId.toHexString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"destNodeId.toHexString()");
        SessionKey sessionKey2 = this.authenticationProvider.findSessionKey(string2);
        if (sessionKey2 == null || (sessionKey2 = sessionKey2.getInitiatorKey()) == null) {
            return this.encodeRandomMessage(tag, new RandomMessage(null, null, 3, null));
        }
        SessionKey initiatorKey = sessionKey2;
        Bytes messagePlain = Bytes.wrap((Bytes[])new Bytes[]{message.getMessageType(), message.encode()});
        if (authHeader2 != null) {
            Bytes encodedHeader = authHeader2.asRlp();
            Bytes authTag = authHeader2.getAuthTag();
            Bytes encryptionMeta = Bytes.wrap((Bytes[])new Bytes[]{tag, encodedHeader});
            Bytes bytes = messagePlain;
            Intrinsics.checkExpressionValueIsNotNull((Object)bytes, (String)"messagePlain");
            Bytes bytes2 = encryptionMeta;
            Intrinsics.checkExpressionValueIsNotNull((Object)bytes2, (String)"encryptionMeta");
            Bytes encryptionResult = AES128GCM.INSTANCE.encrypt((Bytes)initiatorKey, authTag, bytes, bytes2);
            if (message instanceof NodesMessage) {
                System.out.println(encryptionResult);
            }
            Bytes bytes3 = Bytes.wrap((Bytes[])new Bytes[]{tag, encodedHeader, encryptionResult});
            Intrinsics.checkExpressionValueIsNotNull((Object)bytes3, (String)"Bytes.wrap(tag, encodedHeader, encryptionResult)");
            encodeResult = new EncodeResult(authTag, bytes3);
        } else {
            Bytes authTag = UdpMessage.Companion.authTag();
            Bytes authTagHeader = RLP.encodeValue((Bytes)authTag);
            Bytes bytes = messagePlain;
            Intrinsics.checkExpressionValueIsNotNull((Object)bytes, (String)"messagePlain");
            Bytes encryptionResult = AES128GCM.INSTANCE.encrypt((Bytes)initiatorKey, authTag, bytes, tag);
            Bytes bytes4 = Bytes.wrap((Bytes[])new Bytes[]{tag, authTagHeader, encryptionResult});
            Intrinsics.checkExpressionValueIsNotNull((Object)bytes4, (String)"Bytes.wrap(tag, authTagHeader, encryptionResult)");
            encodeResult = new EncodeResult(authTag, bytes4);
        }
        return encodeResult;
    }

    @Override
    @NotNull
    public DecodeResult decode(@NotNull Bytes message) {
        UdpMessage decodedMessage2;
        Bytes tag;
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        Bytes bytes = tag = message.slice(0, 32);
        Intrinsics.checkExpressionValueIsNotNull((Object)bytes, (String)"tag");
        Bytes senderNodeId = UdpMessage.Companion.getSourceFromTag(bytes, this.nodeId);
        Bytes contentWithHeader = message.slice(32);
        UdpMessage udpMessage = decodedMessage2 = (UdpMessage)RLP.decode((Bytes)contentWithHeader, (Function)new Function<RLPReader, T>(this, tag, senderNodeId, contentWithHeader){
            final /* synthetic */ DefaultPacketCodec this$0;
            final /* synthetic */ Bytes $tag;
            final /* synthetic */ Bytes $senderNodeId;
            final /* synthetic */ Bytes $contentWithHeader;

            @NotNull
            public final UdpMessage apply(RLPReader reader) {
                Bytes bytes = this.$tag;
                Intrinsics.checkExpressionValueIsNotNull((Object)bytes, (String)"tag");
                Bytes bytes2 = this.$contentWithHeader;
                Intrinsics.checkExpressionValueIsNotNull((Object)bytes2, (String)"contentWithHeader");
                RLPReader rLPReader = reader;
                Intrinsics.checkExpressionValueIsNotNull((Object)rLPReader, (String)"reader");
                return DefaultPacketCodec.access$read(this.this$0, bytes, this.$senderNodeId, bytes2, rLPReader);
            }
            {
                this.this$0 = defaultPacketCodec;
                this.$tag = bytes;
                this.$senderNodeId = bytes2;
                this.$contentWithHeader = bytes3;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)udpMessage, (String)"decodedMessage");
        return new DecodeResult(senderNodeId, udpMessage);
    }

    private final UdpMessage read(Bytes tag, Bytes senderNodeId, Bytes contentWithHeader, RLPReader reader) {
        UdpMessage udpMessage;
        AuthHeader authHeader;
        SessionKey decryptionKey;
        Bytes encryptedContent;
        block18: {
            block17: {
                AuthHeader authHeader2;
                AuthHeader authHeader3 = null;
                Bytes bytes = Bytes.EMPTY;
                Intrinsics.checkExpressionValueIsNotNull((Object)bytes, (String)"Bytes.EMPTY");
                Bytes authTag = bytes;
                if (reader.nextIsList()) {
                    if (48 == contentWithHeader.size()) {
                        return WhoAreYouMessage.Companion.create(contentWithHeader);
                    }
                    AuthHeader authHeader4 = authHeader3 = (AuthHeader)reader.readList((Function)read.1.INSTANCE);
                    Intrinsics.checkExpressionValueIsNotNull((Object)authHeader4, (String)"authHeader");
                    this.authenticationProvider.finalizeHandshake(senderNodeId, authHeader4);
                } else {
                    Bytes bytes2 = reader.readValue();
                    Intrinsics.checkExpressionValueIsNotNull((Object)bytes2, (String)"reader.readValue()");
                    authTag = bytes2;
                }
                encryptedContent = contentWithHeader.slice(reader.position());
                String string = senderNodeId.toHexString();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"senderNodeId.toHexString()");
                SessionKey sessionKey = this.authenticationProvider.findSessionKey(string);
                if (sessionKey == null || (sessionKey = sessionKey.getInitiatorKey()) == null) {
                    Bytes bytes3 = encryptedContent;
                    Intrinsics.checkExpressionValueIsNotNull((Object)bytes3, (String)"encryptedContent");
                    return RandomMessage.Companion.create(authTag, bytes3);
                }
                decryptionKey = sessionKey;
                authHeader = authHeader3;
                if (authHeader == null) break block17;
                AuthHeader it = authHeader2 = authHeader;
                boolean bl = false;
                authHeader = Bytes.wrap((Bytes[])new Bytes[]{tag, authHeader3.asRlp()});
                if (authHeader != null) break block18;
            }
            authHeader = tag;
        }
        AuthHeader decryptMetadata = authHeader;
        Bytes bytes = encryptedContent;
        Intrinsics.checkExpressionValueIsNotNull((Object)bytes, (String)"encryptedContent");
        Bytes decryptedContent = AES128GCM.INSTANCE.decrypt(bytes, (Bytes)decryptionKey, (Bytes)decryptMetadata);
        Bytes messageType = decryptedContent.slice(0, 1);
        Bytes message = decryptedContent.slice(1);
        switch (messageType.toInt()) {
            case 1: {
                Bytes bytes4 = message;
                Intrinsics.checkExpressionValueIsNotNull((Object)bytes4, (String)"message");
                udpMessage = PingMessage.Companion.create(bytes4);
                break;
            }
            case 2: {
                Bytes bytes5 = message;
                Intrinsics.checkExpressionValueIsNotNull((Object)bytes5, (String)"message");
                udpMessage = PongMessage.Companion.create(bytes5);
                break;
            }
            case 3: {
                Bytes bytes6 = message;
                Intrinsics.checkExpressionValueIsNotNull((Object)bytes6, (String)"message");
                udpMessage = FindNodeMessage.Companion.create(bytes6);
                break;
            }
            case 4: {
                Bytes bytes7 = message;
                Intrinsics.checkExpressionValueIsNotNull((Object)bytes7, (String)"message");
                udpMessage = NodesMessage.Companion.create(bytes7);
                break;
            }
            case 5: {
                Bytes bytes8 = message;
                Intrinsics.checkExpressionValueIsNotNull((Object)bytes8, (String)"message");
                udpMessage = RegTopicMessage.Companion.create(bytes8);
                break;
            }
            case 6: {
                Bytes bytes9 = message;
                Intrinsics.checkExpressionValueIsNotNull((Object)bytes9, (String)"message");
                udpMessage = TicketMessage.Companion.create(bytes9);
                break;
            }
            case 7: {
                Bytes bytes10 = message;
                Intrinsics.checkExpressionValueIsNotNull((Object)bytes10, (String)"message");
                udpMessage = RegConfirmationMessage.Companion.create(bytes10);
                break;
            }
            case 8: {
                Bytes bytes11 = message;
                Intrinsics.checkExpressionValueIsNotNull((Object)bytes11, (String)"message");
                udpMessage = TopicQueryMessage.Companion.create(bytes11);
                break;
            }
            default: {
                throw (Throwable)new IllegalArgumentException("Unknown message retrieved");
            }
        }
        return udpMessage;
    }

    private final EncodeResult encodeRandomMessage(Bytes tag, RandomMessage message) {
        Bytes rlpAuthTag = RLP.encodeValue((Bytes)message.getAuthTag());
        Bytes content = message.encode();
        Bytes bytes = message.getAuthTag();
        Bytes bytes2 = Bytes.wrap((Bytes[])new Bytes[]{tag, rlpAuthTag, content});
        Intrinsics.checkExpressionValueIsNotNull((Object)bytes2, (String)"Bytes.wrap(tag, rlpAuthTag, content)");
        return new EncodeResult(bytes, bytes2);
    }

    public DefaultPacketCodec(@NotNull SECP256K1.KeyPair keyPair, @NotNull RoutingTable routingTable, @NotNull Bytes nodeId, @NotNull AuthenticationProvider authenticationProvider) {
        Intrinsics.checkParameterIsNotNull((Object)keyPair, (String)"keyPair");
        Intrinsics.checkParameterIsNotNull((Object)routingTable, (String)"routingTable");
        Intrinsics.checkParameterIsNotNull((Object)nodeId, (String)"nodeId");
        Intrinsics.checkParameterIsNotNull((Object)authenticationProvider, (String)"authenticationProvider");
        this.keyPair = keyPair;
        this.routingTable = routingTable;
        this.nodeId = nodeId;
        this.authenticationProvider = authenticationProvider;
    }

    public /* synthetic */ DefaultPacketCodec(SECP256K1.KeyPair keyPair, RoutingTable routingTable, Bytes bytes, AuthenticationProvider authenticationProvider, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            Bytes32 bytes32 = Hash.sha2_256((Bytes)routingTable.getSelfEnr());
            Intrinsics.checkExpressionValueIsNotNull((Object)bytes32, (String)"Hash.sha2_256(routingTable.getSelfEnr())");
            bytes = (Bytes)bytes32;
        }
        if ((n & 8) != 0) {
            authenticationProvider = new DefaultAuthenticationProvider(keyPair, routingTable);
        }
        this(keyPair, routingTable, bytes, authenticationProvider);
    }

    public static final /* synthetic */ UdpMessage access$read(DefaultPacketCodec $this, Bytes tag, Bytes senderNodeId, Bytes contentWithHeader, RLPReader reader) {
        return $this.read(tag, senderNodeId, contentWithHeader, reader);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/apache/tuweni/devp2p/v5/internal/DefaultPacketCodec$Companion;", "", "()V", "WHO_ARE_YOU_MESSAGE_LENGTH", "", "devp2p"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

