/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.devp2p.v5.encrypt;

import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.devp2p.v5.misc.SessionKey;
import org.bouncycastle.crypto.DerivationParameters;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.digests.SHA256Digest;
import org.bouncycastle.crypto.generators.HKDFBytesGenerator;
import org.bouncycastle.crypto.params.HKDFParameters;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\nH\u0002J&\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u0006R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/apache/tuweni/devp2p/v5/encrypt/SessionKeyGenerator;", "", "()V", "DERIVED_KEY_SIZE", "", "INFO_PREFIX", "Lorg/apache/tuweni/bytes/Bytes;", "kotlin.jvm.PlatformType", "derive", "hkdf", "Lorg/bouncycastle/crypto/generators/HKDFBytesGenerator;", "generate", "Lorg/apache/tuweni/devp2p/v5/misc/SessionKey;", "srcNodeId", "destNodeId", "secret", "idNonce", "devp2p"})
public final class SessionKeyGenerator {
    public static final int DERIVED_KEY_SIZE = 16;
    private static final Bytes INFO_PREFIX;
    public static final SessionKeyGenerator INSTANCE;

    @NotNull
    public final SessionKey generate(@NotNull Bytes srcNodeId, @NotNull Bytes destNodeId, @NotNull Bytes secret, @NotNull Bytes idNonce) {
        Intrinsics.checkParameterIsNotNull((Object)srcNodeId, (String)"srcNodeId");
        Intrinsics.checkParameterIsNotNull((Object)destNodeId, (String)"destNodeId");
        Intrinsics.checkParameterIsNotNull((Object)secret, (String)"secret");
        Intrinsics.checkParameterIsNotNull((Object)idNonce, (String)"idNonce");
        Bytes info = Bytes.wrap((Bytes[])new Bytes[]{INFO_PREFIX, srcNodeId, destNodeId});
        HKDFBytesGenerator hkdf = new HKDFBytesGenerator((Digest)new SHA256Digest());
        HKDFParameters params = new HKDFParameters(secret.toArray(), idNonce.toArray(), info.toArray());
        hkdf.init((DerivationParameters)params);
        return new SessionKey(this.derive(hkdf), this.derive(hkdf), this.derive(hkdf));
    }

    private final Bytes derive(HKDFBytesGenerator hkdf) {
        byte[] result2 = new byte[16];
        hkdf.generateBytes(result2, 0, result2.length);
        Bytes bytes = Bytes.wrap((byte[])result2);
        Intrinsics.checkExpressionValueIsNotNull((Object)bytes, (String)"Bytes.wrap(result)");
        return bytes;
    }

    private SessionKeyGenerator() {
    }

    static {
        SessionKeyGenerator sessionKeyGenerator;
        INSTANCE = sessionKeyGenerator = new SessionKeyGenerator();
        String string = "discovery v5 key agreement";
        Charset charset = Charsets.UTF_8;
        byte[] byArray = string.getBytes(charset);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        INFO_PREFIX = Bytes.wrap((byte[])byArray);
    }
}

