/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.devp2p.v5.encrypt;

import java.nio.ByteBuffer;
import java.security.Key;
import javax.crypto.Cipher;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.apache.tuweni.bytes.Bytes;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\tJ&\u0010\r\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\tR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/apache/tuweni/devp2p/v5/encrypt/AES128GCM;", "", "()V", "ALGO_NAME", "", "CIPHER_NAME", "KEY_SIZE", "", "decrypt", "Lorg/apache/tuweni/bytes/Bytes;", "encryptedContent", "key", "data", "encrypt", "nonce", "message", "devp2p"})
public final class AES128GCM {
    private static final String ALGO_NAME = "AES";
    private static final String CIPHER_NAME = "AES/GCM/NoPadding";
    private static final int KEY_SIZE = 128;
    public static final AES128GCM INSTANCE;

    @NotNull
    public final Bytes encrypt(@NotNull Bytes key, @NotNull Bytes nonce, @NotNull Bytes message, @NotNull Bytes data) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        Intrinsics.checkParameterIsNotNull((Object)nonce, (String)"nonce");
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        byte[] nonceBytes = nonce.toArray();
        SecretKeySpec keySpec = new SecretKeySpec(key.toArray(), ALGO_NAME);
        Cipher cipher = Cipher.getInstance(CIPHER_NAME);
        GCMParameterSpec parameterSpec = new GCMParameterSpec(128, nonceBytes);
        cipher.init(1, (Key)keySpec, parameterSpec);
        cipher.updateAAD(data.toArray());
        Bytes encryptedText = Bytes.wrap((byte[])cipher.doFinal(message.toArray()));
        Bytes wrappedNonce = Bytes.wrap((byte[])nonceBytes);
        Bytes nonceSize = Bytes.ofUnsignedInt((long)nonceBytes.length);
        Bytes bytes = Bytes.wrap((Bytes[])new Bytes[]{nonceSize, wrappedNonce, encryptedText});
        Intrinsics.checkExpressionValueIsNotNull((Object)bytes, (String)"Bytes.wrap(nonceSize, wrappedNonce, encryptedText)");
        return bytes;
    }

    @NotNull
    public final Bytes decrypt(@NotNull Bytes encryptedContent, @NotNull Bytes key, @NotNull Bytes data) {
        ByteBuffer buffer;
        Intrinsics.checkParameterIsNotNull((Object)encryptedContent, (String)"encryptedContent");
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        ByteBuffer byteBuffer = buffer = ByteBuffer.wrap(encryptedContent.toArray());
        Intrinsics.checkExpressionValueIsNotNull((Object)byteBuffer, (String)"buffer");
        int nonceLength = byteBuffer.getInt();
        byte[] nonce = new byte[nonceLength];
        buffer.get(nonce);
        byte[] encryptedText = new byte[buffer.remaining()];
        buffer.get(encryptedText);
        SecretKeySpec keySpec = new SecretKeySpec(key.toArray(), ALGO_NAME);
        GCMParameterSpec parameterSpec = new GCMParameterSpec(128, nonce);
        Cipher cipher = Cipher.getInstance(CIPHER_NAME);
        cipher.init(2, (Key)keySpec, parameterSpec);
        cipher.updateAAD(data.toArray());
        Bytes bytes = Bytes.wrap((byte[])cipher.doFinal(encryptedText));
        Intrinsics.checkExpressionValueIsNotNull((Object)bytes, (String)"Bytes.wrap(cipher.doFinal(encryptedText))");
        return bytes;
    }

    private AES128GCM() {
    }

    static {
        AES128GCM aES128GCM;
        INSTANCE = aES128GCM = new AES128GCM();
    }
}

