/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.devp2p;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.crypto.SECP256K1;
import org.apache.tuweni.devp2p.Endpoint;
import org.apache.tuweni.rlp.RLPReader;
import org.apache.tuweni.rlp.RLPWriter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0080\b\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\r\u0010\u0013\u001a\u00020\u0012H\u0000\u00a2\u0006\u0002\b\u0014J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001J\u0015\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0000\u00a2\u0006\u0002\b\u001bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u001d"}, d2={"Lorg/apache/tuweni/devp2p/Node;", "", "endpoint", "Lorg/apache/tuweni/devp2p/Endpoint;", "nodeId", "Lorg/apache/tuweni/crypto/SECP256K1$PublicKey;", "(Lorg/apache/tuweni/devp2p/Endpoint;Lorg/apache/tuweni/crypto/SECP256K1$PublicKey;)V", "getEndpoint", "()Lorg/apache/tuweni/devp2p/Endpoint;", "getNodeId", "()Lorg/apache/tuweni/crypto/SECP256K1$PublicKey;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "rlpSize", "rlpSize$devp2p", "toString", "", "writeTo", "", "writer", "Lorg/apache/tuweni/rlp/RLPWriter;", "writeTo$devp2p", "Companion", "devp2p"})
public final class Node {
    @NotNull
    private final Endpoint endpoint;
    @NotNull
    private final SECP256K1.PublicKey nodeId;
    public static final Companion Companion = new Companion(null);

    public final void writeTo$devp2p(@NotNull RLPWriter writer) {
        Intrinsics.checkParameterIsNotNull((Object)writer, (String)"writer");
        this.endpoint.writeTo$devp2p(writer);
        writer.writeValue(this.nodeId.bytes());
    }

    public final int rlpSize$devp2p() {
        return 1 + this.endpoint.rlpSize$devp2p() + 3 + 64;
    }

    @NotNull
    public final Endpoint getEndpoint() {
        return this.endpoint;
    }

    @NotNull
    public final SECP256K1.PublicKey getNodeId() {
        return this.nodeId;
    }

    public Node(@NotNull Endpoint endpoint, @NotNull SECP256K1.PublicKey nodeId) {
        Intrinsics.checkParameterIsNotNull((Object)endpoint, (String)"endpoint");
        Intrinsics.checkParameterIsNotNull((Object)nodeId, (String)"nodeId");
        this.endpoint = endpoint;
        this.nodeId = nodeId;
    }

    @NotNull
    public final Endpoint component1() {
        return this.endpoint;
    }

    @NotNull
    public final SECP256K1.PublicKey component2() {
        return this.nodeId;
    }

    @NotNull
    public final Node copy(@NotNull Endpoint endpoint, @NotNull SECP256K1.PublicKey nodeId) {
        Intrinsics.checkParameterIsNotNull((Object)endpoint, (String)"endpoint");
        Intrinsics.checkParameterIsNotNull((Object)nodeId, (String)"nodeId");
        return new Node(endpoint, nodeId);
    }

    @NotNull
    public static /* synthetic */ Node copy$default(Node node2, Endpoint endpoint, SECP256K1.PublicKey publicKey, int n, Object object) {
        if ((n & 1) != 0) {
            endpoint = node2.endpoint;
        }
        if ((n & 2) != 0) {
            publicKey = node2.nodeId;
        }
        return node2.copy(endpoint, publicKey);
    }

    @NotNull
    public String toString() {
        return "Node(endpoint=" + this.endpoint + ", nodeId=" + this.nodeId + ")";
    }

    public int hashCode() {
        Endpoint endpoint = this.endpoint;
        SECP256K1.PublicKey publicKey = this.nodeId;
        return (endpoint != null ? ((Object)endpoint).hashCode() : 0) * 31 + (publicKey != null ? publicKey.hashCode() : 0);
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof Node)) break block3;
                Node node2 = (Node)object;
                if (!Intrinsics.areEqual((Object)this.endpoint, (Object)node2.endpoint) || !Intrinsics.areEqual((Object)this.nodeId, (Object)node2.nodeId)) break block3;
            }
            return true;
        }
        return false;
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lorg/apache/tuweni/devp2p/Node$Companion;", "", "()V", "readFrom", "Lorg/apache/tuweni/devp2p/Node;", "reader", "Lorg/apache/tuweni/rlp/RLPReader;", "devp2p"})
    public static final class Companion {
        @NotNull
        public final Node readFrom(@NotNull RLPReader reader) {
            SECP256K1.PublicKey nodeId;
            Intrinsics.checkParameterIsNotNull((Object)reader, (String)"reader");
            Endpoint endpoint = Endpoint.Companion.readFrom(reader);
            SECP256K1.PublicKey publicKey = nodeId = SECP256K1.PublicKey.fromBytes((Bytes)reader.readValue());
            Intrinsics.checkExpressionValueIsNotNull((Object)publicKey, (String)"nodeId");
            return new Node(endpoint, publicKey);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

