/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.devp2p;

import java.math.BigInteger;
import java.net.InetAddress;
import java.nio.charset.Charset;
import java.time.Instant;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.bytes.MutableBytes;
import org.apache.tuweni.crypto.Hash;
import org.apache.tuweni.crypto.SECP256K1;
import org.apache.tuweni.devp2p.EthereumNodeRecord;
import org.apache.tuweni.devp2p.InvalidNodeRecordException;
import org.apache.tuweni.rlp.RLP;
import org.apache.tuweni.rlp.RLPWriter;
import org.apache.tuweni.units.bigints.UInt256;
import org.bouncycastle.math.ec.ECPoint;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00030\u0007\u00a2\u0006\u0002\u0010\tJ\u0006\u0010\u0010\u001a\u00020\u0011J\u0006\u0010\u0012\u001a\u00020\u0013J\u0006\u0010\u0014\u001a\u00020\u0015J\u0006\u0010\u0016\u001a\u00020\u0015J\u0006\u0010\u0017\u001a\u00020\u0018R\u001d\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00030\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001a"}, d2={"Lorg/apache/tuweni/devp2p/EthereumNodeRecord;", "", "signature", "Lorg/apache/tuweni/bytes/Bytes;", "seq", "", "data", "", "", "(Lorg/apache/tuweni/bytes/Bytes;JLjava/util/Map;)V", "getData", "()Ljava/util/Map;", "getSeq", "()J", "getSignature", "()Lorg/apache/tuweni/bytes/Bytes;", "ip", "Ljava/net/InetAddress;", "publicKey", "Lorg/apache/tuweni/crypto/SECP256K1$PublicKey;", "tcp", "", "udp", "validate", "", "Companion", "devp2p"})
public final class EthereumNodeRecord {
    @NotNull
    private final Bytes signature;
    private final long seq;
    @NotNull
    private final Map<String, Bytes> data;
    public static final Companion Companion = new Companion(null);

    public final void validate() {
        SECP256K1.PublicKey recovered;
        String string = "v4";
        Charset charset = Charsets.UTF_8;
        byte[] byArray = string.getBytes(charset);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        if (Intrinsics.areEqual((Object)Bytes.wrap((byte[])byArray), (Object)this.data.get("id")) ^ true) {
            throw (Throwable)new InvalidNodeRecordException("id attribute is not set to v4");
        }
        Bytes encoded2 = RLP.encodeList((Consumer)new Consumer<RLPWriter>(this){
            final /* synthetic */ EthereumNodeRecord this$0;

            public final void accept(RLPWriter it) {
                Map<String, Bytes> map2 = this.this$0.getData();
                long l = this.this$0.getSeq();
                RLPWriter rLPWriter = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)rLPWriter, (String)"it");
                RLPWriter rLPWriter2 = rLPWriter;
                long l2 = l;
                Integer n = null;
                Integer n2 = null;
                InetAddress inetAddress = null;
                Map<String, Bytes> map3 = map2;
                org.apache.tuweni.devp2p.EthereumNodeRecord$Companion.encode$default(EthereumNodeRecord.Companion, null, l2, inetAddress, n2, n, map3, rLPWriter2, 29, null);
            }
            {
                this.this$0 = ethereumNodeRecord;
            }
        });
        SECP256K1.Signature sig = SECP256K1.Signature.create((byte)1, (BigInteger)this.signature.slice(0, 32).toUnsignedBigInteger(), (BigInteger)this.signature.slice(32).toUnsignedBigInteger());
        SECP256K1.PublicKey pubKey = this.publicKey();
        if (Intrinsics.areEqual((Object)pubKey, (Object)(recovered = SECP256K1.PublicKey.recoverFromSignature((Bytes)encoded2, (SECP256K1.Signature)sig))) ^ true) {
            throw (Throwable)new InvalidNodeRecordException("Public key does not match signature");
        }
    }

    @NotNull
    public final SECP256K1.PublicKey publicKey() {
        Bytes bytes = this.data.get("secp256k1");
        if (bytes == null) {
            throw (Throwable)new InvalidNodeRecordException("Missing secp256k1 entry");
        }
        Bytes keyBytes = bytes;
        ECPoint ecPoint = SECP256K1.Parameters.CURVE.getCurve().decodePoint(keyBytes.toArrayUnsafe());
        SECP256K1.PublicKey publicKey = SECP256K1.PublicKey.fromBytes((Bytes)Bytes.wrap((byte[])ecPoint.getEncoded(false)).slice(1));
        Intrinsics.checkExpressionValueIsNotNull((Object)publicKey, (String)"SECP256K1.PublicKey.from\u2026Encoded(false)).slice(1))");
        return publicKey;
    }

    @NotNull
    public final InetAddress ip() {
        Bytes bytes = this.data.get("ip");
        if (bytes == null) {
            Intrinsics.throwNpe();
        }
        InetAddress inetAddress = InetAddress.getByAddress(bytes.toArrayUnsafe());
        Intrinsics.checkExpressionValueIsNotNull((Object)inetAddress, (String)"InetAddress.getByAddress\u2026[\"ip\"]!!.toArrayUnsafe())");
        return inetAddress;
    }

    public final int tcp() {
        Bytes bytes = this.data.get("tcp");
        if (bytes == null) {
            Intrinsics.throwNpe();
        }
        return bytes.toInt();
    }

    public final int udp() {
        Bytes bytes = this.data.get("udp");
        if (bytes == null) {
            Intrinsics.throwNpe();
        }
        return bytes.toInt();
    }

    @NotNull
    public final Bytes getSignature() {
        return this.signature;
    }

    public final long getSeq() {
        return this.seq;
    }

    @NotNull
    public final Map<String, Bytes> getData() {
        return this.data;
    }

    public EthereumNodeRecord(@NotNull Bytes signature, long seq, @NotNull Map<String, ? extends Bytes> data) {
        Intrinsics.checkParameterIsNotNull((Object)signature, (String)"signature");
        Intrinsics.checkParameterIsNotNull(data, (String)"data");
        this.signature = signature;
        this.seq = seq;
        this.data = data;
    }

    @JvmStatic
    @NotNull
    public static final EthereumNodeRecord fromRLP(@NotNull Bytes rlp) {
        return Companion.fromRLP(rlp);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Bytes toRLP(@NotNull SECP256K1.KeyPair signatureKeyPair, long seq, @Nullable Map<String, ? extends Bytes> data, @NotNull InetAddress ip, @Nullable Integer tcp, @Nullable Integer udp) {
        return Companion.toRLP(signatureKeyPair, seq, data, ip, tcp, udp);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Bytes toRLP(@NotNull SECP256K1.KeyPair signatureKeyPair, long seq, @Nullable Map<String, ? extends Bytes> data, @NotNull InetAddress ip, @Nullable Integer tcp) {
        return org.apache.tuweni.devp2p.EthereumNodeRecord$Companion.toRLP$default(Companion, signatureKeyPair, seq, data, ip, tcp, null, 32, null);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Bytes toRLP(@NotNull SECP256K1.KeyPair signatureKeyPair, long seq, @Nullable Map<String, ? extends Bytes> data, @NotNull InetAddress ip) {
        return org.apache.tuweni.devp2p.EthereumNodeRecord$Companion.toRLP$default(Companion, signatureKeyPair, seq, data, ip, null, null, 48, null);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Bytes toRLP(@NotNull SECP256K1.KeyPair signatureKeyPair, long seq, @NotNull InetAddress ip) {
        return org.apache.tuweni.devp2p.EthereumNodeRecord$Companion.toRLP$default(Companion, signatureKeyPair, seq, null, ip, null, null, 52, null);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Bytes toRLP(@NotNull SECP256K1.KeyPair signatureKeyPair, @NotNull InetAddress ip) {
        return org.apache.tuweni.devp2p.EthereumNodeRecord$Companion.toRLP$default(Companion, signatureKeyPair, 0L, null, ip, null, null, 54, null);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002Jg\u0010\u0003\u001a\u00020\u00042\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\b\u0002\u0010\u0007\u001a\u00020\b2\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n2\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\f2\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\f2\u0016\b\u0002\u0010\u000e\u001a\u0010\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u0011\u0018\u00010\u000f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002\u00a2\u0006\u0002\u0010\u0014J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0011H\u0007JW\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\b2\u0016\b\u0002\u0010\u000e\u001a\u0010\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u0011\u0018\u00010\u000f2\u0006\u0010\t\u001a\u00020\n2\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\f2\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\fH\u0007\u00a2\u0006\u0002\u0010\u0019\u00a8\u0006\u001a"}, d2={"Lorg/apache/tuweni/devp2p/EthereumNodeRecord$Companion;", "", "()V", "encode", "", "signatureKeyPair", "Lorg/apache/tuweni/crypto/SECP256K1$KeyPair;", "seq", "", "ip", "Ljava/net/InetAddress;", "tcp", "", "udp", "data", "", "", "Lorg/apache/tuweni/bytes/Bytes;", "writer", "Lorg/apache/tuweni/rlp/RLPWriter;", "(Lorg/apache/tuweni/crypto/SECP256K1$KeyPair;JLjava/net/InetAddress;Ljava/lang/Integer;Ljava/lang/Integer;Ljava/util/Map;Lorg/apache/tuweni/rlp/RLPWriter;)V", "fromRLP", "Lorg/apache/tuweni/devp2p/EthereumNodeRecord;", "rlp", "toRLP", "(Lorg/apache/tuweni/crypto/SECP256K1$KeyPair;JLjava/util/Map;Ljava/net/InetAddress;Ljava/lang/Integer;Ljava/lang/Integer;)Lorg/apache/tuweni/bytes/Bytes;", "devp2p"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final EthereumNodeRecord fromRLP(@NotNull Bytes rlp) {
            Intrinsics.checkParameterIsNotNull((Object)rlp, (String)"rlp");
            if (rlp.size() > 300) {
                throw (Throwable)new IllegalArgumentException("Record too long");
            }
            Object object = RLP.decodeList((Bytes)rlp, (Function)fromRLP.1.INSTANCE);
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"RLP.decodeList(rlp, {\n  \u2026(sig, seq, data)\n      })");
            return (EthereumNodeRecord)object;
        }

        private final void encode(SECP256K1.KeyPair signatureKeyPair, long seq, InetAddress ip, Integer tcp, Integer udp, Map<String, ? extends Bytes> data, RLPWriter writer) {
            Bytes bytes;
            String string;
            Object it;
            writer.writeLong(seq);
            Map map2 = data;
            if (map2 == null || (map2 = MapsKt.toMutableMap(map2)) == null) {
                map2 = new LinkedHashMap();
            }
            Map mutableData = map2;
            Object object = mutableData;
            String string2 = "id";
            String string3 = "v4";
            Object object2 = Charsets.UTF_8;
            byte[] byArray = string3.getBytes((Charset)object2);
            Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
            Bytes bytes2 = Bytes.wrap((byte[])byArray);
            Intrinsics.checkExpressionValueIsNotNull((Object)bytes2, (String)"Bytes.wrap(\"v4\".toByteArray())");
            string3 = bytes2;
            object.put(string2, string3);
            SECP256K1.KeyPair keyPair = signatureKeyPair;
            if (keyPair != null) {
                it = object = keyPair;
                boolean bl = false;
                object2 = mutableData;
                string = "secp256k1";
                Bytes bytes3 = Bytes.wrap((byte[])it.publicKey().asEcPoint().getEncoded(true));
                Intrinsics.checkExpressionValueIsNotNull((Object)bytes3, (String)"Bytes.wrap(it.publicKey(\u2026Point().getEncoded(true))");
                bytes = bytes3;
                object2.put(string, bytes);
            }
            InetAddress inetAddress = ip;
            if (inetAddress != null) {
                it = object = inetAddress;
                boolean bl = false;
                object2 = mutableData;
                string = "ip";
                Bytes bytes4 = Bytes.wrap((byte[])((InetAddress)it).getAddress());
                Intrinsics.checkExpressionValueIsNotNull((Object)bytes4, (String)"Bytes.wrap(it.address)");
                bytes = bytes4;
                object2.put(string, bytes);
            }
            Integer n = tcp;
            if (n != null) {
                object = n;
                int it2 = ((Number)object).intValue();
                boolean bl = false;
                object2 = mutableData;
                string = "tcp";
                Bytes bytes5 = Bytes.ofUnsignedShort((int)it2);
                Intrinsics.checkExpressionValueIsNotNull((Object)bytes5, (String)"Bytes.ofUnsignedShort(it)");
                bytes = bytes5;
                object2.put(string, bytes);
            }
            Integer n2 = udp;
            if (n2 != null) {
                object = n2;
                int it3 = ((Number)object).intValue();
                boolean bl = false;
                object2 = mutableData;
                string = "udp";
                Bytes bytes6 = Bytes.ofUnsignedShort((int)it3);
                Intrinsics.checkExpressionValueIsNotNull((Object)bytes6, (String)"Bytes.ofUnsignedShort(it)");
                bytes = bytes6;
                object2.put(string, bytes);
                writer.writeString("udp");
            }
            Iterable $receiver$iv = CollectionsKt.sorted((Iterable)mutableData.keySet());
            for (Object element$iv : $receiver$iv) {
                String key = (String)element$iv;
                boolean bl = false;
                if ((Bytes)mutableData.get(key) == null) continue;
                Bytes value = bytes;
                boolean bl2 = false;
                writer.writeString(key);
                writer.writeValue(value);
            }
        }

        static /* synthetic */ void encode$default(Companion companion, SECP256K1.KeyPair keyPair, long l, InetAddress inetAddress, Integer n, Integer n2, Map map2, RLPWriter rLPWriter, int n3, Object object) {
            if ((n3 & 1) != 0) {
                keyPair = null;
            }
            if ((n3 & 2) != 0) {
                l = Instant.now().toEpochMilli();
            }
            if ((n3 & 4) != 0) {
                inetAddress = null;
            }
            if ((n3 & 8) != 0) {
                n = null;
            }
            if ((n3 & 0x10) != 0) {
                n2 = null;
            }
            if ((n3 & 0x20) != 0) {
                map2 = null;
            }
            companion.encode(keyPair, l, inetAddress, n, n2, map2, rLPWriter);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final Bytes toRLP(@NotNull SECP256K1.KeyPair signatureKeyPair, long seq, @Nullable Map<String, ? extends Bytes> data, @NotNull InetAddress ip, @Nullable Integer tcp, @Nullable Integer udp) {
            Bytes completeEncoding2;
            Intrinsics.checkParameterIsNotNull((Object)signatureKeyPair, (String)"signatureKeyPair");
            Intrinsics.checkParameterIsNotNull((Object)ip, (String)"ip");
            Bytes encoded2 = RLP.encode((Consumer)new Consumer<RLPWriter>(signatureKeyPair, seq, ip, tcp, udp, data){
                final /* synthetic */ SECP256K1.KeyPair $signatureKeyPair;
                final /* synthetic */ long $seq;
                final /* synthetic */ InetAddress $ip;
                final /* synthetic */ Integer $tcp;
                final /* synthetic */ Integer $udp;
                final /* synthetic */ Map $data;

                public final void accept(RLPWriter writer) {
                    RLPWriter rLPWriter = writer;
                    Intrinsics.checkExpressionValueIsNotNull((Object)rLPWriter, (String)"writer");
                    org.apache.tuweni.devp2p.EthereumNodeRecord$Companion.access$encode(EthereumNodeRecord.Companion, this.$signatureKeyPair, this.$seq, this.$ip, this.$tcp, this.$udp, this.$data, rLPWriter);
                }
                {
                    this.$signatureKeyPair = keyPair;
                    this.$seq = l;
                    this.$ip = inetAddress;
                    this.$tcp = n;
                    this.$udp = n2;
                    this.$data = map2;
                }
            });
            SECP256K1.Signature signature = SECP256K1.sign((Bytes)((Bytes)Hash.keccak256((Bytes)encoded2)), (SECP256K1.KeyPair)signatureKeyPair);
            MutableBytes sigBytes = MutableBytes.create((int)64);
            UInt256.valueOf((BigInteger)signature.r()).toBytes().copyTo(sigBytes, 0);
            UInt256.valueOf((BigInteger)signature.s()).toBytes().copyTo(sigBytes, 32);
            Bytes bytes = completeEncoding2 = RLP.encodeList((Consumer)new Consumer<RLPWriter>(sigBytes, signatureKeyPair, seq, ip, tcp, udp, data){
                final /* synthetic */ MutableBytes $sigBytes;
                final /* synthetic */ SECP256K1.KeyPair $signatureKeyPair;
                final /* synthetic */ long $seq;
                final /* synthetic */ InetAddress $ip;
                final /* synthetic */ Integer $tcp;
                final /* synthetic */ Integer $udp;
                final /* synthetic */ Map $data;

                public final void accept(RLPWriter writer) {
                    writer.writeValue((Bytes)this.$sigBytes);
                    RLPWriter rLPWriter = writer;
                    Intrinsics.checkExpressionValueIsNotNull((Object)rLPWriter, (String)"writer");
                    org.apache.tuweni.devp2p.EthereumNodeRecord$Companion.access$encode(EthereumNodeRecord.Companion, this.$signatureKeyPair, this.$seq, this.$ip, this.$tcp, this.$udp, this.$data, rLPWriter);
                }
                {
                    this.$sigBytes = mutableBytes;
                    this.$signatureKeyPair = keyPair;
                    this.$seq = l;
                    this.$ip = inetAddress;
                    this.$tcp = n;
                    this.$udp = n2;
                    this.$data = map2;
                }
            });
            Intrinsics.checkExpressionValueIsNotNull((Object)bytes, (String)"completeEncoding");
            return bytes;
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public static /* synthetic */ Bytes toRLP$default(Companion companion, SECP256K1.KeyPair keyPair, long l, Map map2, InetAddress inetAddress, Integer n, Integer n2, int n3, Object object) {
            if ((n3 & 2) != 0) {
                l = Instant.now().toEpochMilli();
            }
            if ((n3 & 4) != 0) {
                map2 = null;
            }
            if ((n3 & 0x10) != 0) {
                n = null;
            }
            if ((n3 & 0x20) != 0) {
                n2 = null;
            }
            return companion.toRLP(keyPair, l, map2, inetAddress, n, n2);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final Bytes toRLP(@NotNull SECP256K1.KeyPair signatureKeyPair, long seq, @Nullable Map<String, ? extends Bytes> data, @NotNull InetAddress ip, @Nullable Integer tcp) {
            return org.apache.tuweni.devp2p.EthereumNodeRecord$Companion.toRLP$default(this, signatureKeyPair, seq, data, ip, tcp, null, 32, null);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final Bytes toRLP(@NotNull SECP256K1.KeyPair signatureKeyPair, long seq, @Nullable Map<String, ? extends Bytes> data, @NotNull InetAddress ip) {
            return org.apache.tuweni.devp2p.EthereumNodeRecord$Companion.toRLP$default(this, signatureKeyPair, seq, data, ip, null, null, 48, null);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final Bytes toRLP(@NotNull SECP256K1.KeyPair signatureKeyPair, long seq, @NotNull InetAddress ip) {
            return org.apache.tuweni.devp2p.EthereumNodeRecord$Companion.toRLP$default(this, signatureKeyPair, seq, null, ip, null, null, 52, null);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final Bytes toRLP(@NotNull SECP256K1.KeyPair signatureKeyPair, @NotNull InetAddress ip) {
            return org.apache.tuweni.devp2p.EthereumNodeRecord$Companion.toRLP$default(this, signatureKeyPair, 0L, null, ip, null, null, 54, null);
        }

        private Companion() {
        }

        public static final /* synthetic */ void access$encode(Companion $this, SECP256K1.KeyPair signatureKeyPair, long seq, InetAddress ip, Integer tcp, Integer udp, Map data, RLPWriter writer) {
            $this.encode(signatureKeyPair, seq, ip, tcp, udp, data, writer);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

