/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.bytes;

import com.google.common.base.Preconditions;
import java.nio.ByteBuffer;
import org.apache.tuweni.bytes.ArrayWrappingBytes32;
import org.apache.tuweni.bytes.ByteBufferWrappingBytes;
import org.apache.tuweni.bytes.Bytes32;
import org.apache.tuweni.bytes.MutableArrayWrappingBytes32;
import org.apache.tuweni.bytes.MutableBytes32;

class ByteBufferWrappingBytes32
extends ByteBufferWrappingBytes
implements Bytes32 {
    ByteBufferWrappingBytes32(ByteBuffer byteBuffer) {
        this(byteBuffer, 0, byteBuffer.limit());
    }

    ByteBufferWrappingBytes32(ByteBuffer byteBuffer, int offset, int length) {
        super(byteBuffer, offset, length);
        Preconditions.checkArgument((length == 32 ? 1 : 0) != 0, (String)"Expected %s bytes but got %s", (int)32, (int)length);
    }

    @Override
    public Bytes32 copy() {
        if (this.offset == 0 && this.length == this.byteBuffer.limit()) {
            return this;
        }
        return new ArrayWrappingBytes32(this.toArray());
    }

    @Override
    public MutableBytes32 mutableCopy() {
        return new MutableArrayWrappingBytes32(this.toArray());
    }
}

