/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.bytes;

import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import io.vertx.core.buffer.Buffer;
import java.io.IOException;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.security.MessageDigest;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Base64;
import java.util.Random;
import org.apache.tuweni.bytes.AbstractBytes;
import org.apache.tuweni.bytes.ArrayWrappingBytes;
import org.apache.tuweni.bytes.ArrayWrappingBytes32;
import org.apache.tuweni.bytes.BufferWrappingBytes;
import org.apache.tuweni.bytes.ByteBufWrappingBytes;
import org.apache.tuweni.bytes.ByteBufferWrappingBytes;
import org.apache.tuweni.bytes.BytesValues;
import org.apache.tuweni.bytes.ConcatenatedBytes;
import org.apache.tuweni.bytes.MutableBytes;

public interface Bytes {
    public static final Bytes EMPTY = Bytes.wrap(new byte[0]);

    public static Bytes wrap(byte[] value) {
        return Bytes.wrap(value, 0, value.length);
    }

    public static Bytes wrap(byte[] value, int offset, int length) {
        Preconditions.checkNotNull((Object)value);
        if (length == 32) {
            return new ArrayWrappingBytes32(value, offset);
        }
        return new ArrayWrappingBytes(value, offset, length);
    }

    public static Bytes wrap(Bytes ... values) {
        return ConcatenatedBytes.wrap(values);
    }

    public static Bytes concatenate(Bytes ... values) {
        int size;
        if (values.length == 0) {
            return EMPTY;
        }
        try {
            size = Arrays.stream(values).mapToInt(Bytes::size).reduce(0, Math::addExact);
        }
        catch (ArithmeticException e) {
            throw new IllegalArgumentException("Combined length of values is too long (> Integer.MAX_VALUE)");
        }
        MutableBytes result = MutableBytes.create(size);
        int offset = 0;
        for (Bytes value : values) {
            value.copyTo(result, offset);
            offset += value.size();
        }
        return result;
    }

    public static Bytes wrapBuffer(Buffer buffer) {
        Preconditions.checkNotNull((Object)buffer);
        if (buffer.length() == 0) {
            return EMPTY;
        }
        return new BufferWrappingBytes(buffer);
    }

    public static Bytes wrapBuffer(Buffer buffer, int offset, int size) {
        Preconditions.checkNotNull((Object)buffer);
        if (size == 0) {
            return EMPTY;
        }
        return new BufferWrappingBytes(buffer, offset, size);
    }

    public static Bytes wrapByteBuf(ByteBuf byteBuf) {
        Preconditions.checkNotNull((Object)byteBuf);
        if (byteBuf.capacity() == 0) {
            return EMPTY;
        }
        return new ByteBufWrappingBytes(byteBuf);
    }

    public static Bytes wrapByteBuf(ByteBuf byteBuf, int offset, int size) {
        Preconditions.checkNotNull((Object)byteBuf);
        if (size == 0) {
            return EMPTY;
        }
        return new ByteBufWrappingBytes(byteBuf, offset, size);
    }

    public static Bytes wrapByteBuffer(ByteBuffer byteBuffer) {
        Preconditions.checkNotNull((Object)byteBuffer);
        if (byteBuffer.limit() == 0) {
            return EMPTY;
        }
        return new ByteBufferWrappingBytes(byteBuffer);
    }

    public static Bytes wrapByteBuffer(ByteBuffer byteBuffer, int offset, int size) {
        Preconditions.checkNotNull((Object)byteBuffer);
        if (size == 0) {
            return EMPTY;
        }
        return new ByteBufferWrappingBytes(byteBuffer, offset, size);
    }

    public static Bytes of(byte ... bytes) {
        return Bytes.wrap(bytes);
    }

    public static Bytes of(int ... bytes) {
        byte[] result = new byte[bytes.length];
        for (int i = 0; i < bytes.length; ++i) {
            int b = bytes[i];
            Preconditions.checkArgument((b == ((byte)b & 0xFF) ? 1 : 0) != 0, (String)"%sth value %s does not fit a byte", (int)(i + 1), (int)b);
            result[i] = (byte)b;
        }
        return Bytes.wrap(result);
    }

    public static Bytes ofUnsignedShort(int value) {
        return Bytes.ofUnsignedShort(value, ByteOrder.BIG_ENDIAN);
    }

    public static Bytes ofUnsignedShort(int value, ByteOrder order) {
        Preconditions.checkArgument((value >= 0 && value <= 65535 ? 1 : 0) != 0, (String)"Value %s cannot be represented as an unsigned short (it is negative or too big)", (int)value);
        byte[] res = new byte[2];
        if (order == ByteOrder.BIG_ENDIAN) {
            res[0] = (byte)(value >> 8 & 0xFF);
            res[1] = (byte)(value & 0xFF);
        } else {
            res[0] = (byte)(value & 0xFF);
            res[1] = (byte)(value >> 8 & 0xFF);
        }
        return Bytes.wrap(res);
    }

    public static Bytes ofUnsignedInt(long value) {
        return Bytes.ofUnsignedInt(value, ByteOrder.BIG_ENDIAN);
    }

    public static Bytes ofUnsignedInt(long value, ByteOrder order) {
        Preconditions.checkArgument((value >= 0L && value <= 0xFFFFFFFFL ? 1 : 0) != 0, (String)"Value %s cannot be represented as an unsigned int (it is negative or too big)", (long)value);
        byte[] res = new byte[4];
        if (order == ByteOrder.BIG_ENDIAN) {
            res[0] = (byte)(value >> 24 & 0xFFL);
            res[1] = (byte)(value >> 16 & 0xFFL);
            res[2] = (byte)(value >> 8 & 0xFFL);
            res[3] = (byte)(value & 0xFFL);
        } else {
            res[0] = (byte)(value & 0xFFL);
            res[1] = (byte)(value >> 8 & 0xFFL);
            res[2] = (byte)(value >> 16 & 0xFFL);
            res[3] = (byte)(value >> 24 & 0xFFL);
        }
        return Bytes.wrap(res);
    }

    public static Bytes ofUnsignedLong(long value) {
        return Bytes.ofUnsignedLong(value, ByteOrder.BIG_ENDIAN);
    }

    public static Bytes ofUnsignedLong(long value, ByteOrder order) {
        byte[] res = new byte[8];
        if (order == ByteOrder.BIG_ENDIAN) {
            res[0] = (byte)(value >> 56 & 0xFFL);
            res[1] = (byte)(value >> 48 & 0xFFL);
            res[2] = (byte)(value >> 40 & 0xFFL);
            res[3] = (byte)(value >> 32 & 0xFFL);
            res[4] = (byte)(value >> 24 & 0xFFL);
            res[5] = (byte)(value >> 16 & 0xFFL);
            res[6] = (byte)(value >> 8 & 0xFFL);
            res[7] = (byte)(value & 0xFFL);
        } else {
            res[0] = (byte)(value & 0xFFL);
            res[1] = (byte)(value >> 8 & 0xFFL);
            res[2] = (byte)(value >> 16 & 0xFFL);
            res[3] = (byte)(value >> 24 & 0xFFL);
            res[4] = (byte)(value >> 32 & 0xFFL);
            res[5] = (byte)(value >> 40 & 0xFFL);
            res[6] = (byte)(value >> 48 & 0xFFL);
            res[7] = (byte)(value >> 56 & 0xFFL);
        }
        return Bytes.wrap(res);
    }

    public static Bytes minimalBytes(long value) {
        if (value == 0L) {
            return EMPTY;
        }
        int zeros = Long.numberOfLeadingZeros(value);
        int resultBytes = 8 - zeros / 8;
        byte[] result = new byte[resultBytes];
        int shift = 0;
        for (int i = 0; i < resultBytes; ++i) {
            result[resultBytes - i - 1] = (byte)(value >> shift & 0xFFL);
            shift += 8;
        }
        return Bytes.wrap(result);
    }

    public static Bytes fromHexStringLenient(CharSequence str) {
        Preconditions.checkNotNull((Object)str);
        return BytesValues.fromHexString(str, -1, true);
    }

    public static Bytes fromHexStringLenient(CharSequence str, int destinationSize) {
        Preconditions.checkNotNull((Object)str);
        Preconditions.checkArgument((destinationSize >= 0 ? 1 : 0) != 0, (String)"Invalid negative destination size %s", (int)destinationSize);
        return BytesValues.fromHexString(str, destinationSize, true);
    }

    public static Bytes fromHexString(CharSequence str) {
        Preconditions.checkNotNull((Object)str);
        return BytesValues.fromHexString(str, -1, false);
    }

    public static Bytes fromHexString(CharSequence str, int destinationSize) {
        Preconditions.checkNotNull((Object)str);
        Preconditions.checkArgument((destinationSize >= 0 ? 1 : 0) != 0, (String)"Invalid negative destination size %s", (int)destinationSize);
        return BytesValues.fromHexString(str, destinationSize, false);
    }

    public static Bytes fromBase64String(CharSequence str) {
        return Bytes.wrap(Base64.getDecoder().decode(str.toString()));
    }

    public static Bytes random(int size) {
        return Bytes.random(size, new SecureRandom());
    }

    public static Bytes random(int size, Random generator) {
        byte[] array = new byte[size];
        generator.nextBytes(array);
        return Bytes.wrap(array);
    }

    public int size();

    public byte get(int var1);

    default public int getInt(int i) {
        return this.getInt(i, ByteOrder.BIG_ENDIAN);
    }

    default public int getInt(int i, ByteOrder order) {
        int size = this.size();
        Preconditions.checkElementIndex((int)i, (int)size);
        if (i > size - 4) {
            throw new IndexOutOfBoundsException(String.format("Value of size %s has not enough bytes to read a 4 bytes int from index %s", size, i));
        }
        int value = 0;
        if (order == ByteOrder.BIG_ENDIAN) {
            value |= (this.get(i) & 0xFF) << 24;
            value |= (this.get(i + 1) & 0xFF) << 16;
            value |= (this.get(i + 2) & 0xFF) << 8;
            value |= this.get(i + 3) & 0xFF;
        } else {
            value |= (this.get(i + 3) & 0xFF) << 24;
            value |= (this.get(i + 2) & 0xFF) << 16;
            value |= (this.get(i + 1) & 0xFF) << 8;
            value |= this.get(i) & 0xFF;
        }
        return value;
    }

    default public int toInt() {
        return this.toInt(ByteOrder.BIG_ENDIAN);
    }

    default public int toInt(ByteOrder order) {
        int size = this.size();
        Preconditions.checkArgument((size <= 4 ? 1 : 0) != 0, (String)"Value of size %s has more than 4 bytes", (int)this.size());
        if (size == 0) {
            return 0;
        }
        if (order == ByteOrder.BIG_ENDIAN) {
            int i = size;
            int value = this.get(--i) & 0xFF;
            if (i == 0) {
                return value;
            }
            value |= (this.get(--i) & 0xFF) << 8;
            if (i == 0) {
                return value;
            }
            value |= (this.get(--i) & 0xFF) << 16;
            if (i == 0) {
                return value;
            }
            return value | (this.get(--i) & 0xFF) << 24;
        }
        int i = 0;
        int value = this.get(i) & 0xFF;
        if (++i == size) {
            return value;
        }
        value |= (this.get(i++) & 0xFF) << 8;
        if (i == size) {
            return value;
        }
        value |= (this.get(i++) & 0xFF) << 16;
        if (i == size) {
            return value;
        }
        return value | (this.get(i) & 0xFF) << 24;
    }

    default public boolean isEmpty() {
        return this.size() == 0;
    }

    default public long getLong(int i) {
        return this.getLong(i, ByteOrder.BIG_ENDIAN);
    }

    default public long getLong(int i, ByteOrder order) {
        int size = this.size();
        Preconditions.checkElementIndex((int)i, (int)size);
        if (i > size - 8) {
            throw new IndexOutOfBoundsException(String.format("Value of size %s has not enough bytes to read a 8 bytes long from index %s", size, i));
        }
        long value = 0L;
        if (order == ByteOrder.BIG_ENDIAN) {
            value |= ((long)this.get(i) & 0xFFL) << 56;
            value |= ((long)this.get(i + 1) & 0xFFL) << 48;
            value |= ((long)this.get(i + 2) & 0xFFL) << 40;
            value |= ((long)this.get(i + 3) & 0xFFL) << 32;
            value |= ((long)this.get(i + 4) & 0xFFL) << 24;
            value |= ((long)this.get(i + 5) & 0xFFL) << 16;
            value |= ((long)this.get(i + 6) & 0xFFL) << 8;
            value |= (long)this.get(i + 7) & 0xFFL;
        } else {
            value |= ((long)this.get(i + 7) & 0xFFL) << 56;
            value |= ((long)this.get(i + 6) & 0xFFL) << 48;
            value |= ((long)this.get(i + 5) & 0xFFL) << 40;
            value |= ((long)this.get(i + 4) & 0xFFL) << 32;
            value |= ((long)this.get(i + 3) & 0xFFL) << 24;
            value |= ((long)this.get(i + 2) & 0xFFL) << 16;
            value |= ((long)this.get(i + 1) & 0xFFL) << 8;
            value |= (long)this.get(i) & 0xFFL;
        }
        return value;
    }

    default public long toLong() {
        return this.toLong(ByteOrder.BIG_ENDIAN);
    }

    default public long toLong(ByteOrder order) {
        int size = this.size();
        Preconditions.checkArgument((size <= 8 ? 1 : 0) != 0, (String)"Value of size %s has more than 8 bytes", (int)this.size());
        if (size == 0) {
            return 0L;
        }
        if (order == ByteOrder.BIG_ENDIAN) {
            int i = size;
            long value = (long)this.get(--i) & 0xFFL;
            if (i == 0) {
                return value;
            }
            value |= ((long)this.get(--i) & 0xFFL) << 8;
            if (i == 0) {
                return value;
            }
            value |= ((long)this.get(--i) & 0xFFL) << 16;
            if (i == 0) {
                return value;
            }
            value |= ((long)this.get(--i) & 0xFFL) << 24;
            if (i == 0) {
                return value;
            }
            value |= ((long)this.get(--i) & 0xFFL) << 32;
            if (i == 0) {
                return value;
            }
            value |= ((long)this.get(--i) & 0xFFL) << 40;
            if (i == 0) {
                return value;
            }
            value |= ((long)this.get(--i) & 0xFFL) << 48;
            if (i == 0) {
                return value;
            }
            return value | ((long)this.get(--i) & 0xFFL) << 56;
        }
        int i = 0;
        long value = (long)this.get(i) & 0xFFL;
        if (++i == size) {
            return value;
        }
        value |= ((long)this.get(i) & 0xFFL) << 8;
        if (++i == size) {
            return value;
        }
        value |= ((long)this.get(i) & 0xFFL) << 16;
        if (++i == size) {
            return value;
        }
        value |= ((long)this.get(i) & 0xFFL) << 24;
        if (++i == size) {
            return value;
        }
        value |= ((long)this.get(i) & 0xFFL) << 32;
        if (++i == size) {
            return value;
        }
        value |= ((long)this.get(i) & 0xFFL) << 40;
        if (++i == size) {
            return value;
        }
        value |= ((long)this.get(i) & 0xFFL) << 48;
        if (++i == size) {
            return value;
        }
        return value | ((long)this.get(i) & 0xFFL) << 56;
    }

    default public BigInteger toBigInteger() {
        return this.toBigInteger(ByteOrder.BIG_ENDIAN);
    }

    default public BigInteger toBigInteger(ByteOrder order) {
        if (this.size() == 0) {
            return BigInteger.ZERO;
        }
        return new BigInteger(order == ByteOrder.BIG_ENDIAN ? this.toArrayUnsafe() : this.reverse().toArrayUnsafe());
    }

    default public BigInteger toUnsignedBigInteger() {
        return this.toUnsignedBigInteger(ByteOrder.BIG_ENDIAN);
    }

    default public BigInteger toUnsignedBigInteger(ByteOrder order) {
        return new BigInteger(1, order == ByteOrder.BIG_ENDIAN ? this.toArrayUnsafe() : this.reverse().toArrayUnsafe());
    }

    default public boolean isZero() {
        for (int i = this.size() - 1; i >= 0; --i) {
            if (this.get(i) == 0) continue;
            return false;
        }
        return true;
    }

    default public boolean hasLeadingZero() {
        return this.size() > 0 && (this.get(0) & 0x80) == 0;
    }

    default public int numberOfLeadingZeros() {
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            byte b = this.get(i);
            if (b == 0) continue;
            return i * 8 + Integer.numberOfLeadingZeros(b & 0xFF) - 24;
        }
        return size * 8;
    }

    default public boolean hasLeadingZeroByte() {
        return this.size() > 0 && this.get(0) == 0;
    }

    default public int numberOfLeadingZeroBytes() {
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            if (this.get(i) == 0) continue;
            return i;
        }
        return size;
    }

    default public int numberOfTrailingZeroBytes() {
        int size;
        for (int i = size = this.size(); i >= 1; --i) {
            if (this.get(i - 1) == 0) continue;
            return size - i;
        }
        return size;
    }

    default public int bitLength() {
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            byte b = this.get(i);
            if (b == 0) continue;
            return size * 8 - i * 8 - (Integer.numberOfLeadingZeros(b & 0xFF) - 24);
        }
        return 0;
    }

    default public Bytes and(Bytes other) {
        return this.and(other, MutableBytes.create(Math.max(this.size(), other.size())));
    }

    default public <T extends MutableBytes> T and(Bytes other, T result) {
        Preconditions.checkNotNull((Object)other);
        Preconditions.checkNotNull(result);
        int rSize = result.size();
        int offsetSelf = rSize - this.size();
        int offsetOther = rSize - other.size();
        for (int i = 0; i < rSize; ++i) {
            byte b1 = i < offsetSelf ? (byte)0 : this.get(i - offsetSelf);
            byte b2 = i < offsetOther ? (byte)0 : other.get(i - offsetOther);
            result.set(i, (byte)(b1 & b2));
        }
        return result;
    }

    default public Bytes or(Bytes other) {
        return this.or(other, MutableBytes.create(Math.max(this.size(), other.size())));
    }

    default public <T extends MutableBytes> T or(Bytes other, T result) {
        Preconditions.checkNotNull((Object)other);
        Preconditions.checkNotNull(result);
        int rSize = result.size();
        int offsetSelf = rSize - this.size();
        int offsetOther = rSize - other.size();
        for (int i = 0; i < rSize; ++i) {
            byte b1 = i < offsetSelf ? (byte)0 : this.get(i - offsetSelf);
            byte b2 = i < offsetOther ? (byte)0 : other.get(i - offsetOther);
            result.set(i, (byte)(b1 | b2));
        }
        return result;
    }

    default public Bytes xor(Bytes other) {
        return this.xor(other, MutableBytes.create(Math.max(this.size(), other.size())));
    }

    default public <T extends MutableBytes> T xor(Bytes other, T result) {
        Preconditions.checkNotNull((Object)other);
        Preconditions.checkNotNull(result);
        int rSize = result.size();
        int offsetSelf = rSize - this.size();
        int offsetOther = rSize - other.size();
        for (int i = 0; i < rSize; ++i) {
            byte b1 = i < offsetSelf ? (byte)0 : this.get(i - offsetSelf);
            byte b2 = i < offsetOther ? (byte)0 : other.get(i - offsetOther);
            result.set(i, (byte)(b1 ^ b2));
        }
        return result;
    }

    default public Bytes not() {
        return this.not(MutableBytes.create(this.size()));
    }

    default public <T extends MutableBytes> T not(T result) {
        Preconditions.checkNotNull(result);
        int rSize = result.size();
        int offsetSelf = rSize - this.size();
        for (int i = 0; i < rSize; ++i) {
            byte b1 = i < offsetSelf ? (byte)0 : this.get(i - offsetSelf);
            result.set(i, ~b1);
        }
        return result;
    }

    default public Bytes shiftRight(int distance) {
        return this.shiftRight(distance, MutableBytes.create(this.size()));
    }

    default public <T extends MutableBytes> T shiftRight(int distance, T result) {
        Preconditions.checkNotNull(result);
        int rSize = result.size();
        int offsetSelf = rSize - this.size();
        int d = distance / 8;
        int s = distance % 8;
        int resIdx = rSize - 1;
        for (int i = rSize - 1 - d; i >= 0; --i) {
            byte res;
            if (i < offsetSelf) {
                res = 0;
            } else {
                int selfIdx = i - offsetSelf;
                int leftSide = (this.get(selfIdx) & 0xFF) >>> s;
                int rightSide = selfIdx == 0 ? 0 : this.get(selfIdx - 1) << 8 - s;
                res = (byte)(leftSide | rightSide);
            }
            result.set(resIdx--, res);
        }
        while (resIdx >= 0) {
            result.set(resIdx, (byte)0);
            --resIdx;
        }
        return result;
    }

    default public Bytes shiftLeft(int distance) {
        return this.shiftLeft(distance, MutableBytes.create(this.size()));
    }

    default public <T extends MutableBytes> T shiftLeft(int distance, T result) {
        Preconditions.checkNotNull(result);
        int size = this.size();
        int rSize = result.size();
        int offsetSelf = rSize - size;
        int d = distance / 8;
        int s = distance % 8;
        int resIdx = 0;
        for (int i = d; i < rSize; ++i) {
            byte res;
            if (i < offsetSelf) {
                res = 0;
            } else {
                int selfIdx = i - offsetSelf;
                int leftSide = this.get(selfIdx) << s;
                int rightSide = selfIdx == size - 1 ? 0 : (this.get(selfIdx + 1) & 0xFF) >>> 8 - s;
                res = (byte)(leftSide | rightSide);
            }
            result.set(resIdx++, res);
        }
        while (resIdx < rSize) {
            result.set(resIdx, (byte)0);
            ++resIdx;
        }
        return result;
    }

    default public Bytes slice(int i) {
        if (i == 0) {
            return this;
        }
        int size = this.size();
        if (i >= size) {
            return EMPTY;
        }
        return this.slice(i, size - i);
    }

    public Bytes slice(int var1, int var2);

    public Bytes copy();

    public MutableBytes mutableCopy();

    default public void copyTo(MutableBytes destination) {
        Preconditions.checkNotNull((Object)destination);
        Preconditions.checkArgument((destination.size() == this.size() ? 1 : 0) != 0, (String)"Cannot copy %s bytes to destination of non-equal size %s", (int)this.size(), (int)destination.size());
        this.copyTo(destination, 0);
    }

    default public void copyTo(MutableBytes destination, int destinationOffset) {
        Preconditions.checkNotNull((Object)destination);
        int size = this.size();
        if (size == 0) {
            return;
        }
        Preconditions.checkElementIndex((int)destinationOffset, (int)destination.size());
        Preconditions.checkArgument((destination.size() - destinationOffset >= size ? 1 : 0) != 0, (String)"Cannot copy %s bytes, destination has only %s bytes from index %s", (Object)size, (Object)(destination.size() - destinationOffset), (Object)destinationOffset);
        for (int i = 0; i < size; ++i) {
            destination.set(destinationOffset + i, this.get(i));
        }
    }

    default public void appendTo(ByteBuffer byteBuffer) {
        Preconditions.checkNotNull((Object)byteBuffer);
        for (int i = 0; i < this.size(); ++i) {
            byteBuffer.put(this.get(i));
        }
    }

    default public void appendTo(Buffer buffer) {
        Preconditions.checkNotNull((Object)buffer);
        for (int i = 0; i < this.size(); ++i) {
            buffer.appendByte(this.get(i));
        }
    }

    default public <T extends Appendable> T appendHexTo(T appendable) throws IOException {
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            byte b = this.get(i);
            appendable.append(AbstractBytes.HEX_CODE[b >> 4 & 0xF]);
            appendable.append(AbstractBytes.HEX_CODE[b & 0xF]);
        }
        return appendable;
    }

    default public int commonPrefixLength(Bytes other) {
        int i;
        Preconditions.checkNotNull((Object)other);
        int ourSize = this.size();
        int otherSize = other.size();
        for (i = 0; i < ourSize && i < otherSize && this.get(i) == other.get(i); ++i) {
        }
        return i;
    }

    default public Bytes commonPrefix(Bytes other) {
        return this.slice(0, this.commonPrefixLength(other));
    }

    default public Bytes trimLeadingZeros() {
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            if (this.get(i) == 0) continue;
            return this.slice(i);
        }
        return EMPTY;
    }

    default public void update(MessageDigest digest) {
        Preconditions.checkNotNull((Object)digest);
        digest.update(this.toArrayUnsafe());
    }

    default public Bytes reverse() {
        byte[] reverse = new byte[this.size()];
        for (int i = 0; i < this.size(); ++i) {
            reverse[this.size() - i - 1] = this.get(i);
        }
        return Bytes.wrap(reverse);
    }

    default public byte[] toArray() {
        int size = this.size();
        byte[] array = new byte[size];
        for (int i = 0; i < size; ++i) {
            array[i] = this.get(i);
        }
        return array;
    }

    default public byte[] toArrayUnsafe() {
        return this.toArray();
    }

    public String toString();

    default public String toHexString() {
        try {
            return this.appendHexTo(new StringBuilder("0x")).toString();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    default public String toShortHexString() {
        int i;
        StringBuilder hex;
        try {
            hex = this.appendHexTo(new StringBuilder());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        for (i = 0; i < hex.length() && hex.charAt(i) == '0'; ++i) {
        }
        return "0x" + hex.substring(i);
    }

    default public String toBase64String() {
        return Base64.getEncoder().encodeToString(this.toArrayUnsafe());
    }
}

