/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.bytes;

import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import org.apache.tuweni.bytes.ByteBufWrappingBytes;
import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.bytes.MutableBytes;

final class MutableByteBufWrappingBytes
extends ByteBufWrappingBytes
implements MutableBytes {
    MutableByteBufWrappingBytes(ByteBuf buffer) {
        super(buffer);
    }

    MutableByteBufWrappingBytes(ByteBuf buffer, int offset, int length) {
        super(buffer, offset, length);
    }

    @Override
    public void clear() {
        this.byteBuf.setZero(0, this.byteBuf.capacity());
    }

    @Override
    public void set(int i, byte b) {
        this.byteBuf.setByte(i, (int)b);
    }

    @Override
    public void setInt(int i, int value) {
        this.byteBuf.setInt(i, value);
    }

    @Override
    public void setLong(int i, long value) {
        this.byteBuf.setLong(i, value);
    }

    @Override
    public MutableBytes mutableSlice(int i, int length) {
        int size = this.size();
        if (i == 0 && length == size) {
            return this;
        }
        if (length == 0) {
            return MutableBytes.EMPTY;
        }
        Preconditions.checkElementIndex((int)i, (int)size);
        Preconditions.checkArgument((i + length <= size ? 1 : 0) != 0, (String)"Provided length %s is too big: the value has size %s and has only %s bytes from %s", (Object)length, (Object)size, (Object)(size - i), (Object)i);
        return new MutableByteBufWrappingBytes(this.byteBuf.slice(i, length));
    }

    @Override
    public Bytes copy() {
        return Bytes.wrap(this.toArray());
    }

    @Override
    public MutableBytes mutableCopy() {
        return MutableBytes.wrap(this.toArray());
    }
}

