/*
 * Decompiled with CFR 0.152.
 */
package sample;

import java.util.ArrayList;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.tuscany.sca.binding.websocket.runtime.WebsocketBindingCallback;
import org.apache.tuscany.sca.binding.websocket.runtime.WebsocketStatus;
import org.oasisopen.sca.ComponentContext;
import org.oasisopen.sca.annotation.Context;
import org.oasisopen.sca.annotation.Scope;
import org.oasisopen.sca.annotation.Service;
import sample.ChatService;

@Service(value={ChatService.class})
@Scope(value="COMPOSITE")
public class ChatServiceImpl
implements ChatService {
    @Context
    protected ComponentContext context;
    private CopyOnWriteArrayList<WebsocketBindingCallback> clients = new CopyOnWriteArrayList();

    public void postMessage(String user, String message) {
        for (WebsocketBindingCallback callback : new ArrayList(this.clients)) {
            WebsocketStatus status = callback.sendMessage((Object)(user + ": " + message));
            if (status != WebsocketStatus.CLOSED) continue;
            this.clients.remove(callback);
        }
    }

    public void register() {
        this.clients.add(this.context.getRequestContext().getCallback());
    }
}

