/*
 * Decompiled with CFR 0.152.
 */
package com.workingdogs.village;

import com.workingdogs.village.Column;
import com.workingdogs.village.DataSetException;
import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Enumeration;
import java.util.Hashtable;

public final class Schema {
    private String tableName = "";
    private String columnsAttribute = null;
    private int numberOfColumns = 0;
    private Column[] columns;
    private static Hashtable schemaCache = new Hashtable();
    private Hashtable tableHash = null;
    private boolean singleTable = true;

    public Schema schema(Connection conn, String tableName) throws SQLException, DataSetException {
        return this.schema(conn, tableName, "*");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Schema schema(Connection conn, String tableName, String columnsAttribute) throws SQLException, DataSetException {
        if (columnsAttribute == null) {
            columnsAttribute = "*";
        }
        Statement stmt = null;
        try {
            String keyValue = conn.getMetaData().getURL() + tableName;
            Schema tableSchema = (Schema)schemaCache.get(keyValue);
            if (tableSchema == null) {
                String sql = "SELECT " + columnsAttribute + " FROM " + tableName + " WHERE 1 = -1";
                stmt = conn.createStatement();
                ResultSet rs = stmt.executeQuery(sql);
                if (rs != null) {
                    tableSchema = new Schema();
                    tableSchema.setTableName(tableName);
                    tableSchema.setAttributes(columnsAttribute);
                    tableSchema.populate(rs.getMetaData(), tableName);
                    schemaCache.put(keyValue, tableSchema);
                } else {
                    throw new DataSetException("Couldn't retrieve schema for " + tableName);
                }
            }
            Schema schema = tableSchema;
            return schema;
        }
        finally {
            if (stmt != null) {
                stmt.close();
            }
        }
    }

    void appendTableName(String app) {
        this.tableName = this.tableName + " " + app;
    }

    public String attributes() {
        return this.columnsAttribute;
    }

    public Column column(int i) throws DataSetException {
        if (i == 0) {
            throw new DataSetException("Columns are 1 based");
        }
        if (i > this.numberOfColumns) {
            throw new DataSetException("There are only " + this.numberOfColumns() + " available!");
        }
        try {
            return this.columns[i];
        }
        catch (Exception e) {
            throw new DataSetException("Column number: " + this.numberOfColumns() + " does not exist!");
        }
    }

    public Column column(String colName) throws DataSetException {
        return this.column(this.index(colName));
    }

    public Column getColumn(String colName) throws DataSetException {
        int dot = colName.indexOf(46);
        if (dot > 0) {
            String table = colName.substring(0, dot);
            String col = colName.substring(dot + 1);
            return this.getColumn(table, col);
        }
        return this.column(this.index(colName));
    }

    public Column getColumn(String tableName, String colName) throws DataSetException {
        return (Column)((Hashtable)this.tableHash.get(tableName)).get(colName);
    }

    Column[] getColumns() {
        return this.columns;
    }

    public String getTableName() throws DataSetException {
        if (this.singleTable) {
            return this.tableName;
        }
        throw new DataSetException("This schema represents several tables.");
    }

    public String[] getAllTableNames() {
        Enumeration e = this.tableHash.keys();
        String[] tableNames = new String[this.tableHash.size()];
        int i = 0;
        while (e.hasMoreElements()) {
            tableNames[i] = (String)e.nextElement();
            ++i;
        }
        return tableNames;
    }

    public int index(String colName) throws DataSetException {
        int dot = colName.indexOf(46);
        if (dot > 0) {
            String table = colName.substring(0, dot);
            String col = colName.substring(dot + 1);
            return this.index(table, col);
        }
        for (int i = 1; i <= this.numberOfColumns(); ++i) {
            if (!this.columns[i].name().equalsIgnoreCase(colName)) continue;
            return i;
        }
        throw new DataSetException("Column name: " + colName + " does not exist!");
    }

    public int index(String tableName, String colName) throws DataSetException {
        for (int i = 1; i <= this.numberOfColumns(); ++i) {
            if (!this.columns[i].name().equalsIgnoreCase(colName) || !this.columns[i].getTableName().equalsIgnoreCase(tableName)) continue;
            return i;
        }
        throw new DataSetException("Column name: " + colName + " does not exist!");
    }

    public boolean isSingleTable() {
        return this.singleTable;
    }

    public int numberOfColumns() {
        return this.numberOfColumns;
    }

    void populate(ResultSetMetaData meta, String tableName) throws SQLException, DataSetException {
        int i;
        this.numberOfColumns = meta.getColumnCount();
        this.columns = new Column[this.numberOfColumns() + 1];
        for (i = 1; i <= this.numberOfColumns(); ++i) {
            Column col = new Column();
            col.populate(meta, i, tableName);
            this.columns[i] = col;
            if (i <= 1 || col.getTableName().equalsIgnoreCase(this.columns[i - 1].getTableName())) continue;
            this.singleTable = false;
        }
        if (this.singleTable) {
            if (tableName != null && tableName.length() > 0) {
                this.setTableName(tableName);
            } else {
                try {
                    this.setTableName(meta.getTableName(1));
                }
                catch (Exception e) {
                    this.setTableName("");
                }
            }
        } else {
            this.tableHash = new Hashtable((int)(1.25 * (double)this.numberOfColumns + 1.0));
            for (i = 1; i <= this.numberOfColumns(); ++i) {
                if (this.tableHash.containsKey(this.columns[i].getTableName())) {
                    ((Hashtable)this.tableHash.get(this.columns[i].getTableName())).put(this.columns[i].name(), this.columns[i]);
                    continue;
                }
                Hashtable<String, Column> columnHash = new Hashtable<String, Column>((int)(1.25 * (double)this.numberOfColumns + 1.0));
                columnHash.put(this.columns[i].name(), this.columns[i]);
                this.tableHash.put(this.columns[i].getTableName(), columnHash);
            }
        }
    }

    void setAttributes(String attributes) {
        this.columnsAttribute = attributes;
    }

    void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String tableName() throws DataSetException {
        return this.getTableName();
    }

    public String toString() {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        PrintWriter out = new PrintWriter(bout);
        out.print('{');
        for (int i = 1; i <= this.numberOfColumns; ++i) {
            out.print('\'');
            if (!this.singleTable) {
                out.print(this.columns[i].getTableName() + '.');
            }
            out.print(this.columns[i].name() + '\'');
            if (i >= this.numberOfColumns) continue;
            out.print(',');
        }
        out.print('}');
        out.flush();
        return bout.toString();
    }
}

