/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ziplock;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.ziplock.Files;
import org.apache.ziplock.IO;
import org.apache.ziplock.Join;

public class Archive {
    final Map<String, String> manifest = new HashMap<String, String>();
    final Map<String, byte[]> entries = new HashMap<String, byte[]>();

    public static Archive archive() {
        return new Archive();
    }

    public Archive manifest(String key, Object value) {
        this.manifest.put(key, value.toString());
        return this;
    }

    public Archive manifest(String key, Class value) {
        this.manifest.put(key, value.getName());
        return this;
    }

    public Archive copyTo(String path, File file) {
        if (file.isDirectory()) {
            for (File child : file.listFiles()) {
                this.copyTo(path + "/" + child.getName(), child);
            }
        } else {
            try {
                this.entries.put(path, IO.readBytes(file));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return this;
    }

    public Archive addTo(String path, Class<?> clazz) {
        try {
            int length;
            String name = clazz.getName().replace('.', '/') + ".class";
            URL resource = this.getClass().getClassLoader().getResource(name);
            BufferedInputStream from = new BufferedInputStream(resource.openStream());
            ByteArrayOutputStream to = new ByteArrayOutputStream();
            byte[] buffer = new byte[1024];
            while ((length = ((InputStream)from).read(buffer)) != -1) {
                to.write(buffer, 0, length);
            }
            to.flush();
            if (path != null && path.length() != 0) {
                this.entries.put(path + "/" + name, to.toByteArray());
            } else {
                this.entries.put(name, to.toByteArray());
            }
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        return this;
    }

    public Archive add(Class<?> clazz) {
        return this.addTo(null, clazz);
    }

    public File toJar() throws IOException {
        return this.toJar("archive-", ".jar");
    }

    public File toJar(String prefix, String suffix) throws IOException {
        File file = File.createTempFile(prefix, suffix);
        file.deleteOnExit();
        ZipOutputStream out = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(file)));
        for (Map.Entry<String, byte[]> entry : this.entries().entrySet()) {
            out.putNextEntry(new ZipEntry(entry.getKey()));
            out.write(entry.getValue());
        }
        out.close();
        return file;
    }

    public File asJar() {
        try {
            return this.toJar();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public File asJar(String prefix, String suffix) {
        try {
            return this.toJar(prefix, suffix);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public File toDir() throws IOException {
        File classpath = Files.tmpdir();
        for (Map.Entry<String, byte[]> entry : this.entries().entrySet()) {
            String key = entry.getKey().replace('/', File.separatorChar);
            File file = new File(classpath, key);
            File d = file.getParentFile();
            if (!d.exists() && !d.mkdirs()) {
                throw new IllegalStateException("Cannot Make Directory: " + d.getAbsolutePath());
            }
            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(file));
            out.write(entry.getValue());
            out.close();
        }
        return classpath;
    }

    public File asDir() {
        try {
            return this.toDir();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private HashMap<String, byte[]> entries() {
        HashMap<String, byte[]> entries = new HashMap<String, byte[]>(this.entries);
        entries.put("META-INF/MANIFEST.MF", this.buildManifest().getBytes());
        return entries;
    }

    private String buildManifest() {
        return Join.join("\r\n", new Join.NameCallback<Map.Entry<String, String>>(){

            @Override
            public String getName(Map.Entry<String, String> entry) {
                return entry.getKey() + ": " + entry.getValue();
            }
        }, this.manifest.entrySet());
    }
}

