/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomee.embedded.junit;

import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.openejb.util.NetworkUtil;
import org.apache.tomee.embedded.Configuration;
import org.apache.tomee.embedded.Container;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class TomEEEmbeddedRule
implements TestRule {
    private final Configuration configuration;
    private final File docBase;
    private boolean resetSystemProperties = true;
    private final String context;
    private final Collection<Object> injects = new LinkedList<Object>();

    public TomEEEmbeddedRule() {
        this(new Configuration().http(NetworkUtil.getNextAvailablePort()).dir(TomEEEmbeddedRule.autoDir()), "");
    }

    public TomEEEmbeddedRule(Configuration configuration, String context) {
        this.configuration = configuration;
        this.context = context;
        File mvnDocBase = new File("src/main/webapp");
        this.docBase = mvnDocBase.isDirectory() ? mvnDocBase : null;
    }

    public TomEEEmbeddedRule(Configuration configuration, String context, File docBase) {
        this.configuration = configuration;
        this.docBase = docBase;
        this.context = context;
    }

    public TomEEEmbeddedRule injectOn(Object instance) {
        this.injects.add(instance);
        return this;
    }

    public TomEEEmbeddedRule resetSystemPropertiesAfter(boolean value) {
        this.resetSystemProperties = value;
        return this;
    }

    public TomEEEmbeddedRule stopInjectionOn(Object instance) {
        this.injects.remove(instance);
        return this;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public int getPort() {
        return this.configuration.getHttpPort();
    }

    public Statement apply(final Statement statement, Description description) {
        if (this.configuration.getDir() == null) {
            this.configuration.dir(TomEEEmbeddedRule.autoDir());
        }
        return new Statement(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void evaluate() throws Throwable {
                Properties properties = new Properties();
                if (TomEEEmbeddedRule.this.resetSystemProperties) {
                    properties.putAll((Map<?, ?>)System.getProperties());
                }
                try (Container container = new Container(TomEEEmbeddedRule.this.configuration).deployClasspathAsWebApp(TomEEEmbeddedRule.this.context, TomEEEmbeddedRule.this.docBase, TomEEEmbeddedRule.this.toCallers(), new String[0]);){
                    for (Object o : TomEEEmbeddedRule.this.injects) {
                        container.inject(o);
                    }
                    statement.evaluate();
                }
                finally {
                    if (TomEEEmbeddedRule.this.resetSystemProperties) {
                        System.getProperties().clear();
                        System.getProperties().putAll((Map<?, ?>)properties);
                    }
                }
            }
        };
    }

    private List<String> toCallers() {
        if (this.injects.isEmpty()) {
            return null;
        }
        HashSet<String> callers = new HashSet<String>();
        for (Object o : this.injects) {
            callers.add(o.getClass().getName());
        }
        return new LinkedList<String>(callers);
    }

    private static String autoDir() {
        for (String test : Arrays.asList("target", "../target", "workdir")) {
            File dir = new File(test);
            if (!dir.isDirectory()) continue;
            return new File(dir, "tomee-embedded_" + System.identityHashCode(test)).getAbsolutePath();
        }
        return null;
    }
}

