/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.tck.impl;

import jakarta.ejb.EJBException;
import jakarta.ejb.embeddable.EJBContainer;
import jakarta.validation.ValidationException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.Flushable;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.apache.openejb.OpenEJB;
import org.apache.openejb.assembler.classic.Assembler;
import org.apache.openejb.cdi.ThreadSingletonServiceImpl;
import org.apache.openejb.loader.IO;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.tck.OpenEJBTckDeploymentRuntimeException;
import org.apache.openejb.tck.util.ZipUtil;
import org.apache.openejb.util.SetAccessible;
import org.jboss.testharness.api.DeploymentException;
import org.jboss.testharness.impl.packaging.Resource;
import org.jboss.testharness.impl.packaging.Resources;
import org.jboss.testharness.impl.packaging.ear.EjbJarXml;
import org.jboss.testharness.impl.packaging.ear.PersistenceXml;
import org.jboss.testharness.impl.packaging.jsr303.ValidationXml;
import org.jboss.testharness.spi.Containers;

public class ContainersImpl
implements Containers {
    private static String stuck;
    private Exception exception;
    private EJBContainer container;
    private ClassLoader originalClassLoader;

    public boolean deploy(InputStream archive, String name) {
        if (!OpenEJB.isInitialized()) {
            stuck = name;
        } else {
            System.out.println("STUCK " + stuck);
        }
        this.exception = null;
        Assembler assembler = (Assembler)SystemInstance.get().getComponent(Assembler.class);
        ThreadSingletonServiceImpl.exit(null);
        if (assembler != null) {
            assembler.destroy();
        }
        try {
            File file = this.writeToFile(archive, name);
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("jakarta.ejb.embeddable.modules", file);
            map.put("jakarta.ejb.embeddable.appName", name);
            this.originalClassLoader = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(new URLClassLoader(new URL[]{file.toURI().toURL()}, this.originalClassLoader));
            this.container = EJBContainer.createEJBContainer(map);
        }
        catch (Exception e) {
            this.exception = e instanceof EJBException && e.getCause() instanceof ValidationException ? (Exception)ValidationException.class.cast(e.getCause()) : e;
            return false;
        }
        return true;
    }

    private void dump(Object o) {
        try {
            Class<?> clazz = o.getClass();
            for (Field field : clazz.getDeclaredFields()) {
                SetAccessible.on((AccessibleObject)field);
                if (!Collection.class.isAssignableFrom(field.getType())) continue;
                Collection collection = (Collection)field.get(o);
                System.out.println(field.getName() + "\t= " + collection.size());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private URL getResource(Class clazz, String path) {
        String resourcePath = clazz.getPackage().getName().replace(".", "/") + "/" + path;
        return clazz.getClassLoader().getResource(resourcePath);
    }

    public static void main(String[] args) throws IOException {
        new ContainersImpl().memoryMappedFile();
        System.out.println();
    }

    public void memoryMappedFile() throws IOException {
        FileChannel rwChannel = new RandomAccessFile(new File("/tmp/memory-mapped.txt"), "rw").getChannel();
        byte[] bytes = "hello world".getBytes();
        MappedByteBuffer writeonlybuffer = rwChannel.map(FileChannel.MapMode.READ_WRITE, 0L, bytes.length);
        writeonlybuffer.put(bytes);
        ((ByteBuffer)writeonlybuffer).compact();
    }

    private File writeToFile2(InputStream archive, String name) throws IOException {
        int i;
        File file;
        try {
            file = File.createTempFile("deploy", "-" + name);
        }
        catch (Throwable e) {
            File tmp = new File("tmp");
            if (!tmp.exists() && !tmp.mkdirs()) {
                throw new IOException("Failed to create local tmp directory: " + tmp.getAbsolutePath());
            }
            file = File.createTempFile("deploy", "-" + name, tmp);
        }
        FileOutputStream outputStream = new FileOutputStream(file);
        while ((i = archive.read()) != -1) {
            outputStream.write(i);
        }
        outputStream.close();
        return file;
    }

    /*
     * WARNING - void declaration
     */
    private File writeToFile(InputStream archive, String name) throws IOException {
        File file;
        try {
            file = File.createTempFile("deploy", "-" + name);
        }
        catch (Throwable e) {
            File tmp = new File("tmp");
            if (!tmp.exists() && !tmp.mkdirs()) {
                throw new IOException("Failed to create local tmp directory: " + tmp.getAbsolutePath());
            }
            file = File.createTempFile("deploy", "-" + name, tmp);
        }
        file.deleteOnExit();
        try {
            Object entry;
            Resource resourceAnn;
            Resource[] resource;
            URL resource2;
            URL resource22;
            HashMap<String, Object> resources = new HashMap<String, Object>();
            Class<?> clazz = this.getClass().getClassLoader().loadClass(name.replace(".jar", ""));
            if (clazz.isAnnotationPresent(EjbJarXml.class) && (resource22 = this.getResource(clazz, clazz.getAnnotation(EjbJarXml.class).value())) != null) {
                resources.put("META-INF/ejb-jar.xml", resource22);
            }
            if (clazz.isAnnotationPresent(PersistenceXml.class) && (resource2 = this.getResource(clazz, clazz.getAnnotation(PersistenceXml.class).value())) != null) {
                resources.put("META-INF/persistence.xml", resource2);
            }
            if (clazz.isAnnotationPresent(ValidationXml.class)) {
                String path = clazz.getAnnotation(ValidationXml.class).value();
                if (path.contains(".jar")) {
                    path = path.substring(path.indexOf("!") + 2);
                }
                if ((resource = this.getResource(clazz, path)) != null) {
                    resources.put("META-INF/validation.xml", resource);
                } else {
                    throw new OpenEJBTckDeploymentRuntimeException("can't find validation descriptor file " + path);
                }
            }
            if (clazz.isAnnotationPresent(Resource.class) && (resource = this.getResource(clazz, (resourceAnn = clazz.getAnnotation(Resource.class)).source())) != null) {
                resources.put(resourceAnn.destination().replaceFirst("WEB-INF/classes/", ""), resource);
            }
            if (clazz.isAnnotationPresent(Resources.class)) {
                Resources resourcesAnn = clazz.getAnnotation(Resources.class);
                for (Resource resourceAnn2 : resourcesAnn.value()) {
                    URL uRL = this.getResource(clazz, resourceAnn2.source());
                    if (uRL == null) continue;
                    resources.put(resourceAnn2.destination().replaceFirst("WEB-INF/classes/", ""), uRL);
                }
            }
            boolean isJar = name.endsWith(".jar");
            ZipInputStream zin = new ZipInputStream(archive);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(524288);
            ZipOutputStream zout = new ZipOutputStream(byteArrayOutputStream);
            while ((entry = zin.getNextEntry()) != null) {
                void var11_20;
                String string = ((ZipEntry)entry).getName();
                if (isJar && string.startsWith("WEB-INF/classes/")) {
                    String string2 = string.replaceFirst("WEB-INF/classes/", "");
                }
                InputStream src = zin;
                if (resources.containsKey(var11_20)) {
                    src = IO.read((URL)((URL)resources.get(var11_20)));
                }
                resources.remove(var11_20);
                zout.putNextEntry(new ZipEntry((String)var11_20));
                ZipUtil.copy(src, zout);
            }
            for (Map.Entry entry2 : resources.entrySet()) {
                zout.putNextEntry(new ZipEntry((String)entry2.getKey()));
                InputStream in = IO.read((URL)((URL)entry2.getValue()));
                ZipUtil.copy(in, zout);
                in.close();
            }
            if (System.getProperty("force.deployment") != null && !resources.containsKey("META-INF/beans.xml")) {
                zout.putNextEntry(new ZipEntry("META-INF/beans.xml"));
                ByteArrayInputStream in = new ByteArrayInputStream("<beans />".getBytes());
                ZipUtil.copy(in, zout);
                ((InputStream)in).close();
            }
            ContainersImpl.close(zin);
            ContainersImpl.close(zout);
            this.writeToFile(file, byteArrayOutputStream);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return file;
    }

    private void writeToFile(File file, ByteArrayOutputStream byteArrayOutputStream) throws IOException {
        byte[] bytes = byteArrayOutputStream.toByteArray();
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        fileOutputStream.write(bytes);
        fileOutputStream.close();
    }

    public static void close(Closeable closeable) throws IOException {
        if (closeable == null) {
            return;
        }
        try {
            if (closeable instanceof Flushable) {
                ((Flushable)((Object)closeable)).flush();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            closeable.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public DeploymentException getDeploymentException() {
        return new DeploymentException(this.exception.getLocalizedMessage(), (Throwable)this.exception);
    }

    public void undeploy(String name) {
        if (this.container != null) {
            this.container.close();
        }
        if (this.originalClassLoader != null) {
            Thread.currentThread().setContextClassLoader(this.originalClassLoader);
        }
    }

    public void setup() throws IOException {
    }

    public void cleanup() throws IOException {
    }
}

