/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval.jsr.xml;

import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.validation.ValidationException;
import javax.validation.spi.ConfigurationState;
import org.apache.bval.jsr.ApacheValidatorFactory;
import org.apache.bval.jsr.metadata.MetadataBuilder;
import org.apache.bval.jsr.metadata.MetadataSource;
import org.apache.bval.jsr.metadata.ValidatorMappingProvider;
import org.apache.bval.jsr.metadata.XmlBuilder;
import org.apache.bval.jsr.metadata.XmlValidationMappingProvider;
import org.apache.bval.jsr.xml.ConstraintDefinitionType;
import org.apache.bval.jsr.xml.ConstraintMappingsType;
import org.apache.bval.jsr.xml.SchemaManager;
import org.apache.bval.jsr.xml.ValidatedByType;
import org.apache.bval.jsr.xml.ValidationMappingParser$org_apache_bval_util_reflection_Reflection$$loaderFromThreadOrClass$$Ljava_lang_Class$_ACTION;
import org.apache.bval.jsr.xml.ValidationMappingParser$org_apache_bval_util_reflection_Reflection$$toClass$$Ljava_lang_String$Ljava_lang_ClassLoader$_ACTION;
import org.apache.bval.jsr.xml.ValidationMappingParser$org_apache_bval_util_reflection_Reflection$$toClass$$Ljava_lang_String$ZLjava_lang_ClassLoader$_ACTION;
import org.apache.bval.util.Exceptions;
import org.apache.bval.util.Validate;
import org.apache.bval.util.reflection.Reflection;
import org.apache.commons.weaver.privilizer.Privileged;
import org.apache.commons.weaver.privilizer.Privilized;
import org.apache.commons.weaver.privilizer.Privilizing;
import org.xml.sax.InputSource;

@Privilizing(value={@Privilizing.CallTo(value=Reflection.class)})
@Privilized(value="DYNAMIC")
public class ValidationMappingParser
implements MetadataSource {
    private static final SchemaManager SCHEMA_MANAGER;
    private ApacheValidatorFactory validatorFactory;

    @Override
    public void initialize(ApacheValidatorFactory validatorFactory) {
        this.validatorFactory = Validate.notNull(validatorFactory);
    }

    @Override
    public void process(ConfigurationState configurationState, Consumer<ValidatorMappingProvider> addValidatorMappingProvider, BiConsumer<Class<?>, MetadataBuilder.ForBean<?>> addBuilder) {
        Validate.validState(this.validatorFactory != null, "validatorFactory unknown", new Object[0]);
        if (configurationState.isIgnoreXmlConfiguration()) {
            return;
        }
        HashSet beanTypes = new HashSet();
        for (InputStream xmlStream : configurationState.getMappingStreams()) {
            ConstraintMappingsType mapping = this.parseXmlMappings(xmlStream);
            Optional.of(mapping).map(this::toMappingProvider).ifPresent(addValidatorMappingProvider);
            Map<Class<?>, MetadataBuilder.ForBean<?>> builders = new XmlBuilder(this.validatorFactory, mapping).forBeans();
            if (Collections.disjoint(beanTypes, builders.keySet())) {
                builders.forEach(addBuilder::accept);
                beanTypes.addAll(builders.keySet());
                continue;
            }
            Exceptions.raise(ValidationException::new, builders.keySet().stream().filter(beanTypes::contains).map(Class::getName).collect(Collectors.joining("bean classes specified multiple times for XML validation mapping: [", "; ", "]")), new Object[0]);
        }
    }

    private ConstraintMappingsType parseXmlMappings(InputStream in) {
        try {
            ConstraintMappingsType constraintMappingsType = SCHEMA_MANAGER.unmarshal(new InputSource(in), ConstraintMappingsType.class);
            return constraintMappingsType;
        }
        catch (Exception e) {
            throw new ValidationException("Failed to parse XML deployment descriptor file.", (Throwable)e);
        }
        finally {
            try {
                in.reset();
            }
            catch (IOException iOException) {}
        }
    }

    private ValidatorMappingProvider toMappingProvider(ConstraintMappingsType mapping) {
        if (mapping.getConstraintDefinition().isEmpty()) {
            return null;
        }
        HashMap<Class<? extends Annotation>, ValidatedByType> validatorMappings = new HashMap<Class<? extends Annotation>, ValidatedByType>();
        for (ConstraintDefinitionType constraintDefinition : mapping.getConstraintDefinition()) {
            String annotationClassName = constraintDefinition.getAnnotation();
            Class<?> clazz = this.loadClass(annotationClassName, mapping.getDefaultPackage());
            Exceptions.raiseUnless(clazz.isAnnotation(), ValidationException::new, "%s is not an annotation", annotationClassName);
            Class<Annotation> annotationClass = clazz.asSubclass(Annotation.class);
            Exceptions.raiseIf(validatorMappings.containsKey(annotationClass), ValidationException::new, "XML constraint validator(s) for %s already configured.", annotationClass);
            validatorMappings.put(annotationClass, constraintDefinition.getValidatedBy());
        }
        return new XmlValidationMappingProvider(validatorMappings, cn -> this.toQualifiedClassName((String)cn, mapping.getDefaultPackage()));
    }

    private Class<?> loadClass(String className, String defaultPackage) {
        String fqn = this.toQualifiedClassName(className, defaultPackage);
        try {
            return ValidationMappingParser.org_apache_bval_util_reflection_Reflection$$toClass(fqn, ValidationMappingParser.org_apache_bval_util_reflection_Reflection$$loaderFromThreadOrClass(ValidationMappingParser.class));
        }
        catch (ClassNotFoundException ex) {
            throw Exceptions.create(ValidationException::new, ex, "Unable to load class: %s", fqn);
        }
    }

    @Privileged
    private static /* synthetic */ ClassLoader org_apache_bval_util_reflection_Reflection$$loaderFromThreadOrClass(Class<?> clazz) {
        if (!(System.getSecurityManager() != null)) {
            return ValidationMappingParser.__privileged_org_apache_bval_util_reflection_Reflection$$loaderFromThreadOrClass(clazz);
        }
        return (ClassLoader)AccessController.doPrivileged(new ValidationMappingParser$org_apache_bval_util_reflection_Reflection$$loaderFromThreadOrClass$$Ljava_lang_Class$_ACTION(clazz));
    }

    static /* synthetic */ ClassLoader __privileged_access$0(Class clazz) {
        return ValidationMappingParser.__privileged_org_apache_bval_util_reflection_Reflection$$loaderFromThreadOrClass(clazz);
    }

    private static /* synthetic */ ClassLoader __privileged_org_apache_bval_util_reflection_Reflection$$loaderFromThreadOrClass(Class<?> clazz) {
        return Optional.of(Thread.currentThread()).map(Thread::getContextClassLoader).orElseGet(() -> Validate.notNull(clazz).getClassLoader());
    }

    @Privileged
    private static /* synthetic */ Class<?> org_apache_bval_util_reflection_Reflection$$toClass(String string, boolean bl, ClassLoader classLoader) throws ClassNotFoundException {
        if (!(System.getSecurityManager() != null)) {
            return ValidationMappingParser.__privileged_org_apache_bval_util_reflection_Reflection$$toClass(string, bl, classLoader);
        }
        try {
            return (Class)AccessController.doPrivileged(new ValidationMappingParser$org_apache_bval_util_reflection_Reflection$$toClass$$Ljava_lang_String$ZLjava_lang_ClassLoader$_ACTION(string, bl, classLoader));
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw privilegedActionException.getException();
        }
    }

    static /* synthetic */ Class __privileged_access$1(String string, boolean bl, ClassLoader classLoader) throws Exception {
        return ValidationMappingParser.__privileged_org_apache_bval_util_reflection_Reflection$$toClass(string, bl, classLoader);
    }

    private static /* synthetic */ Class<?> __privileged_org_apache_bval_util_reflection_Reflection$$toClass(String string, boolean bl, ClassLoader classLoader) throws ClassNotFoundException {
        Field[] fieldArray = new Field[1];
        BitSet bitSet = new BitSet(1);
        int n = 0;
        fieldArray[n] = Reflection.class.getDeclaredField("NATIVE_CODES");
        if (fieldArray[n].isAccessible()) {
            Field cfr_ignored_0 = fieldArray[n];
            bitSet.set(n);
        } else {
            fieldArray[n].setAccessible(true);
        }
        ++n;
        try {
            Validate.notNull(string, "className was null", new Object[0]);
            int n2 = 0;
            while (string.endsWith("[]")) {
                ++n2;
                string = string.substring(0, string.length() - 2);
            }
            boolean bl2 = false;
            if (string.indexOf(46) == -1) {
                int n3 = 0;
                while (!bl2) {
                    if (n3 >= ((Object[][])fieldArray[0].get(null)).length) break;
                    if (((Object[][])fieldArray[0].get(null))[n3][1].equals(string)) {
                        if (n2 == 0) {
                            Class clazz = (Class)((Object[][])fieldArray[0].get(null))[n3][0];
                            for (n = 0; n < 1; ++n) {
                                if (bitSet.get(n)) continue;
                                fieldArray[n].setAccessible(false);
                            }
                            return clazz;
                        }
                        string = (String)((Object[][])fieldArray[0].get(null))[n3][2];
                        bl2 = true;
                    }
                    ++n3;
                }
            }
            if (n2 > 0) {
                StringBuilder stringBuilder = new StringBuilder(string.length() + n2 + 2);
                for (int i = 0; i < n2; ++i) {
                    stringBuilder.append('[');
                }
                if (!bl2) {
                    stringBuilder.append('L');
                }
                stringBuilder.append(string);
                if (!bl2) {
                    stringBuilder.append(';');
                }
                string = stringBuilder.toString();
            }
            if (classLoader == null) {
                classLoader = Thread.currentThread().getContextClassLoader();
            }
            Class<?> clazz = Class.forName(string, bl, classLoader);
            for (n = 0; n < 1; ++n) {
                if (bitSet.get(n)) continue;
                fieldArray[n].setAccessible(false);
            }
            return clazz;
        }
        catch (Throwable throwable) {
            for (n = 0; n < 1; ++n) {
                if (bitSet.get(n)) continue;
                fieldArray[n].setAccessible(false);
            }
            throw throwable;
        }
    }

    @Privileged
    private static /* synthetic */ Class<?> org_apache_bval_util_reflection_Reflection$$toClass(String string, ClassLoader classLoader) throws ClassNotFoundException {
        if (!(System.getSecurityManager() != null)) {
            return ValidationMappingParser.__privileged_org_apache_bval_util_reflection_Reflection$$toClass(string, false, classLoader);
        }
        try {
            return (Class)AccessController.doPrivileged(new ValidationMappingParser$org_apache_bval_util_reflection_Reflection$$toClass$$Ljava_lang_String$Ljava_lang_ClassLoader$_ACTION(string, classLoader));
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw privilegedActionException.getException();
        }
    }

    static /* synthetic */ Class __privileged_access$2(String string, ClassLoader classLoader) throws Exception {
        return ValidationMappingParser.__privileged_org_apache_bval_util_reflection_Reflection$$toClass(string, false, classLoader);
    }

    private String toQualifiedClassName(String className, String defaultPackage) {
        if (!this.isQualifiedClass(className)) {
            className = className.startsWith("[L") && className.endsWith(";") ? "[L" + defaultPackage + '.' + className.substring(2) : defaultPackage + '.' + className;
        }
        return className;
    }

    private boolean isQualifiedClass(String clazz) {
        return clazz.indexOf(46) >= 0;
    }

    private static void __privileged_clinit0() {
        SCHEMA_MANAGER = new SchemaManager.Builder().add(XmlBuilder.Version.v10.getId(), "http://jboss.org/xml/ns/javax/validation/mapping", "META-INF/validation-mapping-1.0.xsd").add(XmlBuilder.Version.v11.getId(), "http://jboss.org/xml/ns/javax/validation/mapping", "META-INF/validation-mapping-1.1.xsd").add(XmlBuilder.Version.v20.getId(), "http://xmlns.jcp.org/xml/ns/validation/mapping", "META-INF/validation-mapping-2.0.xsd").build();
    }

    static {
        ValidationMappingParser.__privileged_clinit0();
    }
}

