/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.junit5;

import java.util.ArrayList;
import org.apache.openejb.OpenEJBRuntimeException;
import org.apache.openejb.junit5.ApplicationComposerPerXYExtensionBase;
import org.apache.openejb.testing.Component;
import org.apache.openejb.testing.Default;
import org.apache.openejb.testing.Jars;
import org.apache.openejb.testing.Module;
import org.apache.openejb.testing.SingleApplicationComposerBase;
import org.apache.openejb.util.Classes;
import org.apache.xbean.finder.ClassFinder;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;

public class ApplicationComposerPerJVMExtension
extends ApplicationComposerPerXYExtensionBase
implements BeforeAllCallback,
AfterAllCallback,
BeforeEachCallback,
AfterEachCallback {
    private static final SingleApplicationComposerBase BASE = new SingleApplicationComposerBase();

    @Override
    protected void validate(ExtensionContext context) {
        Class[] toCheck;
        if (!this.isPerJvm(context) && BASE.isStarted()) {
            throw new OpenEJBRuntimeException("Cannot run PER_JVM in combination with PER_ALL, PER_EACH or AUTO");
        }
        Class clazz = (Class)context.getTestClass().orElseThrow(() -> new OpenEJBRuntimeException("Could not obtain test class from extension context"));
        ArrayList<Exception> errors = new ArrayList<Exception>();
        ClassFinder classFinder = new ClassFinder(Classes.ancestors((Class)clazz));
        for (Class annotation : toCheck = new Class[]{Component.class, Module.class, org.apache.openejb.testing.Classes.class, Default.class, Jars.class}) {
            if (!classFinder.isAnnotationPresent(annotation)) continue;
            errors.add(new Exception("@" + annotation.getName() + " is not allowed with @Application in PER_JVM mode"));
        }
        if (!errors.isEmpty()) {
            throw new OpenEJBRuntimeException(((Object)errors).toString());
        }
    }

    @Override
    public void beforeAll(ExtensionContext context) throws Exception {
        super.beforeAll(context);
        this.doInit(context);
        this.doStart(context);
        if (this.isPerClassLifecycle(context)) {
            this.doInject(context);
        }
    }

    @Override
    public void beforeEach(ExtensionContext context) {
        if (this.isPerMethodLifecycle(context)) {
            this.doInject(context);
        }
    }

    @Override
    void doInit(ExtensionContext extensionContext) {
    }

    @Override
    void doStart(ExtensionContext extensionContext) throws Exception {
        BASE.start((Class)extensionContext.getTestClass().orElse(null));
    }

    @Override
    void doInject(Object target, ExtensionContext context) throws Exception {
        BASE.composerInject(target);
    }

    public static boolean isStarted() {
        return BASE.isStarted();
    }
}

