/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.junit5;

import java.lang.reflect.AnnotatedElement;
import org.apache.openejb.junit5.ExtensionMode;
import org.apache.openejb.junit5.RunWithApplicationComposer;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.platform.commons.util.AnnotationUtils;

public abstract class ApplicationComposerExtensionBase {
    boolean isPerClassLifecycle(ExtensionContext context) {
        return this.isPerTestInstanceLifecycle(context, TestInstance.Lifecycle.PER_CLASS);
    }

    boolean isPerMethodLifecycle(ExtensionContext context) {
        return this.isPerTestInstanceLifecycle(context, TestInstance.Lifecycle.PER_METHOD);
    }

    boolean isPerTestInstanceLifecycle(ExtensionContext context, TestInstance.Lifecycle lifecycle) {
        return context.getTestInstanceLifecycle().map(it -> it.equals((Object)lifecycle)).orElse(false);
    }

    protected boolean isPerEach(ExtensionContext context) {
        return this.checkMode(context, ExtensionMode.PER_EACH);
    }

    boolean isPerAll(ExtensionContext context) {
        return this.checkMode(context, ExtensionMode.PER_ALL);
    }

    boolean isPerJvm(ExtensionContext context) {
        return this.checkMode(context, ExtensionMode.PER_JVM);
    }

    boolean isPerDefault(ExtensionContext context) {
        return this.checkMode(context, ExtensionMode.AUTO);
    }

    boolean checkMode(ExtensionContext context, ExtensionMode extensionMode) {
        return extensionMode == this.getModeFromAnnotation(context);
    }

    ExtensionMode getModeFromAnnotation(ExtensionContext context) {
        return context.getTestClass().flatMap(test -> AnnotationUtils.findAnnotation((AnnotatedElement)test, RunWithApplicationComposer.class)).map(RunWithApplicationComposer::mode).orElse(ExtensionMode.AUTO);
    }
}

