/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.junit5;

import org.apache.openejb.OpenEJBRuntimeException;
import org.apache.openejb.junit5.ApplicationComposerExtensionBase;
import org.apache.openejb.junit5.ApplicationComposerPerAllExtension;
import org.apache.openejb.junit5.ApplicationComposerPerDefaultExtension;
import org.apache.openejb.junit5.ApplicationComposerPerEachExtension;
import org.apache.openejb.junit5.ApplicationComposerPerJVMExtension;
import org.apache.openejb.junit5.ApplicationComposerPerXYExtensionBase;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;

public class ApplicationComposerExtension
extends ApplicationComposerExtensionBase
implements BeforeAllCallback,
AfterAllCallback,
BeforeEachCallback,
AfterEachCallback {
    private static final ExtensionContext.Namespace NAMESPACE = ExtensionContext.Namespace.create((Object[])new Object[]{ApplicationComposerExtension.class.getName()});
    private final Object[] modules;

    public ApplicationComposerExtension() {
        this(null);
    }

    public ApplicationComposerExtension(Object ... modules) {
        this.modules = modules;
    }

    public void beforeAll(ExtensionContext context) throws Exception {
        if (this.isPerJvm(context)) {
            if (this.modules != null && this.modules.length > 0) {
                throw new IllegalArgumentException("Modules are not supported in PER_JVM mode. Set 'tomee.application-composer.application' system property.");
            }
            context.getStore(NAMESPACE).put(ApplicationComposerPerXYExtensionBase.class, (Object)new ApplicationComposerPerJVMExtension());
        } else if (this.isPerAll(context)) {
            context.getStore(NAMESPACE).put(ApplicationComposerPerXYExtensionBase.class, (Object)new ApplicationComposerPerAllExtension(this.modules));
        } else if (this.isPerEach(context)) {
            context.getStore(NAMESPACE).put(ApplicationComposerPerXYExtensionBase.class, (Object)new ApplicationComposerPerEachExtension(this.modules));
        } else if (this.isPerDefault(context)) {
            context.getStore(NAMESPACE).put(ApplicationComposerPerXYExtensionBase.class, (Object)new ApplicationComposerPerDefaultExtension(this.modules));
        } else {
            throw new OpenEJBRuntimeException("No ExtensionMode is present.");
        }
        ((ApplicationComposerPerXYExtensionBase)context.getStore(NAMESPACE).get(ApplicationComposerPerXYExtensionBase.class, ApplicationComposerPerXYExtensionBase.class)).beforeAll(context);
    }

    public void afterAll(ExtensionContext context) throws Exception {
        ApplicationComposerPerXYExtensionBase delegate = (ApplicationComposerPerXYExtensionBase)context.getStore(NAMESPACE).get(ApplicationComposerPerXYExtensionBase.class, ApplicationComposerPerXYExtensionBase.class);
        if (delegate != null) {
            delegate.afterAll(context);
        }
    }

    public void beforeEach(ExtensionContext context) throws Exception {
        ApplicationComposerPerXYExtensionBase delegate = (ApplicationComposerPerXYExtensionBase)context.getStore(NAMESPACE).get(ApplicationComposerPerXYExtensionBase.class, ApplicationComposerPerXYExtensionBase.class);
        if (delegate != null) {
            delegate.beforeEach(context);
        }
    }

    public void afterEach(ExtensionContext context) throws Exception {
        ApplicationComposerPerXYExtensionBase delegate = (ApplicationComposerPerXYExtensionBase)context.getStore(NAMESPACE).get(ApplicationComposerPerXYExtensionBase.class, ApplicationComposerPerXYExtensionBase.class);
        if (delegate != null) {
            delegate.afterEach(context);
        }
    }
}

