/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.junit5.jee.transaction;

import jakarta.transaction.TransactionManager;
import java.lang.reflect.Method;
import org.apache.openejb.OpenEJBRuntimeException;
import org.apache.openejb.core.transaction.JtaTransactionPolicyFactory;
import org.apache.openejb.core.transaction.TransactionPolicy;
import org.apache.openejb.core.transaction.TransactionType;
import org.apache.openejb.junit.jee.transaction.Transaction;
import org.apache.openejb.loader.SystemInstance;
import org.junit.jupiter.api.extension.AfterTestExecutionCallback;
import org.junit.jupiter.api.extension.ExtensionContext;

public class TransactionExtension
implements AfterTestExecutionCallback {
    public void afterTestExecution(ExtensionContext extensionContext) throws Exception {
        Method mtd = (Method)extensionContext.getTestMethod().orElseThrow(() -> new OpenEJBRuntimeException("Could not get test method from extension context."));
        Transaction tx = mtd.getAnnotation(Transaction.class);
        if (tx != null) {
            TransactionManager transactionManager = (TransactionManager)SystemInstance.get().getComponent(TransactionManager.class);
            JtaTransactionPolicyFactory factory = new JtaTransactionPolicyFactory(transactionManager);
            TransactionPolicy policy = factory.createTransactionPolicy(TransactionType.RequiresNew);
            if (tx.rollback()) {
                policy.setRollbackOnly();
            }
            policy.commit();
        }
    }
}

