/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.junit5;

import java.lang.reflect.Method;
import org.apache.openejb.junit.context.OpenEjbTestContext;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;

public class OpenEjbExtension
implements BeforeEachCallback,
AfterEachCallback {
    private final String role;
    private OpenEjbTestContext classTestContext;

    public OpenEjbExtension() {
        this(null);
    }

    public OpenEjbExtension(String role) {
        this.role = role;
    }

    public void beforeEach(ExtensionContext extensionContext) throws Exception {
        this.classTestContext = this.newTestContext(extensionContext, this.role);
        this.classTestContext.configureTest(extensionContext.getTestInstance().get());
    }

    public OpenEjbTestContext newTestContext(ExtensionContext extensionContext, String roleName) {
        if (!extensionContext.getTestMethod().isPresent()) {
            if (this.classTestContext == null) {
                this.classTestContext = new OpenEjbTestContext((Class)extensionContext.getTestClass().get());
            }
            return this.classTestContext;
        }
        return new OpenEjbTestContext((Method)extensionContext.getTestMethod().get(), roleName);
    }

    public void afterEach(ExtensionContext extensionContext) throws Exception {
        if (this.classTestContext != null) {
            this.classTestContext.close();
        }
    }
}

