/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.junit.jee;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.openejb.junit.jee.InjectRule;
import org.apache.openejb.junit.jee.statement.ShutingDownStatement;
import org.apache.openejb.junit.jee.statement.StartingStatement;
import org.apache.openejb.junit.jee.transaction.TransactionRule;
import org.junit.Rule;
import org.junit.rules.TestRule;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.Statement;

public class EJBContainerRunner
extends BlockJUnit4ClassRunner {
    private StartingStatement startingStatement;

    public EJBContainerRunner(Class<?> klass) throws InitializationError {
        super(klass);
    }

    protected Statement withBeforeClasses(Statement statement) {
        this.startingStatement = new StartingStatement(super.withBeforeClasses(statement), this.getTestClass().getJavaClass());
        return this.startingStatement;
    }

    protected Statement withAfterClasses(Statement statement) {
        return new ShutingDownStatement(super.withAfterClasses(statement), this.startingStatement);
    }

    protected List<FrameworkMethod> computeTestMethods() {
        ArrayList<FrameworkMethod> methods = new ArrayList<FrameworkMethod>(super.computeTestMethods());
        Collections.shuffle(methods);
        return methods;
    }

    protected List<TestRule> getTestRules(Object target) {
        ArrayList<TestRule> rules = new ArrayList<TestRule>();
        rules.add(new InjectRule(target, this.startingStatement));
        rules.add(new TransactionRule());
        rules.addAll(this.getTestClass().getAnnotatedFieldValues(target, Rule.class, TestRule.class));
        return rules;
    }
}

