/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.junit.context;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;

public final class Util {
    private Util() {
    }

    public static boolean isInstance(Class type, Object instance) {
        if (type.isPrimitive()) {
            if (instance == null) {
                return false;
            }
            if (type.equals(Boolean.TYPE)) {
                return instance instanceof Boolean;
            }
            if (type.equals(Character.TYPE)) {
                return instance instanceof Character;
            }
            if (type.equals(Byte.TYPE)) {
                return instance instanceof Byte;
            }
            if (type.equals(Short.TYPE)) {
                return instance instanceof Short;
            }
            if (type.equals(Integer.TYPE)) {
                return instance instanceof Integer;
            }
            if (type.equals(Long.TYPE)) {
                return instance instanceof Long;
            }
            if (type.equals(Float.TYPE)) {
                return instance instanceof Float;
            }
            if (type.equals(Double.TYPE)) {
                return instance instanceof Double;
            }
            throw new AssertionError((Object)("Invalid primitve type: " + String.valueOf(type)));
        }
        return instance == null || type.isInstance(instance);
    }

    public static void addProperty(Hashtable env, String property) {
        String value;
        String name;
        if (property == null || property.length() == 0) {
            throw new IllegalArgumentException("No property specified.");
        }
        if (property.charAt(0) == '=') {
            throw new IllegalArgumentException("Invalid property has no name: " + property);
        }
        int esp = (property = property.trim()).indexOf(61);
        if (esp < 0) {
            name = property;
            value = "";
        } else {
            name = property.substring(0, esp).trim();
            value = property.length() > esp ? property.substring(esp + 1).trim() : "";
        }
        env.put(name, value);
    }

    public static Method findSetter(Class<?> testClazz, Field field, Object propertyValue) {
        String propertyName = field.getName();
        boolean isStatic = Modifier.isStatic(field.getModifiers());
        String setterName = "set" + Character.toUpperCase(propertyName.charAt(0)) + propertyName.substring(1);
        ArrayList<Method> methods = new ArrayList<Method>(Arrays.asList(testClazz.getMethods()));
        methods.addAll(Arrays.asList(testClazz.getDeclaredMethods()));
        Method unpreferredValidMethod = null;
        for (Method clazzMethod : methods) {
            Class<?> methodParameterType;
            if (!clazzMethod.getName().equals(setterName) || clazzMethod.getParameterTypes().length == 0 || clazzMethod.getParameterTypes().length > 1 || clazzMethod.getReturnType() != Void.TYPE || Modifier.isAbstract(clazzMethod.getModifiers()) || (methodParameterType = clazzMethod.getParameterTypes()[0]).isPrimitive() && propertyValue == null || !isStatic && Modifier.isStatic(clazzMethod.getModifiers())) continue;
            if (!Modifier.isPublic(clazzMethod.getModifiers())) {
                clazzMethod.setAccessible(true);
            }
            if (!Util.isInstance(methodParameterType, propertyValue)) continue;
            if (methodParameterType != propertyValue.getClass()) {
                if (unpreferredValidMethod == null) {
                    unpreferredValidMethod = clazzMethod;
                    continue;
                }
                unpreferredValidMethod = Util.getMostSpecificMethod(unpreferredValidMethod, clazzMethod);
                continue;
            }
            return clazzMethod;
        }
        return unpreferredValidMethod;
    }

    public static Method getMostSpecificMethod(Method method1, Method method2) {
        Class<?> class2;
        Class<?> class1 = method1.getParameterTypes()[0];
        if (class1.isAssignableFrom(class2 = method2.getParameterTypes()[0])) {
            return method2;
        }
        return method1;
    }
}

