/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.junit;

import java.lang.reflect.Method;
import java.util.Collections;
import junit.framework.TestCase;
import org.apache.openejb.junit.JUnit4Runner;
import org.apache.openejb.junit.context.OpenEjbTestContext;
import org.apache.openejb.junit.context.TestContext;
import org.junit.runner.Description;
import org.junit.runner.Runner;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.model.InitializationError;

public class OpenEjbRunner
extends Runner {
    private final Runner delegate;
    private final Class<?> testClazz;
    private TestContext classTestContext;

    public OpenEjbRunner(Class<?> testClazz) throws InitializationError {
        this.testClazz = testClazz;
        try {
            this.delegate = this.getDelegateRunner(testClazz);
        }
        catch (Throwable e) {
            throw new InitializationError(Collections.singletonList(e));
        }
    }

    protected Runner getDelegateRunner(Class<?> testClazz) throws Throwable {
        if (TestCase.class.isAssignableFrom(testClazz)) {
            throw new UnsupportedOperationException("JUnit 3 tests not supported yet.");
        }
        return new JUnit4Runner(this, testClazz);
    }

    public TestContext newTestContext(Method method) {
        return this.newTestContext(method, null);
    }

    public TestContext newTestContext(Method method, String roleName) {
        if (method == null) {
            if (this.classTestContext == null) {
                this.classTestContext = new OpenEjbTestContext(this.testClazz);
            }
            return this.classTestContext;
        }
        return new OpenEjbTestContext(method, roleName);
    }

    public Description getDescription() {
        return this.delegate.getDescription();
    }

    public void run(RunNotifier runNotifier) {
        this.delegate.run(runNotifier);
    }

    public int testCount() {
        return this.delegate.testCount();
    }

    protected Class<?> getTestClass() {
        return this.testClazz;
    }
}

