/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.test.stateless;

import jakarta.ejb.EJBObject;
import org.apache.openejb.test.entity.bmp.EncBmpHome;
import org.apache.openejb.test.entity.bmp.EncBmpObject;
import org.apache.openejb.test.entity.cmp.EncCmpHome;
import org.apache.openejb.test.entity.cmp.EncCmpObject;
import org.apache.openejb.test.stateful.EncStatefulHome;
import org.apache.openejb.test.stateful.EncStatefulObject;
import org.apache.openejb.test.stateless.BasicStatelessHome;
import org.apache.openejb.test.stateless.BasicStatelessTestClient;
import org.apache.openejb.test.stateless.EncStatelessHome;
import org.apache.openejb.test.stateless.EncStatelessObject;

public class MiscEjbTests
extends BasicStatelessTestClient {
    public MiscEjbTests() {
        super("EJBObject.");
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        Object obj = this.initialContext.lookup("client/tests/stateless/BasicStatelessHome");
        this.ejbHome = (BasicStatelessHome)obj;
        this.ejbObject = this.ejbHome.createObject();
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void test01_isIdentical_stateless() {
        try {
            String jndiName = "client/tests/stateless/EncBean";
            EncStatelessHome ejbHome2 = null;
            EncStatelessObject ejbObject2 = null;
            Object obj = this.initialContext.lookup("client/tests/stateless/EncBean");
            ejbHome2 = (EncStatelessHome)obj;
            ejbObject2 = ejbHome2.create();
            MiscEjbTests.assertTrue((String)"The EJBObjects should not be identical", (!this.ejbObject.isIdentical((EJBObject)ejbObject2) ? 1 : 0) != 0);
        }
        catch (Exception e) {
            MiscEjbTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test02_isIdentical_stateful() {
        try {
            String jndiName = "client/tests/stateful/EncBean";
            EncStatefulHome ejbHome2 = null;
            EncStatefulObject ejbObject2 = null;
            Object obj = this.initialContext.lookup("client/tests/stateful/EncBean");
            ejbHome2 = (EncStatefulHome)obj;
            ejbObject2 = ejbHome2.create("isIdentical test");
            MiscEjbTests.assertTrue((String)"The EJBObjects should not be identical", (!this.ejbObject.isIdentical((EJBObject)ejbObject2) ? 1 : 0) != 0);
        }
        catch (Exception e) {
            MiscEjbTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test03_isIdentical_bmp() {
        try {
            String jndiName = "client/tests/entity/bmp/EncBean";
            EncBmpHome ejbHome2 = null;
            EncBmpObject ejbObject2 = null;
            Object obj = this.initialContext.lookup("client/tests/entity/bmp/EncBean");
            ejbHome2 = (EncBmpHome)obj;
            ejbObject2 = ejbHome2.create("isIdentical test");
            MiscEjbTests.assertTrue((String)"The EJBObjects should not be identical", (!this.ejbObject.isIdentical((EJBObject)ejbObject2) ? 1 : 0) != 0);
        }
        catch (Exception e) {
            MiscEjbTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void _test04_isIdentical_cmp() {
        try {
            String jndiName = "client/tests/entity/cmp/EncBean";
            EncCmpHome ejbHome2 = null;
            EncCmpObject ejbObject2 = null;
            Object obj = this.initialContext.lookup("client/tests/entity/cmp/EncBean");
            ejbHome2 = (EncCmpHome)obj;
            ejbObject2 = ejbHome2.create("isIdentical test");
            MiscEjbTests.assertTrue((String)"The EJBObjects should not be identical", (!this.ejbObject.isIdentical((EJBObject)ejbObject2) ? 1 : 0) != 0);
        }
        catch (Exception e) {
            MiscEjbTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }
}

