/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.test.stateful;

import org.apache.openejb.test.object.OperationsPolicy;
import org.apache.openejb.test.stateful.BasicStatefulHome;
import org.apache.openejb.test.stateful.BasicStatefulTestClient;

public class BMTStatefulAllowedOperationsTests
extends BasicStatefulTestClient {
    public BMTStatefulAllowedOperationsTests() {
        super("BMTAllowedOperations.");
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        Object obj = this.initialContext.lookup("client/tests/stateful/BeanManagedBasicStatefulHome");
        this.ejbHome = (BasicStatefulHome)obj;
        this.ejbObject = this.ejbHome.createObject("Fifth Bean");
        this.ejbHandle = this.ejbObject.getHandle();
    }

    @Override
    protected void tearDown() throws Exception {
        this.ejbObject.remove();
        super.tearDown();
    }

    public void test01_setSessionContext() {
        try {
            OperationsPolicy policy = new OperationsPolicy();
            policy.allow(0);
            policy.allow(8);
            OperationsPolicy expected = policy;
            OperationsPolicy actual = this.ejbObject.getAllowedOperationsReport("setSessionContext");
            BMTStatefulAllowedOperationsTests.assertNotNull((String)"The OperationsPolicy is null", (Object)actual);
            BMTStatefulAllowedOperationsTests.assertEquals((Object)expected, (Object)actual);
        }
        catch (Exception e) {
            BMTStatefulAllowedOperationsTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test02_ejbCreate() {
        try {
            OperationsPolicy policy = new OperationsPolicy();
            policy.allow(0);
            policy.allow(1);
            policy.allow(2);
            policy.allow(6);
            policy.allow(5);
            policy.allow(8);
            OperationsPolicy expected = policy;
            OperationsPolicy actual = this.ejbObject.getAllowedOperationsReport("ejbCreate");
            BMTStatefulAllowedOperationsTests.assertNotNull((String)"The OperationsPolicy is null", (Object)actual);
            BMTStatefulAllowedOperationsTests.assertEquals((Object)expected, (Object)actual);
        }
        catch (Exception e) {
            BMTStatefulAllowedOperationsTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test03_ejbRemove() {
        try {
            OperationsPolicy policy = new OperationsPolicy();
            policy.allow(0);
            policy.allow(1);
            policy.allow(2);
            policy.allow(6);
            policy.allow(5);
            policy.allow(8);
            OperationsPolicy expected = policy;
            OperationsPolicy actual = this.ejbObject.getAllowedOperationsReport("ejbRemove");
            BMTStatefulAllowedOperationsTests.assertNotNull((String)"The OperationsPolicy is null", (Object)actual);
            BMTStatefulAllowedOperationsTests.assertEquals((Object)expected, (Object)actual);
        }
        catch (Exception e) {
            BMTStatefulAllowedOperationsTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test04_ejbActivate() {
        try {
            OperationsPolicy policy = new OperationsPolicy();
            policy.allow(0);
            policy.allow(1);
            policy.allow(2);
            policy.allow(6);
            policy.allow(5);
            policy.allow(8);
            OperationsPolicy expected = policy;
            OperationsPolicy actual = this.ejbObject.getAllowedOperationsReport("ejbActivate");
            BMTStatefulAllowedOperationsTests.assertNotNull((String)"The OperationsPolicy is null", (Object)actual);
            BMTStatefulAllowedOperationsTests.assertEquals((Object)expected, (Object)actual);
        }
        catch (Exception e) {
            BMTStatefulAllowedOperationsTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test05_ejbPassivate() {
        try {
            OperationsPolicy policy = new OperationsPolicy();
            policy.allow(0);
            policy.allow(1);
            policy.allow(2);
            policy.allow(6);
            policy.allow(5);
            policy.allow(8);
            OperationsPolicy expected = policy;
            OperationsPolicy actual = this.ejbObject.getAllowedOperationsReport("ejbPassivate");
            BMTStatefulAllowedOperationsTests.assertNotNull((String)"The OperationsPolicy is null", (Object)actual);
            BMTStatefulAllowedOperationsTests.assertEquals((Object)expected, (Object)actual);
        }
        catch (Exception e) {
            BMTStatefulAllowedOperationsTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test06_businessMethod() {
        try {
            OperationsPolicy policy = new OperationsPolicy();
            policy.allow(0);
            policy.allow(1);
            policy.allow(2);
            policy.allow(6);
            policy.allow(5);
            policy.allow(8);
            OperationsPolicy expected = policy;
            OperationsPolicy actual = this.ejbObject.getAllowedOperationsReport("businessMethod");
            BMTStatefulAllowedOperationsTests.assertNotNull((String)"The OperationsPolicy is null", (Object)actual);
            BMTStatefulAllowedOperationsTests.assertEquals((Object)expected, (Object)actual);
        }
        catch (Exception e) {
            BMTStatefulAllowedOperationsTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }
}

