/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.test.singleton;

import jakarta.ejb.EJBHome;
import jakarta.ejb.EJBObject;
import java.rmi.RemoteException;
import org.apache.openejb.test.singleton.BasicSingletonHome;
import org.apache.openejb.test.singleton.BasicSingletonObject;
import org.apache.openejb.test.singleton.BasicSingletonTestClient;

public class SingletonPojoEjbObjectTests
extends BasicSingletonTestClient {
    public SingletonPojoEjbObjectTests() {
        super("PojoEJBObject.");
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        Object obj = this.initialContext.lookup("client/tests/singleton/BasicSingletonPojoHome");
        this.ejbHome = (BasicSingletonHome)obj;
        this.ejbObject = this.ejbHome.createObject();
    }

    public void test01_getEjbHome() {
        try {
            EJBHome home = this.ejbObject.getEJBHome();
            SingletonPojoEjbObjectTests.assertNotNull((String)"The EJBHome is null", (Object)home);
        }
        catch (Exception e) {
            SingletonPojoEjbObjectTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test02_getHandle() {
        try {
            this.ejbHandle = this.ejbObject.getHandle();
            SingletonPojoEjbObjectTests.assertNotNull((String)"The Handle is null", (Object)this.ejbHandle);
        }
        catch (Exception e) {
            SingletonPojoEjbObjectTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test03_isIdentical() {
        BasicSingletonObject otherEJBObject = null;
        try {
            otherEJBObject = this.ejbHome.createObject();
            SingletonPojoEjbObjectTests.assertTrue((String)"The EJBObjects are not identical", (boolean)this.ejbObject.isIdentical((EJBObject)this.ejbObject));
            SingletonPojoEjbObjectTests.assertTrue((String)"The EJBObject and the OtherEJBObject are not identical", (boolean)this.ejbObject.isIdentical((EJBObject)otherEJBObject));
        }
        catch (Exception e) {
            SingletonPojoEjbObjectTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test04_remove() {
        try {
            this.ejbObject.remove();
            this.ejbObject.businessMethod("Should not throw an exception");
        }
        catch (Exception e) {
            SingletonPojoEjbObjectTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test05_getPrimaryKey() {
        try {
            Object object = this.ejbObject.getPrimaryKey();
        }
        catch (RemoteException e) {
            SingletonPojoEjbObjectTests.assertTrue((boolean)true);
            return;
        }
        catch (Exception e) {
            SingletonPojoEjbObjectTests.fail((String)("A RuntimeException should have been thrown.  Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
        SingletonPojoEjbObjectTests.fail((String)"A RuntimeException should have been thrown.");
    }
}

