/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.test.entity.cmp2;

import jakarta.ejb.EJBHome;
import jakarta.ejb.EJBObject;
import jakarta.ejb.ObjectNotFoundException;
import org.apache.openejb.test.entity.cmp.ComplexCmpBeanPk;
import org.apache.openejb.test.entity.cmp.ComplexCmpHome;
import org.apache.openejb.test.entity.cmp2.ComplexCmp2TestClient;

public class Complex2EjbObjectTests
extends ComplexCmp2TestClient {
    public Complex2EjbObjectTests() {
        super("EJBObject.");
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        Object obj = this.initialContext.lookup("client/tests/entity/cmp2/ComplexCmpHome");
        this.ejbHome = (ComplexCmpHome)obj;
        this.ejbObject = this.ejbHome.createObject("Third Bean");
    }

    @Override
    protected void tearDown() throws Exception {
        if (this.ejbObject != null) {
            this.ejbObject.remove();
        }
        super.tearDown();
    }

    public void test01_getHandle() {
        try {
            this.ejbHandle = this.ejbObject.getHandle();
            Complex2EjbObjectTests.assertNotNull((String)"The Handle is null", (Object)this.ejbHandle);
        }
        catch (Exception e) {
            Complex2EjbObjectTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test02_getPrimaryKey() {
        try {
            this.ejbPrimaryKey = this.ejbObject.getPrimaryKey();
            Complex2EjbObjectTests.assertNotNull((String)"The primary key is null", (Object)this.ejbPrimaryKey);
        }
        catch (Exception e) {
            e.printStackTrace();
            Complex2EjbObjectTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test03_isIdentical() {
        try {
            Complex2EjbObjectTests.assertTrue((String)"The EJBObjects are not equal", (boolean)this.ejbObject.isIdentical((EJBObject)this.ejbObject));
        }
        catch (Exception e) {
            Complex2EjbObjectTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test04_getEjbHome() {
        try {
            EJBHome home = this.ejbObject.getEJBHome();
            Complex2EjbObjectTests.assertNotNull((String)"The EJBHome is null", (Object)home);
        }
        catch (Exception e) {
            Complex2EjbObjectTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test05_remove() {
        try {
            this.ejbObject.remove();
            try {
                this.ejbHome.findByPrimaryKey((ComplexCmpBeanPk)this.ejbPrimaryKey);
                Complex2EjbObjectTests.fail((String)"Entity was not actually removed");
            }
            catch (ObjectNotFoundException objectNotFoundException) {
                // empty catch block
            }
            try {
                this.ejbObject.businessMethod("Should throw an exception");
                Complex2EjbObjectTests.assertTrue((String)"Calling business method after removing the EJBObject does not throw an exception", (boolean)false);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        catch (Exception e) {
            Complex2EjbObjectTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
        finally {
            this.ejbObject = null;
        }
    }
}

