/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.server.hessian;

import jakarta.servlet.Servlet;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Engine;
import org.apache.catalina.Service;
import org.apache.catalina.Valve;
import org.apache.catalina.Wrapper;
import org.apache.catalina.authenticator.BasicAuthenticator;
import org.apache.catalina.authenticator.DigestAuthenticator;
import org.apache.catalina.authenticator.NonLoginAuthenticator;
import org.apache.catalina.authenticator.SSLAuthenticator;
import org.apache.catalina.connector.Connector;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.core.StandardServer;
import org.apache.commons.lang3.tuple.MutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.openejb.assembler.classic.WebAppBuilder;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.server.hessian.HessianRegistry;
import org.apache.openejb.server.hessian.HessianServer;
import org.apache.openejb.server.hessian.OpenEJBHessianServlet;
import org.apache.openejb.server.httpd.util.HttpUtil;
import org.apache.tomcat.util.descriptor.web.LoginConfig;
import org.apache.tomcat.util.descriptor.web.SecurityCollection;
import org.apache.tomcat.util.descriptor.web.SecurityConstraint;
import org.apache.tomee.catalina.IgnoredStandardContext;
import org.apache.tomee.catalina.OpenEJBValve;
import org.apache.tomee.catalina.TomcatWebAppBuilder;
import org.apache.tomee.loader.TomcatHelper;

public class TomcatHessianRegistry
implements HessianRegistry {
    private static final String TOMEE_HESSIAN_SECURITY_ROLE_PREFIX = "tomee.hessian.security-role.";
    private final Map<String, Pair<Context, Integer>> fakeContexts = new HashMap<String, Pair<Context, Integer>>();
    private Engine engine;
    private List<Connector> connectors;

    public TomcatHessianRegistry() {
        StandardServer standardServer = TomcatHelper.getServer();
        for (Service service : standardServer.findServices()) {
            if (!Engine.class.isInstance(service.getContainer())) continue;
            this.connectors = Arrays.asList(service.findConnectors());
            this.engine = (Engine)Engine.class.cast(service.getContainer());
            break;
        }
    }

    @Override
    public String deploy(ClassLoader loader, HessianServer listener, String hostname, String app, String authMethod, String transportGuarantee, String realmName, String name) throws URISyntaxException {
        String servletMapping;
        Wrapper wrapper;
        Container host = this.engine.findChild(hostname);
        if (host == null && (host = this.engine.findChild(this.engine.getDefaultHost())) == null) {
            throw new IllegalArgumentException("Invalid virtual host '" + this.engine.getDefaultHost() + "'.  Do you have a matchiing Host entry in the server.xml?");
        }
        String contextRoot = TomcatHessianRegistry.contextName(app);
        Context context = (Context)Context.class.cast(host.findChild(contextRoot));
        if (context == null) {
            Pair<Context, Integer> fakeContext = this.fakeContexts.get(contextRoot);
            if (fakeContext != null) {
                context = (Context)fakeContext.getLeft();
                fakeContext.setValue((Object)((Integer)fakeContext.getValue() + 1));
            } else {
                context = (Context)Context.class.cast(host.findChild(contextRoot));
                if (context == null) {
                    fakeContext = this.fakeContexts.get(contextRoot);
                    if (fakeContext == null) {
                        context = TomcatHessianRegistry.createNewContext(loader, authMethod, transportGuarantee, realmName, app);
                        fakeContext = new MutablePair((Object)context, (Object)1);
                        this.fakeContexts.put(contextRoot, fakeContext);
                    } else {
                        context = (Context)fakeContext.getLeft();
                        fakeContext.setValue((Object)((Integer)fakeContext.getValue() + 1));
                    }
                }
            }
        }
        if ((wrapper = (Wrapper)Wrapper.class.cast(context.findChild(servletMapping = TomcatHessianRegistry.generateServletPath(name)))) != null) {
            throw new IllegalArgumentException("Servlet " + servletMapping + " in web application context " + context.getName() + " already exists");
        }
        wrapper = context.createWrapper();
        wrapper.setName(HESSIAN.replace("/", "") + "_" + name);
        wrapper.setServlet((Servlet)new OpenEJBHessianServlet(listener));
        context.addChild((Container)wrapper);
        context.addServletMappingDecoded(servletMapping, wrapper.getName());
        if ("BASIC".equals(authMethod) && StandardContext.class.isInstance(context)) {
            StandardContext standardContext = (StandardContext)StandardContext.class.cast(context);
            boolean found = false;
            for (Valve v : standardContext.getPipeline().getValves()) {
                if (!LimitedBasicValve.class.isInstance(v) && !BasicAuthenticator.class.isInstance(v)) continue;
                found = true;
                break;
            }
            if (!found) {
                standardContext.addValve((Valve)new LimitedBasicValve());
            }
        }
        ArrayList<String> addresses = new ArrayList<String>();
        for (Connector connector : this.connectors) {
            for (String mapping : wrapper.findMappings()) {
                URI address = new URI(connector.getScheme(), null, host.getName(), connector.getPort(), contextRoot + mapping, null, null);
                addresses.add(address.toString());
            }
        }
        return HttpUtil.selectSingleAddress(addresses);
    }

    private static Context createNewContext(ClassLoader classLoader, String rAuthMethod, String rTransportGuarantee, String realmName, String name) {
        String transportGuarantee;
        Object path = name;
        if (path == null) {
            path = "/";
        }
        if (!((String)path).startsWith("/")) {
            path = "/" + (String)path;
        }
        IgnoredStandardContext context = new IgnoredStandardContext();
        context.setPath((String)path);
        context.setDocBase("");
        context.setParentClassLoader(classLoader);
        context.setDelegate(true);
        context.setName(name);
        ((TomcatWebAppBuilder)TomcatWebAppBuilder.class.cast(SystemInstance.get().getComponent(WebAppBuilder.class))).initJ2EEInfo((StandardContext)context);
        String authMethod = rAuthMethod;
        if (authMethod != null) {
            authMethod = authMethod.toUpperCase();
        }
        if ((transportGuarantee = rTransportGuarantee) != null) {
            transportGuarantee = transportGuarantee.toUpperCase();
        }
        if (authMethod != null & !"NONE".equals(authMethod)) {
            if ("BASIC".equals(authMethod) || "DIGEST".equals(authMethod) || "CLIENT-CERT".equals(authMethod)) {
                LoginConfig loginConfig = new LoginConfig();
                loginConfig.setAuthMethod(authMethod);
                loginConfig.setRealmName(realmName);
                context.setLoginConfig(loginConfig);
                String securityRole = SystemInstance.get().getProperty(TOMEE_HESSIAN_SECURITY_ROLE_PREFIX + name, "default");
                for (String role : securityRole.split(",")) {
                    SecurityCollection collection = new SecurityCollection();
                    collection.addMethod("GET");
                    collection.addMethod("POST");
                    collection.addPattern("/*");
                    collection.setName(role);
                    SecurityConstraint sc = new SecurityConstraint();
                    sc.addAuthRole("*");
                    sc.addCollection(collection);
                    sc.setAuthConstraint(true);
                    sc.setUserConstraint(transportGuarantee);
                    context.addConstraint(sc);
                    context.addSecurityRole(role);
                }
            }
            switch (authMethod) {
                case "BASIC": {
                    context.addValve((Valve)new BasicAuthenticator());
                    break;
                }
                case "DIGEST": {
                    context.addValve((Valve)new DigestAuthenticator());
                    break;
                }
                case "CLIENT-CERT": {
                    context.addValve((Valve)new SSLAuthenticator());
                    break;
                }
                case "NONE": {
                    context.addValve((Valve)new NonLoginAuthenticator());
                }
            }
        } else {
            throw new IllegalArgumentException("Invalid authMethod: " + authMethod);
        }
        context.getPipeline().addValve((Valve)new OpenEJBValve());
        return context;
    }

    private static String generateServletPath(String name) {
        return HESSIAN + name;
    }

    private static String contextName(String app) {
        if (!app.startsWith("/") && !app.isEmpty()) {
            return "/" + app;
        }
        return app;
    }

    @Override
    public void undeploy(String hostname, String app, String name) {
        Container host = this.engine.findChild(hostname);
        if (host == null && (host = this.engine.findChild(this.engine.getDefaultHost())) == null) {
            throw new IllegalArgumentException("Invalid virtual host '" + this.engine.getDefaultHost() + "'.  Do you have a matchiing Host entry in the server.xml?");
        }
        String contextRoot = TomcatHessianRegistry.contextName(app);
        Pair<Context, Integer> fakeContext = this.fakeContexts.get(contextRoot);
        if (fakeContext != null) {
            fakeContext.setValue((Object)((Integer)fakeContext.getValue() - 1));
            if ((Integer)fakeContext.getValue() == 0) {
                this.fakeContexts.remove(contextRoot);
                host.removeChild((Container)fakeContext.getKey());
            }
        }
    }

    protected static class LimitedBasicValve
    extends BasicAuthenticator {
        protected LimitedBasicValve() {
        }

        public void invoke(Request request, Response response) throws IOException, ServletException {
            String requestURI = request.getDecodedRequestURI();
            if (requestURI.startsWith(HessianRegistry.HESSIAN) && !this.authenticate(request, (HttpServletResponse)response)) {
                return;
            }
            this.getNext().invoke(request, response);
        }
    }
}

